/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThemeRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, UpdateThemeRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateThemeRequest.getter(UpdateThemeRequest::appId)).setter(UpdateThemeRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(UpdateThemeRequest.getter(UpdateThemeRequest::environmentName)).setter(UpdateThemeRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateThemeRequest.getter(UpdateThemeRequest::id)).setter(UpdateThemeRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateThemeRequest.getter(UpdateThemeRequest::clientToken)).setter(UpdateThemeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<UpdateThemeData> UPDATED_THEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updatedTheme").getter(UpdateThemeRequest.getter(UpdateThemeRequest::updatedTheme)).setter(UpdateThemeRequest.setter(Builder::updatedTheme)).constructor(UpdateThemeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedTheme").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, CLIENT_TOKEN_FIELD, UPDATED_THEME_FIELD));
    private final String appId;
    private final String environmentName;
    private final String id;
    private final String clientToken;
    private final UpdateThemeData updatedTheme;

    private UpdateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.clientToken = builder.clientToken;
        this.updatedTheme = builder.updatedTheme;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final UpdateThemeData updatedTheme() {
        return this.updatedTheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTheme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeRequest)) {
            return false;
        }
        UpdateThemeRequest other = (UpdateThemeRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.updatedTheme(), other.updatedTheme());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThemeRequest").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("ClientToken", (Object)this.clientToken()).add("UpdatedTheme", (Object)this.updatedTheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "updatedTheme": {
                return Optional.ofNullable(clazz.cast(this.updatedTheme()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeRequest, T> g) {
        return obj -> g.apply((UpdateThemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;
        private String id;
        private String clientToken;
        private UpdateThemeData updatedTheme;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeRequest model) {
            super(model);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.clientToken(model.clientToken);
            this.updatedTheme(model.updatedTheme);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final UpdateThemeData.Builder getUpdatedTheme() {
            return this.updatedTheme != null ? this.updatedTheme.toBuilder() : null;
        }

        public final void setUpdatedTheme(UpdateThemeData.BuilderImpl updatedTheme) {
            this.updatedTheme = updatedTheme != null ? updatedTheme.build() : null;
        }

        @Override
        public final Builder updatedTheme(UpdateThemeData updatedTheme) {
            this.updatedTheme = updatedTheme;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeRequest build() {
            return new UpdateThemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThemeRequest> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder clientToken(String var1);

        public Builder updatedTheme(UpdateThemeData var1);

        default public Builder updatedTheme(Consumer<UpdateThemeData.Builder> updatedTheme) {
            return this.updatedTheme((UpdateThemeData)((UpdateThemeData.Builder)UpdateThemeData.builder().applyMutation(updatedTheme)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

