/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TokenProviders {
    FIGMA("figma"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TokenProviders> VALUE_MAP;
    private final String value;

    private TokenProviders(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TokenProviders fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TokenProviders> knownValues() {
        EnumSet<TokenProviders> knownValues = EnumSet.allOf(TokenProviders.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TokenProviders.class, TokenProviders::toString);
    }
}

