/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.FixedPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldPosition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldPosition> {
    private static final SdkField<String> FIXED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fixed").getter(FieldPosition.getter(FieldPosition::fixedAsString)).setter(FieldPosition.setter(Builder::fixed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixed").build()}).build();
    private static final SdkField<String> RIGHT_OF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rightOf").getter(FieldPosition.getter(FieldPosition::rightOf)).setter(FieldPosition.setter(Builder::rightOf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rightOf").build()}).build();
    private static final SdkField<String> BELOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("below").getter(FieldPosition.getter(FieldPosition::below)).setter(FieldPosition.setter(Builder::below)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("below").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIXED_FIELD, RIGHT_OF_FIELD, BELOW_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fixed;
    private final String rightOf;
    private final String below;
    private final Type type;

    private FieldPosition(BuilderImpl builder) {
        this.fixed = builder.fixed;
        this.rightOf = builder.rightOf;
        this.below = builder.below;
        this.type = builder.type;
    }

    public final FixedPosition fixed() {
        return FixedPosition.fromValue(this.fixed);
    }

    public final String fixedAsString() {
        return this.fixed;
    }

    public final String rightOf() {
        return this.rightOf;
    }

    public final String below() {
        return this.below;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightOf());
        hashCode = 31 * hashCode + Objects.hashCode(this.below());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldPosition)) {
            return false;
        }
        FieldPosition other = (FieldPosition)obj;
        return Objects.equals(this.fixedAsString(), other.fixedAsString()) && Objects.equals(this.rightOf(), other.rightOf()) && Objects.equals(this.below(), other.below());
    }

    public final String toString() {
        return ToString.builder((String)"FieldPosition").add("Fixed", (Object)this.fixedAsString()).add("RightOf", (Object)this.rightOf()).add("Below", (Object)this.below()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fixed": {
                return Optional.ofNullable(clazz.cast(this.fixedAsString()));
            }
            case "rightOf": {
                return Optional.ofNullable(clazz.cast(this.rightOf()));
            }
            case "below": {
                return Optional.ofNullable(clazz.cast(this.below()));
            }
        }
        return Optional.empty();
    }

    public static FieldPosition fromFixed(String fixed) {
        return (FieldPosition)FieldPosition.builder().fixed(fixed).build();
    }

    public static FieldPosition fromFixed(FixedPosition fixed) {
        return (FieldPosition)FieldPosition.builder().fixed(fixed).build();
    }

    public static FieldPosition fromRightOf(String rightOf) {
        return (FieldPosition)FieldPosition.builder().rightOf(rightOf).build();
    }

    public static FieldPosition fromBelow(String below) {
        return (FieldPosition)FieldPosition.builder().below(below).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldPosition, T> g) {
        return obj -> g.apply((FieldPosition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FIXED,
        RIGHT_OF,
        BELOW,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String fixed;
        private String rightOf;
        private String below;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FieldPosition model) {
            this.fixed(model.fixed);
            this.rightOf(model.rightOf);
            this.below(model.below);
        }

        public final String getFixed() {
            return this.fixed;
        }

        public final void setFixed(String fixed) {
            String oldValue = this.fixed;
            this.fixed = fixed;
            this.handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
        }

        @Override
        public final Builder fixed(String fixed) {
            String oldValue = this.fixed;
            this.fixed = fixed;
            this.handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
            return this;
        }

        @Override
        public final Builder fixed(FixedPosition fixed) {
            this.fixed(fixed == null ? null : fixed.toString());
            return this;
        }

        public final String getRightOf() {
            return this.rightOf;
        }

        public final void setRightOf(String rightOf) {
            String oldValue = this.rightOf;
            this.rightOf = rightOf;
            this.handleUnionValueChange(Type.RIGHT_OF, oldValue, this.rightOf);
        }

        @Override
        public final Builder rightOf(String rightOf) {
            String oldValue = this.rightOf;
            this.rightOf = rightOf;
            this.handleUnionValueChange(Type.RIGHT_OF, oldValue, this.rightOf);
            return this;
        }

        public final String getBelow() {
            return this.below;
        }

        public final void setBelow(String below) {
            String oldValue = this.below;
            this.below = below;
            this.handleUnionValueChange(Type.BELOW, oldValue, this.below);
        }

        @Override
        public final Builder below(String below) {
            String oldValue = this.below;
            this.below = below;
            this.handleUnionValueChange(Type.BELOW, oldValue, this.below);
            return this;
        }

        public FieldPosition build() {
            return new FieldPosition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldPosition> {
        public Builder fixed(String var1);

        public Builder fixed(FixedPosition var1);

        public Builder rightOf(String var1);

        public Builder below(String var1);
    }
}

