/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldsMapCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormActionType;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle;
import software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator;
import software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement;
import software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElementMapCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFormData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFormData> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFormData.getter(CreateFormData::name)).setter(CreateFormData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(CreateFormData.getter(CreateFormData::dataType)).setter(CreateFormData.setter(Builder::dataType)).constructor(FormDataTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formActionType").getter(CreateFormData.getter(CreateFormData::formActionTypeAsString)).setter(CreateFormData.setter(Builder::formActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()}).build();
    private static final SdkField<Map<String, FieldConfig>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("fields").getter(CreateFormData.getter(CreateFormData::fields)).setter(CreateFormData.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<FormStyle> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("style").getter(CreateFormData.getter(CreateFormData::style)).setter(CreateFormData.setter(Builder::style)).constructor(FormStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("style").build()}).build();
    private static final SdkField<Map<String, SectionalElement>> SECTIONAL_ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sectionalElements").getter(CreateFormData.getter(CreateFormData::sectionalElements)).setter(CreateFormData.setter(Builder::sectionalElements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sectionalElements").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SectionalElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(CreateFormData.getter(CreateFormData::schemaVersion)).setter(CreateFormData.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<FormCTA> CTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cta").getter(CreateFormData.getter(CreateFormData::cta)).setter(CreateFormData.setter(Builder::cta)).constructor(FormCTA::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cta").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateFormData.getter(CreateFormData::tags)).setter(CreateFormData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> LABEL_DECORATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("labelDecorator").getter(CreateFormData.getter(CreateFormData::labelDecoratorAsString)).setter(CreateFormData.setter(Builder::labelDecorator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelDecorator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD, FORM_ACTION_TYPE_FIELD, FIELDS_FIELD, STYLE_FIELD, SECTIONAL_ELEMENTS_FIELD, SCHEMA_VERSION_FIELD, CTA_FIELD, TAGS_FIELD, LABEL_DECORATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final FormDataTypeConfig dataType;
    private final String formActionType;
    private final Map<String, FieldConfig> fields;
    private final FormStyle style;
    private final Map<String, SectionalElement> sectionalElements;
    private final String schemaVersion;
    private final FormCTA cta;
    private final Map<String, String> tags;
    private final String labelDecorator;

    private CreateFormData(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.formActionType = builder.formActionType;
        this.fields = builder.fields;
        this.style = builder.style;
        this.sectionalElements = builder.sectionalElements;
        this.schemaVersion = builder.schemaVersion;
        this.cta = builder.cta;
        this.tags = builder.tags;
        this.labelDecorator = builder.labelDecorator;
    }

    public final String name() {
        return this.name;
    }

    public final FormDataTypeConfig dataType() {
        return this.dataType;
    }

    public final FormActionType formActionType() {
        return FormActionType.fromValue(this.formActionType);
    }

    public final String formActionTypeAsString() {
        return this.formActionType;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, FieldConfig> fields() {
        return this.fields;
    }

    public final FormStyle style() {
        return this.style;
    }

    public final boolean hasSectionalElements() {
        return this.sectionalElements != null && !(this.sectionalElements instanceof SdkAutoConstructMap);
    }

    public final Map<String, SectionalElement> sectionalElements() {
        return this.sectionalElements;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final FormCTA cta() {
        return this.cta;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LabelDecorator labelDecorator() {
        return LabelDecorator.fromValue(this.labelDecorator);
    }

    public final String labelDecoratorAsString() {
        return this.labelDecorator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSectionalElements() ? this.sectionalElements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cta());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.labelDecoratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFormData)) {
            return false;
        }
        CreateFormData other = (CreateFormData)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.formActionTypeAsString(), other.formActionTypeAsString()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.style(), other.style()) && this.hasSectionalElements() == other.hasSectionalElements() && Objects.equals(this.sectionalElements(), other.sectionalElements()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.cta(), other.cta()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.labelDecoratorAsString(), other.labelDecoratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFormData").add("Name", (Object)this.name()).add("DataType", (Object)this.dataType()).add("FormActionType", (Object)this.formActionTypeAsString()).add("Fields", this.hasFields() ? this.fields() : null).add("Style", (Object)this.style()).add("SectionalElements", this.hasSectionalElements() ? this.sectionalElements() : null).add("SchemaVersion", (Object)this.schemaVersion()).add("Cta", (Object)this.cta()).add("Tags", this.hasTags() ? this.tags() : null).add("LabelDecorator", (Object)this.labelDecoratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "formActionType": {
                return Optional.ofNullable(clazz.cast(this.formActionTypeAsString()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
            case "sectionalElements": {
                return Optional.ofNullable(clazz.cast(this.sectionalElements()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "cta": {
                return Optional.ofNullable(clazz.cast(this.cta()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "labelDecorator": {
                return Optional.ofNullable(clazz.cast(this.labelDecoratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFormData, T> g) {
        return obj -> g.apply((CreateFormData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private FormDataTypeConfig dataType;
        private String formActionType;
        private Map<String, FieldConfig> fields = DefaultSdkAutoConstructMap.getInstance();
        private FormStyle style;
        private Map<String, SectionalElement> sectionalElements = DefaultSdkAutoConstructMap.getInstance();
        private String schemaVersion;
        private FormCTA cta;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String labelDecorator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFormData model) {
            this.name(model.name);
            this.dataType(model.dataType);
            this.formActionType(model.formActionType);
            this.fields(model.fields);
            this.style(model.style);
            this.sectionalElements(model.sectionalElements);
            this.schemaVersion(model.schemaVersion);
            this.cta(model.cta);
            this.tags(model.tags);
            this.labelDecorator(model.labelDecorator);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getFormActionType() {
            return this.formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final Map<String, FieldConfig.Builder> getFields() {
            Map<String, FieldConfig.Builder> result = FieldsMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, FieldConfig.BuilderImpl> fields) {
            this.fields = FieldsMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, FieldConfig> fields) {
            this.fields = FieldsMapCopier.copy(fields);
            return this;
        }

        public final FormStyle.Builder getStyle() {
            return this.style != null ? this.style.toBuilder() : null;
        }

        public final void setStyle(FormStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(FormStyle style) {
            this.style = style;
            return this;
        }

        public final Map<String, SectionalElement.Builder> getSectionalElements() {
            Map<String, SectionalElement.Builder> result = SectionalElementMapCopier.copyToBuilder(this.sectionalElements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSectionalElements(Map<String, SectionalElement.BuilderImpl> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copyFromBuilder(sectionalElements);
        }

        @Override
        public final Builder sectionalElements(Map<String, SectionalElement> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copy(sectionalElements);
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final FormCTA.Builder getCta() {
            return this.cta != null ? this.cta.toBuilder() : null;
        }

        public final void setCta(FormCTA.BuilderImpl cta) {
            this.cta = cta != null ? cta.build() : null;
        }

        @Override
        public final Builder cta(FormCTA cta) {
            this.cta = cta;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getLabelDecorator() {
            return this.labelDecorator;
        }

        public final void setLabelDecorator(String labelDecorator) {
            this.labelDecorator = labelDecorator;
        }

        @Override
        public final Builder labelDecorator(String labelDecorator) {
            this.labelDecorator = labelDecorator;
            return this;
        }

        @Override
        public final Builder labelDecorator(LabelDecorator labelDecorator) {
            this.labelDecorator(labelDecorator == null ? null : labelDecorator.toString());
            return this;
        }

        public CreateFormData build() {
            return new CreateFormData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFormData> {
        public Builder name(String var1);

        public Builder dataType(FormDataTypeConfig var1);

        default public Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return this.dataType((FormDataTypeConfig)((FormDataTypeConfig.Builder)FormDataTypeConfig.builder().applyMutation(dataType)).build());
        }

        public Builder formActionType(String var1);

        public Builder formActionType(FormActionType var1);

        public Builder fields(Map<String, FieldConfig> var1);

        public Builder style(FormStyle var1);

        default public Builder style(Consumer<FormStyle.Builder> style) {
            return this.style((FormStyle)((FormStyle.Builder)FormStyle.builder().applyMutation(style)).build());
        }

        public Builder sectionalElements(Map<String, SectionalElement> var1);

        public Builder schemaVersion(String var1);

        public Builder cta(FormCTA var1);

        default public Builder cta(Consumer<FormCTA.Builder> cta) {
            return this.cta((FormCTA)((FormCTA.Builder)FormCTA.builder().applyMutation(cta)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder labelDecorator(String var1);

        public Builder labelDecorator(LabelDecorator var1);
    }
}

