/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the code generation job configuration for a React project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactStartCodegenJobData implements SdkPojo, Serializable,
        ToCopyableBuilder<ReactStartCodegenJobData.Builder, ReactStartCodegenJobData> {
    private static final SdkField<String> MODULE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("module")
            .getter(getter(ReactStartCodegenJobData::moduleAsString)).setter(setter(Builder::module))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("module").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(ReactStartCodegenJobData::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("script")
            .getter(getter(ReactStartCodegenJobData::scriptAsString)).setter(setter(Builder::script))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()).build();

    private static final SdkField<Boolean> RENDER_TYPE_DECLARATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("renderTypeDeclarations").getter(getter(ReactStartCodegenJobData::renderTypeDeclarations))
            .setter(setter(Builder::renderTypeDeclarations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderTypeDeclarations").build())
            .build();

    private static final SdkField<Boolean> INLINE_SOURCE_MAP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inlineSourceMap").getter(getter(ReactStartCodegenJobData::inlineSourceMap))
            .setter(setter(Builder::inlineSourceMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSourceMap").build()).build();

    private static final SdkField<ApiConfiguration> API_CONFIGURATION_FIELD = SdkField
            .<ApiConfiguration> builder(MarshallingType.SDK_POJO).memberName("apiConfiguration")
            .getter(getter(ReactStartCodegenJobData::apiConfiguration)).setter(setter(Builder::apiConfiguration))
            .constructor(ApiConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiConfiguration").build()).build();

    private static final SdkField<Map<String, String>> DEPENDENCIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("dependencies")
            .getter(getter(ReactStartCodegenJobData::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODULE_FIELD, TARGET_FIELD,
            SCRIPT_FIELD, RENDER_TYPE_DECLARATIONS_FIELD, INLINE_SOURCE_MAP_FIELD, API_CONFIGURATION_FIELD, DEPENDENCIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String module;

    private final String target;

    private final String script;

    private final Boolean renderTypeDeclarations;

    private final Boolean inlineSourceMap;

    private final ApiConfiguration apiConfiguration;

    private final Map<String, String> dependencies;

    private ReactStartCodegenJobData(BuilderImpl builder) {
        this.module = builder.module;
        this.target = builder.target;
        this.script = builder.script;
        this.renderTypeDeclarations = builder.renderTypeDeclarations;
        this.inlineSourceMap = builder.inlineSourceMap;
        this.apiConfiguration = builder.apiConfiguration;
        this.dependencies = builder.dependencies;
    }

    /**
     * <p>
     * The JavaScript module type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #module} will
     * return {@link JSModule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moduleAsString}.
     * </p>
     * 
     * @return The JavaScript module type.
     * @see JSModule
     */
    public final JSModule module() {
        return JSModule.fromValue(module);
    }

    /**
     * <p>
     * The JavaScript module type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #module} will
     * return {@link JSModule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moduleAsString}.
     * </p>
     * 
     * @return The JavaScript module type.
     * @see JSModule
     */
    public final String moduleAsString() {
        return module;
    }

    /**
     * <p>
     * The ECMAScript specification to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link JSTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The ECMAScript specification to use.
     * @see JSTarget
     */
    public final JSTarget target() {
        return JSTarget.fromValue(target);
    }

    /**
     * <p>
     * The ECMAScript specification to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link JSTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The ECMAScript specification to use.
     * @see JSTarget
     */
    public final String targetAsString() {
        return target;
    }

    /**
     * <p>
     * The file type to use for a JavaScript project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #script} will
     * return {@link JSScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptAsString}.
     * </p>
     * 
     * @return The file type to use for a JavaScript project.
     * @see JSScript
     */
    public final JSScript script() {
        return JSScript.fromValue(script);
    }

    /**
     * <p>
     * The file type to use for a JavaScript project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #script} will
     * return {@link JSScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptAsString}.
     * </p>
     * 
     * @return The file type to use for a JavaScript project.
     * @see JSScript
     */
    public final String scriptAsString() {
        return script;
    }

    /**
     * <p>
     * Specifies whether the code generation job should render type declaration files.
     * </p>
     * 
     * @return Specifies whether the code generation job should render type declaration files.
     */
    public final Boolean renderTypeDeclarations() {
        return renderTypeDeclarations;
    }

    /**
     * <p>
     * Specifies whether the code generation job should render inline source maps.
     * </p>
     * 
     * @return Specifies whether the code generation job should render inline source maps.
     */
    public final Boolean inlineSourceMap() {
        return inlineSourceMap;
    }

    /**
     * <p>
     * The API configuration for the code generation job.
     * </p>
     * 
     * @return The API configuration for the code generation job.
     */
    public final ApiConfiguration apiConfiguration() {
        return apiConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Lists the dependency packages that may be required for the project code to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return Lists the dependency packages that may be required for the project code to run.
     */
    public final Map<String, String> dependencies() {
        return dependencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renderTypeDeclarations());
        hashCode = 31 * hashCode + Objects.hashCode(inlineSourceMap());
        hashCode = 31 * hashCode + Objects.hashCode(apiConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactStartCodegenJobData)) {
            return false;
        }
        ReactStartCodegenJobData other = (ReactStartCodegenJobData) obj;
        return Objects.equals(moduleAsString(), other.moduleAsString())
                && Objects.equals(targetAsString(), other.targetAsString())
                && Objects.equals(scriptAsString(), other.scriptAsString())
                && Objects.equals(renderTypeDeclarations(), other.renderTypeDeclarations())
                && Objects.equals(inlineSourceMap(), other.inlineSourceMap())
                && Objects.equals(apiConfiguration(), other.apiConfiguration()) && hasDependencies() == other.hasDependencies()
                && Objects.equals(dependencies(), other.dependencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactStartCodegenJobData").add("Module", moduleAsString()).add("Target", targetAsString())
                .add("Script", scriptAsString()).add("RenderTypeDeclarations", renderTypeDeclarations())
                .add("InlineSourceMap", inlineSourceMap()).add("ApiConfiguration", apiConfiguration())
                .add("Dependencies", hasDependencies() ? dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "module":
            return Optional.ofNullable(clazz.cast(moduleAsString()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "script":
            return Optional.ofNullable(clazz.cast(scriptAsString()));
        case "renderTypeDeclarations":
            return Optional.ofNullable(clazz.cast(renderTypeDeclarations()));
        case "inlineSourceMap":
            return Optional.ofNullable(clazz.cast(inlineSourceMap()));
        case "apiConfiguration":
            return Optional.ofNullable(clazz.cast(apiConfiguration()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactStartCodegenJobData, T> g) {
        return obj -> g.apply((ReactStartCodegenJobData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactStartCodegenJobData> {
        /**
         * <p>
         * The JavaScript module type.
         * </p>
         * 
         * @param module
         *        The JavaScript module type.
         * @see JSModule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSModule
         */
        Builder module(String module);

        /**
         * <p>
         * The JavaScript module type.
         * </p>
         * 
         * @param module
         *        The JavaScript module type.
         * @see JSModule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSModule
         */
        Builder module(JSModule module);

        /**
         * <p>
         * The ECMAScript specification to use.
         * </p>
         * 
         * @param target
         *        The ECMAScript specification to use.
         * @see JSTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The ECMAScript specification to use.
         * </p>
         * 
         * @param target
         *        The ECMAScript specification to use.
         * @see JSTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSTarget
         */
        Builder target(JSTarget target);

        /**
         * <p>
         * The file type to use for a JavaScript project.
         * </p>
         * 
         * @param script
         *        The file type to use for a JavaScript project.
         * @see JSScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSScript
         */
        Builder script(String script);

        /**
         * <p>
         * The file type to use for a JavaScript project.
         * </p>
         * 
         * @param script
         *        The file type to use for a JavaScript project.
         * @see JSScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSScript
         */
        Builder script(JSScript script);

        /**
         * <p>
         * Specifies whether the code generation job should render type declaration files.
         * </p>
         * 
         * @param renderTypeDeclarations
         *        Specifies whether the code generation job should render type declaration files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderTypeDeclarations(Boolean renderTypeDeclarations);

        /**
         * <p>
         * Specifies whether the code generation job should render inline source maps.
         * </p>
         * 
         * @param inlineSourceMap
         *        Specifies whether the code generation job should render inline source maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineSourceMap(Boolean inlineSourceMap);

        /**
         * <p>
         * The API configuration for the code generation job.
         * </p>
         * 
         * @param apiConfiguration
         *        The API configuration for the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiConfiguration(ApiConfiguration apiConfiguration);

        /**
         * <p>
         * The API configuration for the code generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiConfiguration.Builder} avoiding the
         * need to create one manually via {@link ApiConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #apiConfiguration(ApiConfiguration)}.
         * 
         * @param apiConfiguration
         *        a consumer that will call methods on {@link ApiConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiConfiguration(ApiConfiguration)
         */
        default Builder apiConfiguration(Consumer<ApiConfiguration.Builder> apiConfiguration) {
            return apiConfiguration(ApiConfiguration.builder().applyMutation(apiConfiguration).build());
        }

        /**
         * <p>
         * Lists the dependency packages that may be required for the project code to run.
         * </p>
         * 
         * @param dependencies
         *        Lists the dependency packages that may be required for the project code to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Map<String, String> dependencies);
    }

    static final class BuilderImpl implements Builder {
        private String module;

        private String target;

        private String script;

        private Boolean renderTypeDeclarations;

        private Boolean inlineSourceMap;

        private ApiConfiguration apiConfiguration;

        private Map<String, String> dependencies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReactStartCodegenJobData model) {
            module(model.module);
            target(model.target);
            script(model.script);
            renderTypeDeclarations(model.renderTypeDeclarations);
            inlineSourceMap(model.inlineSourceMap);
            apiConfiguration(model.apiConfiguration);
            dependencies(model.dependencies);
        }

        public final String getModule() {
            return module;
        }

        public final void setModule(String module) {
            this.module = module;
        }

        @Override
        public final Builder module(String module) {
            this.module = module;
            return this;
        }

        @Override
        public final Builder module(JSModule module) {
            this.module(module == null ? null : module.toString());
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(JSTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final String getScript() {
            return script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        @Override
        public final Builder script(JSScript script) {
            this.script(script == null ? null : script.toString());
            return this;
        }

        public final Boolean getRenderTypeDeclarations() {
            return renderTypeDeclarations;
        }

        public final void setRenderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
        }

        @Override
        public final Builder renderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
            return this;
        }

        public final Boolean getInlineSourceMap() {
            return inlineSourceMap;
        }

        public final void setInlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
        }

        @Override
        public final Builder inlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
            return this;
        }

        public final ApiConfiguration.Builder getApiConfiguration() {
            return apiConfiguration != null ? apiConfiguration.toBuilder() : null;
        }

        public final void setApiConfiguration(ApiConfiguration.BuilderImpl apiConfiguration) {
            this.apiConfiguration = apiConfiguration != null ? apiConfiguration.build() : null;
        }

        @Override
        public final Builder apiConfiguration(ApiConfiguration apiConfiguration) {
            this.apiConfiguration = apiConfiguration;
            return this;
        }

        public final Map<String, String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructMap) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Map<String, String> dependencies) {
            this.dependencies = ReactCodegenDependenciesCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Map<String, String> dependencies) {
            this.dependencies = ReactCodegenDependenciesCopier.copy(dependencies);
            return this;
        }

        @Override
        public ReactStartCodegenJobData build() {
            return new ReactStartCodegenJobData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
