/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExchangeCodeForTokenRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<ExchangeCodeForTokenRequest.Builder, ExchangeCodeForTokenRequest> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ExchangeCodeForTokenRequest::providerAsString))
            .setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("provider").build()).build();

    private static final SdkField<ExchangeCodeForTokenRequestBody> REQUEST_FIELD = SdkField
            .<ExchangeCodeForTokenRequestBody> builder(MarshallingType.SDK_POJO)
            .memberName("request")
            .getter(getter(ExchangeCodeForTokenRequest::request))
            .setter(setter(Builder::request))
            .constructor(ExchangeCodeForTokenRequestBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PROVIDER_FIELD, REQUEST_FIELD));

    private final String provider;

    private final ExchangeCodeForTokenRequestBody request;

    private ExchangeCodeForTokenRequest(BuilderImpl builder) {
        super(builder);
        this.provider = builder.provider;
        this.request = builder.request;
    }

    /**
     * <p>
     * The third-party provider for the token. The only valid value is <code>figma</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link TokenProviders#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The third-party provider for the token. The only valid value is <code>figma</code>.
     * @see TokenProviders
     */
    public final TokenProviders provider() {
        return TokenProviders.fromValue(provider);
    }

    /**
     * <p>
     * The third-party provider for the token. The only valid value is <code>figma</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link TokenProviders#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The third-party provider for the token. The only valid value is <code>figma</code>.
     * @see TokenProviders
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * Describes the configuration of the request.
     * </p>
     * 
     * @return Describes the configuration of the request.
     */
    public final ExchangeCodeForTokenRequestBody request() {
        return request;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(request());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExchangeCodeForTokenRequest)) {
            return false;
        }
        ExchangeCodeForTokenRequest other = (ExchangeCodeForTokenRequest) obj;
        return Objects.equals(providerAsString(), other.providerAsString()) && Objects.equals(request(), other.request());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExchangeCodeForTokenRequest").add("Provider", providerAsString()).add("Request", request())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "request":
            return Optional.ofNullable(clazz.cast(request()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExchangeCodeForTokenRequest, T> g) {
        return obj -> g.apply((ExchangeCodeForTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExchangeCodeForTokenRequest> {
        /**
         * <p>
         * The third-party provider for the token. The only valid value is <code>figma</code>.
         * </p>
         * 
         * @param provider
         *        The third-party provider for the token. The only valid value is <code>figma</code>.
         * @see TokenProviders
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenProviders
         */
        Builder provider(String provider);

        /**
         * <p>
         * The third-party provider for the token. The only valid value is <code>figma</code>.
         * </p>
         * 
         * @param provider
         *        The third-party provider for the token. The only valid value is <code>figma</code>.
         * @see TokenProviders
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenProviders
         */
        Builder provider(TokenProviders provider);

        /**
         * <p>
         * Describes the configuration of the request.
         * </p>
         * 
         * @param request
         *        Describes the configuration of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(ExchangeCodeForTokenRequestBody request);

        /**
         * <p>
         * Describes the configuration of the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExchangeCodeForTokenRequestBody.Builder}
         * avoiding the need to create one manually via {@link ExchangeCodeForTokenRequestBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExchangeCodeForTokenRequestBody.Builder#build()} is called
         * immediately and its result is passed to {@link #request(ExchangeCodeForTokenRequestBody)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link ExchangeCodeForTokenRequestBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(ExchangeCodeForTokenRequestBody)
         */
        default Builder request(Consumer<ExchangeCodeForTokenRequestBody.Builder> request) {
            return request(ExchangeCodeForTokenRequestBody.builder().applyMutation(request).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String provider;

        private ExchangeCodeForTokenRequestBody request;

        private BuilderImpl() {
        }

        private BuilderImpl(ExchangeCodeForTokenRequest model) {
            super(model);
            provider(model.provider);
            request(model.request);
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(TokenProviders provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final ExchangeCodeForTokenRequestBody.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(ExchangeCodeForTokenRequestBody.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(ExchangeCodeForTokenRequestBody request) {
            this.request = request;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExchangeCodeForTokenRequest build() {
            return new ExchangeCodeForTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
