/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration;
import software.amazon.awssdk.services.amplifyuibuilder.model.JSModule;
import software.amazon.awssdk.services.amplifyuibuilder.model.JSScript;
import software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget;
import software.amazon.awssdk.services.amplifyuibuilder.model.ReactCodegenDependenciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReactStartCodegenJobData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReactStartCodegenJobData> {
    private static final SdkField<String> MODULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("module").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::moduleAsString)).setter(ReactStartCodegenJobData.setter(Builder::module)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("module").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::targetAsString)).setter(ReactStartCodegenJobData.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("script").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::scriptAsString)).setter(ReactStartCodegenJobData.setter(Builder::script)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()}).build();
    private static final SdkField<Boolean> RENDER_TYPE_DECLARATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("renderTypeDeclarations").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::renderTypeDeclarations)).setter(ReactStartCodegenJobData.setter(Builder::renderTypeDeclarations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderTypeDeclarations").build()}).build();
    private static final SdkField<Boolean> INLINE_SOURCE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("inlineSourceMap").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::inlineSourceMap)).setter(ReactStartCodegenJobData.setter(Builder::inlineSourceMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSourceMap").build()}).build();
    private static final SdkField<ApiConfiguration> API_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiConfiguration").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::apiConfiguration)).setter(ReactStartCodegenJobData.setter(Builder::apiConfiguration)).constructor(ApiConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("dependencies").getter(ReactStartCodegenJobData.getter(ReactStartCodegenJobData::dependencies)).setter(ReactStartCodegenJobData.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODULE_FIELD, TARGET_FIELD, SCRIPT_FIELD, RENDER_TYPE_DECLARATIONS_FIELD, INLINE_SOURCE_MAP_FIELD, API_CONFIGURATION_FIELD, DEPENDENCIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String module;
    private final String target;
    private final String script;
    private final Boolean renderTypeDeclarations;
    private final Boolean inlineSourceMap;
    private final ApiConfiguration apiConfiguration;
    private final Map<String, String> dependencies;

    private ReactStartCodegenJobData(BuilderImpl builder) {
        this.module = builder.module;
        this.target = builder.target;
        this.script = builder.script;
        this.renderTypeDeclarations = builder.renderTypeDeclarations;
        this.inlineSourceMap = builder.inlineSourceMap;
        this.apiConfiguration = builder.apiConfiguration;
        this.dependencies = builder.dependencies;
    }

    public final JSModule module() {
        return JSModule.fromValue(this.module);
    }

    public final String moduleAsString() {
        return this.module;
    }

    public final JSTarget target() {
        return JSTarget.fromValue(this.target);
    }

    public final String targetAsString() {
        return this.target;
    }

    public final JSScript script() {
        return JSScript.fromValue(this.script);
    }

    public final String scriptAsString() {
        return this.script;
    }

    public final Boolean renderTypeDeclarations() {
        return this.renderTypeDeclarations;
    }

    public final Boolean inlineSourceMap() {
        return this.inlineSourceMap;
    }

    public final ApiConfiguration apiConfiguration() {
        return this.apiConfiguration;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dependencies() {
        return this.dependencies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderTypeDeclarations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineSourceMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactStartCodegenJobData)) {
            return false;
        }
        ReactStartCodegenJobData other = (ReactStartCodegenJobData)obj;
        return Objects.equals(this.moduleAsString(), other.moduleAsString()) && Objects.equals(this.targetAsString(), other.targetAsString()) && Objects.equals(this.scriptAsString(), other.scriptAsString()) && Objects.equals(this.renderTypeDeclarations(), other.renderTypeDeclarations()) && Objects.equals(this.inlineSourceMap(), other.inlineSourceMap()) && Objects.equals(this.apiConfiguration(), other.apiConfiguration()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies());
    }

    public final String toString() {
        return ToString.builder((String)"ReactStartCodegenJobData").add("Module", (Object)this.moduleAsString()).add("Target", (Object)this.targetAsString()).add("Script", (Object)this.scriptAsString()).add("RenderTypeDeclarations", (Object)this.renderTypeDeclarations()).add("InlineSourceMap", (Object)this.inlineSourceMap()).add("ApiConfiguration", (Object)this.apiConfiguration()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "module": {
                return Optional.ofNullable(clazz.cast(this.moduleAsString()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
            case "script": {
                return Optional.ofNullable(clazz.cast(this.scriptAsString()));
            }
            case "renderTypeDeclarations": {
                return Optional.ofNullable(clazz.cast(this.renderTypeDeclarations()));
            }
            case "inlineSourceMap": {
                return Optional.ofNullable(clazz.cast(this.inlineSourceMap()));
            }
            case "apiConfiguration": {
                return Optional.ofNullable(clazz.cast(this.apiConfiguration()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactStartCodegenJobData, T> g) {
        return obj -> g.apply((ReactStartCodegenJobData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String module;
        private String target;
        private String script;
        private Boolean renderTypeDeclarations;
        private Boolean inlineSourceMap;
        private ApiConfiguration apiConfiguration;
        private Map<String, String> dependencies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReactStartCodegenJobData model) {
            this.module(model.module);
            this.target(model.target);
            this.script(model.script);
            this.renderTypeDeclarations(model.renderTypeDeclarations);
            this.inlineSourceMap(model.inlineSourceMap);
            this.apiConfiguration(model.apiConfiguration);
            this.dependencies(model.dependencies);
        }

        public final String getModule() {
            return this.module;
        }

        public final void setModule(String module) {
            this.module = module;
        }

        @Override
        public final Builder module(String module) {
            this.module = module;
            return this;
        }

        @Override
        public final Builder module(JSModule module) {
            this.module(module == null ? null : module.toString());
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(JSTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final String getScript() {
            return this.script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        @Override
        public final Builder script(JSScript script) {
            this.script(script == null ? null : script.toString());
            return this;
        }

        public final Boolean getRenderTypeDeclarations() {
            return this.renderTypeDeclarations;
        }

        public final void setRenderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
        }

        @Override
        public final Builder renderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
            return this;
        }

        public final Boolean getInlineSourceMap() {
            return this.inlineSourceMap;
        }

        public final void setInlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
        }

        @Override
        public final Builder inlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
            return this;
        }

        public final ApiConfiguration.Builder getApiConfiguration() {
            return this.apiConfiguration != null ? this.apiConfiguration.toBuilder() : null;
        }

        public final void setApiConfiguration(ApiConfiguration.BuilderImpl apiConfiguration) {
            this.apiConfiguration = apiConfiguration != null ? apiConfiguration.build() : null;
        }

        @Override
        public final Builder apiConfiguration(ApiConfiguration apiConfiguration) {
            this.apiConfiguration = apiConfiguration;
            return this;
        }

        public final Map<String, String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Map<String, String> dependencies) {
            this.dependencies = ReactCodegenDependenciesCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Map<String, String> dependencies) {
            this.dependencies = ReactCodegenDependenciesCopier.copy(dependencies);
            return this;
        }

        public ReactStartCodegenJobData build() {
            return new ReactStartCodegenJobData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReactStartCodegenJobData> {
        public Builder module(String var1);

        public Builder module(JSModule var1);

        public Builder target(String var1);

        public Builder target(JSTarget var1);

        public Builder script(String var1);

        public Builder script(JSScript var1);

        public Builder renderTypeDeclarations(Boolean var1);

        public Builder inlineSourceMap(Boolean var1);

        public Builder apiConfiguration(ApiConfiguration var1);

        default public Builder apiConfiguration(Consumer<ApiConfiguration.Builder> apiConfiguration) {
            return this.apiConfiguration((ApiConfiguration)((ApiConfiguration.Builder)ApiConfiguration.builder().applyMutation(apiConfiguration)).build());
        }

        public Builder dependencies(Map<String, String> var1);
    }
}

