/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFormResponse extends AmplifyUiBuilderResponse implements
        ToCopyableBuilder<GetFormResponse.Builder, GetFormResponse> {
    private static final SdkField<Form> FORM_FIELD = SdkField
            .<Form> builder(MarshallingType.SDK_POJO)
            .memberName("form")
            .getter(getter(GetFormResponse::form))
            .setter(setter(Builder::form))
            .constructor(Form::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("form").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORM_FIELD));

    private final Form form;

    private GetFormResponse(BuilderImpl builder) {
        super(builder);
        this.form = builder.form;
    }

    /**
     * <p>
     * Represents the configuration settings for the form.
     * </p>
     * 
     * @return Represents the configuration settings for the form.
     */
    public final Form form() {
        return form;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(form());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFormResponse)) {
            return false;
        }
        GetFormResponse other = (GetFormResponse) obj;
        return Objects.equals(form(), other.form());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFormResponse").add("Form", form()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "form":
            return Optional.ofNullable(clazz.cast(form()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFormResponse, T> g) {
        return obj -> g.apply((GetFormResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFormResponse> {
        /**
         * <p>
         * Represents the configuration settings for the form.
         * </p>
         * 
         * @param form
         *        Represents the configuration settings for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder form(Form form);

        /**
         * <p>
         * Represents the configuration settings for the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link Form.Builder} avoiding the need to create
         * one manually via {@link Form#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Form.Builder#build()} is called immediately and its result is
         * passed to {@link #form(Form)}.
         * 
         * @param form
         *        a consumer that will call methods on {@link Form.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #form(Form)
         */
        default Builder form(Consumer<Form.Builder> form) {
            return form(Form.builder().applyMutation(form).build());
        }
    }

    static final class BuilderImpl extends AmplifyUiBuilderResponse.BuilderImpl implements Builder {
        private Form form;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFormResponse model) {
            super(model);
            form(model.form);
        }

        public final Form.Builder getForm() {
            return form != null ? form.toBuilder() : null;
        }

        public final void setForm(Form.BuilderImpl form) {
            this.form = form != null ? form.build() : null;
        }

        @Override
        public final Builder form(Form form) {
            this.form = form;
            return this;
        }

        @Override
        public GetFormResponse build() {
            return new GetFormResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
