/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data type configuration for the data source associated with a form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormDataTypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FormDataTypeConfig.Builder, FormDataTypeConfig> {
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceType").getter(getter(FormDataTypeConfig::dataSourceTypeAsString))
            .setter(setter(Builder::dataSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()).build();

    private static final SdkField<String> DATA_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeName").getter(getter(FormDataTypeConfig::dataTypeName)).setter(setter(Builder::dataTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD,
            DATA_TYPE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceType;

    private final String dataTypeName;

    private FormDataTypeConfig(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.dataTypeName = builder.dataTypeName;
    }

    /**
     * <p>
     * The data source type, either an Amplify DataStore model or a custom data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link FormDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The data source type, either an Amplify DataStore model or a custom data type.
     * @see FormDataSourceType
     */
    public final FormDataSourceType dataSourceType() {
        return FormDataSourceType.fromValue(dataSourceType);
    }

    /**
     * <p>
     * The data source type, either an Amplify DataStore model or a custom data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link FormDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The data source type, either an Amplify DataStore model or a custom data type.
     * @see FormDataSourceType
     */
    public final String dataSourceTypeAsString() {
        return dataSourceType;
    }

    /**
     * <p>
     * The unique name of the data type you are using as the data source for the form.
     * </p>
     * 
     * @return The unique name of the data type you are using as the data source for the form.
     */
    public final String dataTypeName() {
        return dataTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormDataTypeConfig)) {
            return false;
        }
        FormDataTypeConfig other = (FormDataTypeConfig) obj;
        return Objects.equals(dataSourceTypeAsString(), other.dataSourceTypeAsString())
                && Objects.equals(dataTypeName(), other.dataTypeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormDataTypeConfig").add("DataSourceType", dataSourceTypeAsString())
                .add("DataTypeName", dataTypeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceTypeAsString()));
        case "dataTypeName":
            return Optional.ofNullable(clazz.cast(dataTypeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormDataTypeConfig, T> g) {
        return obj -> g.apply((FormDataTypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormDataTypeConfig> {
        /**
         * <p>
         * The data source type, either an Amplify DataStore model or a custom data type.
         * </p>
         * 
         * @param dataSourceType
         *        The data source type, either an Amplify DataStore model or a custom data type.
         * @see FormDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormDataSourceType
         */
        Builder dataSourceType(String dataSourceType);

        /**
         * <p>
         * The data source type, either an Amplify DataStore model or a custom data type.
         * </p>
         * 
         * @param dataSourceType
         *        The data source type, either an Amplify DataStore model or a custom data type.
         * @see FormDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormDataSourceType
         */
        Builder dataSourceType(FormDataSourceType dataSourceType);

        /**
         * <p>
         * The unique name of the data type you are using as the data source for the form.
         * </p>
         * 
         * @param dataTypeName
         *        The unique name of the data type you are using as the data source for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeName(String dataTypeName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceType;

        private String dataTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FormDataTypeConfig model) {
            dataSourceType(model.dataSourceType);
            dataTypeName(model.dataTypeName);
        }

        public final String getDataSourceType() {
            return dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(FormDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final String getDataTypeName() {
            return dataTypeName;
        }

        public final void setDataTypeName(String dataTypeName) {
            this.dataTypeName = dataTypeName;
        }

        @Override
        public final Builder dataTypeName(String dataTypeName) {
            this.dataTypeName = dataTypeName;
            return this;
        }

        @Override
        public FormDataTypeConfig build() {
            return new FormDataTypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
