/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListCodegenJobsPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsPublisher;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesPublisher;

/**
 * Service client for accessing AWS Amplify UI Builder asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI)
 * component libraries and themes for use in your Amplify applications. You can then connect these UI components to an
 * application's backend Amazon Web Services resources.
 * </p>
 * <p>
 * You can also use the Amplify Studio visual designer to create UI components and model data for an app. For more
 * information, see <a href="https://docs.amplify.aws/console/adminui/intro">Introduction</a> in the <i>Amplify
 * Docs</i>.
 * </p>
 * <p>
 * The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development.
 * For more information, see the <a href="https://docs.amplify.aws/">Amplify Framework</a>. For more information about
 * deploying an Amplify application to Amazon Web Services, see the <a
 * href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyUiBuilderAsyncClient extends AwsClient {
    String SERVICE_NAME = "amplifyuibuilder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplifyuibuilder";

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     *
     * @param createComponentRequest
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequest createComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(
            Consumer<CreateComponentRequest.Builder> createComponentRequest) {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Creates a new form for an Amplify.
     * </p>
     *
     * @param createFormRequest
     * @return A Java Future containing the result of the CreateForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFormResponse> createForm(CreateFormRequest createFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new form for an Amplify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFormRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFormRequest#builder()}
     * </p>
     *
     * @param createFormRequest
     *        A {@link Consumer} that will call methods on {@link CreateFormRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFormResponse> createForm(Consumer<CreateFormRequest.Builder> createFormRequest) {
        return createForm(CreateFormRequest.builder().applyMutation(createFormRequest).build());
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     *
     * @param createThemeRequest
     * @return A Java Future containing the result of the CreateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateThemeResponse> createTheme(CreateThemeRequest createThemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThemeRequest#builder()}
     * </p>
     *
     * @param createThemeRequest
     *        A {@link Consumer} that will call methods on {@link CreateThemeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateThemeResponse> createTheme(Consumer<CreateThemeRequest.Builder> createThemeRequest) {
        return createTheme(CreateThemeRequest.builder().applyMutation(createThemeRequest).build());
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(
            Consumer<DeleteComponentRequest.Builder> deleteComponentRequest) {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a form from an Amplify app.
     * </p>
     *
     * @param deleteFormRequest
     * @return A Java Future containing the result of the DeleteForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFormResponse> deleteForm(DeleteFormRequest deleteFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a form from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFormRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFormRequest#builder()}
     * </p>
     *
     * @param deleteFormRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFormRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFormResponse> deleteForm(Consumer<DeleteFormRequest.Builder> deleteFormRequest) {
        return deleteForm(DeleteFormRequest.builder().applyMutation(deleteFormRequest).build());
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     *
     * @param deleteThemeRequest
     * @return A Java Future containing the result of the DeleteTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteThemeResponse> deleteTheme(DeleteThemeRequest deleteThemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThemeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThemeRequest#builder()}
     * </p>
     *
     * @param deleteThemeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThemeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteThemeResponse> deleteTheme(Consumer<DeleteThemeRequest.Builder> deleteThemeRequest) {
        return deleteTheme(DeleteThemeRequest.builder().applyMutation(deleteThemeRequest).build());
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     * @return A Java Future containing the result of the ExchangeCodeForToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExchangeCodeForTokenResponse> exchangeCodeForToken(
            ExchangeCodeForTokenRequest exchangeCodeForTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExchangeCodeForTokenRequest.Builder} avoiding the
     * need to create one manually via {@link ExchangeCodeForTokenRequest#builder()}
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     *        A {@link Consumer} that will call methods on {@link ExchangeCodeForTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExchangeCodeForToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExchangeCodeForTokenResponse> exchangeCodeForToken(
            Consumer<ExchangeCodeForTokenRequest.Builder> exchangeCodeForTokenRequest) {
        return exchangeCodeForToken(ExchangeCodeForTokenRequest.builder().applyMutation(exchangeCodeForTokenRequest).build());
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportComponentsRequest
     * @return A Java Future containing the result of the ExportComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportComponentsResponse> exportComponents(ExportComponentsRequest exportComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportComponentsRequest.Builder} avoiding the need
     * to create one manually via {@link ExportComponentsRequest#builder()}
     * </p>
     *
     * @param exportComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ExportComponentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportComponentsResponse> exportComponents(
            Consumer<ExportComponentsRequest.Builder> exportComponentsRequest) {
        return exportComponents(ExportComponentsRequest.builder().applyMutation(exportComponentsRequest).build());
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsPublisher publisher = client.exportComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsPublisher publisher = client.exportComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param exportComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsPublisher exportComponentsPaginator(ExportComponentsRequest exportComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsPublisher publisher = client.exportComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsPublisher publisher = client.exportComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportComponentsRequest.Builder} avoiding the need
     * to create one manually via {@link ExportComponentsRequest#builder()}
     * </p>
     *
     * @param exportComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ExportComponentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsPublisher exportComponentsPaginator(Consumer<ExportComponentsRequest.Builder> exportComponentsRequest) {
        return exportComponentsPaginator(ExportComponentsRequest.builder().applyMutation(exportComponentsRequest).build());
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportFormsRequest
     * @return A Java Future containing the result of the ExportForms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportFormsResponse> exportForms(ExportFormsRequest exportFormsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ExportFormsRequest#builder()}
     * </p>
     *
     * @param exportFormsRequest
     *        A {@link Consumer} that will call methods on {@link ExportFormsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportForms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportFormsResponse> exportForms(Consumer<ExportFormsRequest.Builder> exportFormsRequest) {
        return exportForms(ExportFormsRequest.builder().applyMutation(exportFormsRequest).build());
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsPublisher publisher = client.exportFormsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsPublisher publisher = client.exportFormsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation.</b>
     * </p>
     *
     * @param exportFormsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsPublisher exportFormsPaginator(ExportFormsRequest exportFormsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsPublisher publisher = client.exportFormsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsPublisher publisher = client.exportFormsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ExportFormsRequest#builder()}
     * </p>
     *
     * @param exportFormsRequest
     *        A {@link Consumer} that will call methods on {@link ExportFormsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsPublisher exportFormsPaginator(Consumer<ExportFormsRequest.Builder> exportFormsRequest) {
        return exportFormsPaginator(ExportFormsRequest.builder().applyMutation(exportFormsRequest).build());
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportThemesRequest
     * @return A Java Future containing the result of the ExportThemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportThemesResponse> exportThemes(ExportThemesRequest exportThemesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ExportThemesRequest#builder()}
     * </p>
     *
     * @param exportThemesRequest
     *        A {@link Consumer} that will call methods on {@link ExportThemesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportThemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportThemesResponse> exportThemes(Consumer<ExportThemesRequest.Builder> exportThemesRequest) {
        return exportThemes(ExportThemesRequest.builder().applyMutation(exportThemesRequest).build());
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesPublisher publisher = client.exportThemesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesPublisher publisher = client.exportThemesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation.</b>
     * </p>
     *
     * @param exportThemesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesPublisher exportThemesPaginator(ExportThemesRequest exportThemesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesPublisher publisher = client.exportThemesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesPublisher publisher = client.exportThemesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ExportThemesRequest#builder()}
     * </p>
     *
     * @param exportThemesRequest
     *        A {@link Consumer} that will call methods on {@link ExportThemesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesPublisher exportThemesPaginator(Consumer<ExportThemesRequest.Builder> exportThemesRequest) {
        return exportThemesPaginator(ExportThemesRequest.builder().applyMutation(exportThemesRequest).build());
    }

    /**
     * <p>
     * Returns an existing code generation job.
     * </p>
     *
     * @param getCodegenJobRequest
     * @return A Java Future containing the result of the GetCodegenJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodegenJobResponse> getCodegenJob(GetCodegenJobRequest getCodegenJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing code generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodegenJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetCodegenJobRequest#builder()}
     * </p>
     *
     * @param getCodegenJobRequest
     *        A {@link Consumer} that will call methods on {@link GetCodegenJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCodegenJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodegenJobResponse> getCodegenJob(Consumer<GetCodegenJobRequest.Builder> getCodegenJobRequest) {
        return getCodegenJob(GetCodegenJobRequest.builder().applyMutation(getCodegenJobRequest).build());
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Returns an existing form for an Amplify app.
     * </p>
     *
     * @param getFormRequest
     * @return A Java Future containing the result of the GetForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetForm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormResponse> getForm(GetFormRequest getFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing form for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFormRequest.Builder} avoiding the need to create
     * one manually via {@link GetFormRequest#builder()}
     * </p>
     *
     * @param getFormRequest
     *        A {@link Consumer} that will call methods on {@link GetFormRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetForm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormResponse> getForm(Consumer<GetFormRequest.Builder> getFormRequest) {
        return getForm(GetFormRequest.builder().applyMutation(getFormRequest).build());
    }

    /**
     * <p>
     * Returns existing metadata for an Amplify app.
     * </p>
     *
     * @param getMetadataRequest
     * @return A Java Future containing the result of the GetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You don't have permission to perform this operation.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMetadataResponse> getMetadata(GetMetadataRequest getMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns existing metadata for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetadataRequest#builder()}
     * </p>
     *
     * @param getMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You don't have permission to perform this operation.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMetadataResponse> getMetadata(Consumer<GetMetadataRequest.Builder> getMetadataRequest) {
        return getMetadata(GetMetadataRequest.builder().applyMutation(getMetadataRequest).build());
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     *
     * @param getThemeRequest
     * @return A Java Future containing the result of the GetTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetThemeResponse> getTheme(GetThemeRequest getThemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThemeRequest.Builder} avoiding the need to
     * create one manually via {@link GetThemeRequest#builder()}
     * </p>
     *
     * @param getThemeRequest
     *        A {@link Consumer} that will call methods on {@link GetThemeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist, or access was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetThemeResponse> getTheme(Consumer<GetThemeRequest.Builder> getThemeRequest) {
        return getTheme(GetThemeRequest.builder().applyMutation(getThemeRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of code generation jobs for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listCodegenJobsRequest
     * @return A Java Future containing the result of the ListCodegenJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListCodegenJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListCodegenJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodegenJobsResponse> listCodegenJobs(ListCodegenJobsRequest listCodegenJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of code generation jobs for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodegenJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCodegenJobsRequest#builder()}
     * </p>
     *
     * @param listCodegenJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCodegenJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCodegenJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListCodegenJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListCodegenJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodegenJobsResponse> listCodegenJobs(
            Consumer<ListCodegenJobsRequest.Builder> listCodegenJobsRequest) {
        return listCodegenJobs(ListCodegenJobsRequest.builder().applyMutation(listCodegenJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of code generation jobs for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodegenJobs(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListCodegenJobsPublisher publisher = client.listCodegenJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListCodegenJobsPublisher publisher = client.listCodegenJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodegenJobs(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodegenJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListCodegenJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListCodegenJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodegenJobsPublisher listCodegenJobsPaginator(ListCodegenJobsRequest listCodegenJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of code generation jobs for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodegenJobs(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListCodegenJobsPublisher publisher = client.listCodegenJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListCodegenJobsPublisher publisher = client.listCodegenJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodegenJobs(software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodegenJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCodegenJobsRequest#builder()}
     * </p>
     *
     * @param listCodegenJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCodegenJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListCodegenJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListCodegenJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodegenJobsPublisher listCodegenJobsPaginator(Consumer<ListCodegenJobsRequest.Builder> listCodegenJobsRequest) {
        return listCodegenJobsPaginator(ListCodegenJobsRequest.builder().applyMutation(listCodegenJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listFormsRequest
     * @return A Java Future containing the result of the ListForms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFormsResponse> listForms(ListFormsRequest listFormsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFormsRequest#builder()}
     * </p>
     *
     * @param listFormsRequest
     *        A {@link Consumer} that will call methods on {@link ListFormsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListForms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFormsResponse> listForms(Consumer<ListFormsRequest.Builder> listFormsRequest) {
        return listForms(ListFormsRequest.builder().applyMutation(listFormsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsPublisher publisher = client.listFormsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsPublisher publisher = client.listFormsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)} operation.</b>
     * </p>
     *
     * @param listFormsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsPublisher listFormsPaginator(ListFormsRequest listFormsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsPublisher publisher = client.listFormsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsPublisher publisher = client.listFormsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFormsRequest#builder()}
     * </p>
     *
     * @param listFormsRequest
     *        A {@link Consumer} that will call methods on {@link ListFormsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsPublisher listFormsPaginator(Consumer<ListFormsRequest.Builder> listFormsRequest) {
        return listFormsPaginator(ListFormsRequest.builder().applyMutation(listFormsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listThemesRequest
     * @return A Java Future containing the result of the ListThemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListThemesResponse> listThemes(ListThemesRequest listThemesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListThemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListThemesResponse> listThemes(Consumer<ListThemesRequest.Builder> listThemesRequest) {
        return listThemes(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     *
     * @param listThemesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesPublisher listThemesPaginator(ListThemesRequest listThemesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesPublisher listThemesPaginator(Consumer<ListThemesRequest.Builder> listThemesRequest) {
        return listThemesPaginator(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Stores the metadata information about a feature on a form.
     * </p>
     *
     * @param putMetadataFlagRequest
     * @return A Java Future containing the result of the PutMetadataFlag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You don't have permission to perform this operation.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.PutMetadataFlag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlag"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMetadataFlagResponse> putMetadataFlag(PutMetadataFlagRequest putMetadataFlagRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores the metadata information about a feature on a form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMetadataFlagRequest.Builder} avoiding the need
     * to create one manually via {@link PutMetadataFlagRequest#builder()}
     * </p>
     *
     * @param putMetadataFlagRequest
     *        A {@link Consumer} that will call methods on {@link PutMetadataFlagRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutMetadataFlag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You don't have permission to perform this operation.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.PutMetadataFlag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlag"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMetadataFlagResponse> putMetadataFlag(
            Consumer<PutMetadataFlagRequest.Builder> putMetadataFlagRequest) {
        return putMetadataFlag(PutMetadataFlagRequest.builder().applyMutation(putMetadataFlagRequest).build());
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     *
     * @param refreshTokenRequest
     * @return A Java Future containing the result of the RefreshToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RefreshTokenResponse> refreshToken(RefreshTokenRequest refreshTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshTokenRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshTokenRequest#builder()}
     * </p>
     *
     * @param refreshTokenRequest
     *        A {@link Consumer} that will call methods on {@link RefreshTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RefreshToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RefreshTokenResponse> refreshToken(Consumer<RefreshTokenRequest.Builder> refreshTokenRequest) {
        return refreshToken(RefreshTokenRequest.builder().applyMutation(refreshTokenRequest).build());
    }

    /**
     * <p>
     * Starts a code generation job for for a specified Amplify app and backend environment.
     * </p>
     *
     * @param startCodegenJobRequest
     * @return A Java Future containing the result of the StartCodegenJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.StartCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/StartCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCodegenJobResponse> startCodegenJob(StartCodegenJobRequest startCodegenJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a code generation job for for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCodegenJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartCodegenJobRequest#builder()}
     * </p>
     *
     * @param startCodegenJobRequest
     *        A {@link Consumer} that will call methods on {@link StartCodegenJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartCodegenJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.StartCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/StartCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCodegenJobResponse> startCodegenJob(
            Consumer<StartCodegenJobRequest.Builder> startCodegenJobRequest) {
        return startCodegenJob(StartCodegenJobRequest.builder().applyMutation(startCodegenJobRequest).build());
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     *
     * @param updateComponentRequest
     * @return A Java Future containing the result of the UpdateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateComponentResponse> updateComponent(UpdateComponentRequest updateComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateComponentRequest#builder()}
     * </p>
     *
     * @param updateComponentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateComponentResponse> updateComponent(
            Consumer<UpdateComponentRequest.Builder> updateComponentRequest) {
        return updateComponent(UpdateComponentRequest.builder().applyMutation(updateComponentRequest).build());
    }

    /**
     * <p>
     * Updates an existing form.
     * </p>
     *
     * @param updateFormRequest
     * @return A Java Future containing the result of the UpdateForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFormResponse> updateForm(UpdateFormRequest updateFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFormRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFormRequest#builder()}
     * </p>
     *
     * @param updateFormRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFormRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFormResponse> updateForm(Consumer<UpdateFormRequest.Builder> updateFormRequest) {
        return updateForm(UpdateFormRequest.builder().applyMutation(updateFormRequest).build());
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return A Java Future containing the result of the UpdateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateThemeResponse> updateTheme(UpdateThemeRequest updateThemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateThemeRequest#builder()}
     * </p>
     *
     * @param updateThemeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>InternalServerException An internal error has occurred. Please retry your request.</li>
     *         <li>InvalidParameterException An invalid or out-of-range value was supplied for the input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyUiBuilderException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyUiBuilderAsyncClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateThemeResponse> updateTheme(Consumer<UpdateThemeRequest.Builder> updateThemeRequest) {
        return updateTheme(UpdateThemeRequest.builder().applyMutation(updateThemeRequest).build());
    }

    @Override
    default AmplifyUiBuilderServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AmplifyUiBuilderAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyUiBuilderAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyUiBuilderAsyncClient}.
     */
    static AmplifyUiBuilderAsyncClientBuilder builder() {
        return new DefaultAmplifyUiBuilderAsyncClientBuilder();
    }
}
