/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration information for rendering the UI component associated the code generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenJobRenderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenJobRenderConfig.Builder, CodegenJobRenderConfig> {
    private static final SdkField<ReactStartCodegenJobData> REACT_FIELD = SdkField
            .<ReactStartCodegenJobData> builder(MarshallingType.SDK_POJO).memberName("react")
            .getter(getter(CodegenJobRenderConfig::react)).setter(setter(Builder::react))
            .constructor(ReactStartCodegenJobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("react").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReactStartCodegenJobData react;

    private final Type type;

    private CodegenJobRenderConfig(BuilderImpl builder) {
        this.react = builder.react;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the <code>ReactStartCodegenJobData</code> object.
     * </p>
     * 
     * @return The name of the <code>ReactStartCodegenJobData</code> object.
     */
    public final ReactStartCodegenJobData react() {
        return react;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(react());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenJobRenderConfig)) {
            return false;
        }
        CodegenJobRenderConfig other = (CodegenJobRenderConfig) obj;
        return Objects.equals(react(), other.react());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenJobRenderConfig").add("React", react()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "react":
            return Optional.ofNullable(clazz.cast(react()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #react()} initialized to the given value.
     *
     * <p>
     * The name of the <code>ReactStartCodegenJobData</code> object.
     * </p>
     * 
     * @param react
     *        The name of the <code>ReactStartCodegenJobData</code> object.
     */
    public static CodegenJobRenderConfig fromReact(ReactStartCodegenJobData react) {
        return builder().react(react).build();
    }

    /**
     * Create an instance of this class with {@link #react()} initialized to the given value.
     *
     * <p>
     * The name of the <code>ReactStartCodegenJobData</code> object.
     * </p>
     * 
     * @param react
     *        The name of the <code>ReactStartCodegenJobData</code> object.
     */
    public static CodegenJobRenderConfig fromReact(Consumer<ReactStartCodegenJobData.Builder> react) {
        ReactStartCodegenJobData.Builder builder = ReactStartCodegenJobData.builder();
        react.accept(builder);
        return fromReact(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodegenJobRenderConfig, T> g) {
        return obj -> g.apply((CodegenJobRenderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenJobRenderConfig> {
        /**
         * <p>
         * The name of the <code>ReactStartCodegenJobData</code> object.
         * </p>
         * 
         * @param react
         *        The name of the <code>ReactStartCodegenJobData</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder react(ReactStartCodegenJobData react);

        /**
         * <p>
         * The name of the <code>ReactStartCodegenJobData</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReactStartCodegenJobData.Builder}
         * avoiding the need to create one manually via {@link ReactStartCodegenJobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReactStartCodegenJobData.Builder#build()} is called immediately
         * and its result is passed to {@link #react(ReactStartCodegenJobData)}.
         * 
         * @param react
         *        a consumer that will call methods on {@link ReactStartCodegenJobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #react(ReactStartCodegenJobData)
         */
        default Builder react(Consumer<ReactStartCodegenJobData.Builder> react) {
            return react(ReactStartCodegenJobData.builder().applyMutation(react).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReactStartCodegenJobData react;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenJobRenderConfig model) {
            react(model.react);
        }

        public final ReactStartCodegenJobData.Builder getReact() {
            return react != null ? react.toBuilder() : null;
        }

        public final void setReact(ReactStartCodegenJobData.BuilderImpl react) {
            Object oldValue = this.react;
            this.react = react != null ? react.build() : null;
            handleUnionValueChange(Type.REACT, oldValue, this.react);
        }

        @Override
        public final Builder react(ReactStartCodegenJobData react) {
            Object oldValue = this.react;
            this.react = react;
            handleUnionValueChange(Type.REACT, oldValue, this.react);
            return this;
        }

        @Override
        public CodegenJobRenderConfig build() {
            return new CodegenJobRenderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CodegenJobRenderConfig#type()
     */
    public enum Type {
        REACT,

        UNKNOWN_TO_SDK_VERSION
    }
}
