/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the read, write, and delete permissions users have against your storage S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendStoragePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendStoragePermissions.Builder, BackendStoragePermissions> {
    private static final SdkField<List<String>> AUTHENTICATED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Authenticated")
            .getter(getter(BackendStoragePermissions::authenticatedAsStrings))
            .setter(setter(Builder::authenticatedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UN_AUTHENTICATED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UnAuthenticated")
            .getter(getter(BackendStoragePermissions::unAuthenticatedAsStrings))
            .setter(setter(Builder::unAuthenticatedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unAuthenticated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATED_FIELD,
            UN_AUTHENTICATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> authenticated;

    private final List<String> unAuthenticated;

    private BackendStoragePermissions(BuilderImpl builder) {
        this.authenticated = builder.authenticated;
        this.unAuthenticated = builder.unAuthenticated;
    }

    /**
     * <p>
     * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticated} method.
     * </p>
     * 
     * @return Lists all authenticated user read, write, and delete permissions for your S3 bucket.
     */
    public final List<AuthenticatedElement> authenticated() {
        return ListOfAuthenticatedElementCopier.copyStringToEnum(authenticated);
    }

    /**
     * For responses, this returns true if the service returned a value for the Authenticated property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthenticated() {
        return authenticated != null && !(authenticated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticated} method.
     * </p>
     * 
     * @return Lists all authenticated user read, write, and delete permissions for your S3 bucket.
     */
    public final List<String> authenticatedAsStrings() {
        return authenticated;
    }

    /**
     * <p>
     * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnAuthenticated} method.
     * </p>
     * 
     * @return Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
     */
    public final List<UnAuthenticatedElement> unAuthenticated() {
        return ListOfUnAuthenticatedElementCopier.copyStringToEnum(unAuthenticated);
    }

    /**
     * For responses, this returns true if the service returned a value for the UnAuthenticated property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnAuthenticated() {
        return unAuthenticated != null && !(unAuthenticated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnAuthenticated} method.
     * </p>
     * 
     * @return Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
     */
    public final List<String> unAuthenticatedAsStrings() {
        return unAuthenticated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticated() ? authenticatedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnAuthenticated() ? unAuthenticatedAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendStoragePermissions)) {
            return false;
        }
        BackendStoragePermissions other = (BackendStoragePermissions) obj;
        return hasAuthenticated() == other.hasAuthenticated()
                && Objects.equals(authenticatedAsStrings(), other.authenticatedAsStrings())
                && hasUnAuthenticated() == other.hasUnAuthenticated()
                && Objects.equals(unAuthenticatedAsStrings(), other.unAuthenticatedAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendStoragePermissions")
                .add("Authenticated", hasAuthenticated() ? authenticatedAsStrings() : null)
                .add("UnAuthenticated", hasUnAuthenticated() ? unAuthenticatedAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authenticated":
            return Optional.ofNullable(clazz.cast(authenticatedAsStrings()));
        case "UnAuthenticated":
            return Optional.ofNullable(clazz.cast(unAuthenticatedAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendStoragePermissions, T> g) {
        return obj -> g.apply((BackendStoragePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendStoragePermissions> {
        /**
         * <p>
         * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param authenticated
         *        Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticatedWithStrings(Collection<String> authenticated);

        /**
         * <p>
         * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param authenticated
         *        Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticatedWithStrings(String... authenticated);

        /**
         * <p>
         * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param authenticated
         *        Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticated(Collection<AuthenticatedElement> authenticated);

        /**
         * <p>
         * Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param authenticated
         *        Lists all authenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticated(AuthenticatedElement... authenticated);

        /**
         * <p>
         * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param unAuthenticated
         *        Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unAuthenticatedWithStrings(Collection<String> unAuthenticated);

        /**
         * <p>
         * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param unAuthenticated
         *        Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unAuthenticatedWithStrings(String... unAuthenticated);

        /**
         * <p>
         * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param unAuthenticated
         *        Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unAuthenticated(Collection<UnAuthenticatedElement> unAuthenticated);

        /**
         * <p>
         * Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * </p>
         * 
         * @param unAuthenticated
         *        Lists all unauthenticated user read, write, and delete permissions for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unAuthenticated(UnAuthenticatedElement... unAuthenticated);
    }

    static final class BuilderImpl implements Builder {
        private List<String> authenticated = DefaultSdkAutoConstructList.getInstance();

        private List<String> unAuthenticated = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackendStoragePermissions model) {
            authenticatedWithStrings(model.authenticated);
            unAuthenticatedWithStrings(model.unAuthenticated);
        }

        public final Collection<String> getAuthenticated() {
            if (authenticated instanceof SdkAutoConstructList) {
                return null;
            }
            return authenticated;
        }

        public final void setAuthenticated(Collection<String> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copy(authenticated);
        }

        @Override
        public final Builder authenticatedWithStrings(Collection<String> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copy(authenticated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticatedWithStrings(String... authenticated) {
            authenticatedWithStrings(Arrays.asList(authenticated));
            return this;
        }

        @Override
        public final Builder authenticated(Collection<AuthenticatedElement> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copyEnumToString(authenticated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticated(AuthenticatedElement... authenticated) {
            authenticated(Arrays.asList(authenticated));
            return this;
        }

        public final Collection<String> getUnAuthenticated() {
            if (unAuthenticated instanceof SdkAutoConstructList) {
                return null;
            }
            return unAuthenticated;
        }

        public final void setUnAuthenticated(Collection<String> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copy(unAuthenticated);
        }

        @Override
        public final Builder unAuthenticatedWithStrings(Collection<String> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copy(unAuthenticated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unAuthenticatedWithStrings(String... unAuthenticated) {
            unAuthenticatedWithStrings(Arrays.asList(unAuthenticated));
            return this;
        }

        @Override
        public final Builder unAuthenticated(Collection<UnAuthenticatedElement> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copyEnumToString(unAuthenticated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unAuthenticated(UnAuthenticatedElement... unAuthenticated) {
            unAuthenticated(Arrays.asList(unAuthenticated));
            return this;
        }

        @Override
        public BackendStoragePermissions build() {
            return new BackendStoragePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
