/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Cognito user pool configuration for the authorization resource to be configured for your Amplify
 * project on an update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendAuthUserPoolConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendAuthUserPoolConfig.Builder, UpdateBackendAuthUserPoolConfig> {
    private static final SdkField<UpdateBackendAuthForgotPasswordConfig> FORGOT_PASSWORD_FIELD = SdkField
            .<UpdateBackendAuthForgotPasswordConfig> builder(MarshallingType.SDK_POJO).memberName("ForgotPassword")
            .getter(getter(UpdateBackendAuthUserPoolConfig::forgotPassword)).setter(setter(Builder::forgotPassword))
            .constructor(UpdateBackendAuthForgotPasswordConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forgotPassword").build()).build();

    private static final SdkField<UpdateBackendAuthMFAConfig> MFA_FIELD = SdkField
            .<UpdateBackendAuthMFAConfig> builder(MarshallingType.SDK_POJO).memberName("Mfa")
            .getter(getter(UpdateBackendAuthUserPoolConfig::mfa)).setter(setter(Builder::mfa))
            .constructor(UpdateBackendAuthMFAConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfa").build()).build();

    private static final SdkField<UpdateBackendAuthOAuthConfig> O_AUTH_FIELD = SdkField
            .<UpdateBackendAuthOAuthConfig> builder(MarshallingType.SDK_POJO).memberName("OAuth")
            .getter(getter(UpdateBackendAuthUserPoolConfig::oAuth)).setter(setter(Builder::oAuth))
            .constructor(UpdateBackendAuthOAuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth").build()).build();

    private static final SdkField<UpdateBackendAuthPasswordPolicyConfig> PASSWORD_POLICY_FIELD = SdkField
            .<UpdateBackendAuthPasswordPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("PasswordPolicy")
            .getter(getter(UpdateBackendAuthUserPoolConfig::passwordPolicy)).setter(setter(Builder::passwordPolicy))
            .constructor(UpdateBackendAuthPasswordPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordPolicy").build()).build();

    private static final SdkField<UpdateBackendAuthVerificationMessageConfig> VERIFICATION_MESSAGE_FIELD = SdkField
            .<UpdateBackendAuthVerificationMessageConfig> builder(MarshallingType.SDK_POJO).memberName("VerificationMessage")
            .getter(getter(UpdateBackendAuthUserPoolConfig::verificationMessage)).setter(setter(Builder::verificationMessage))
            .constructor(UpdateBackendAuthVerificationMessageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORGOT_PASSWORD_FIELD,
            MFA_FIELD, O_AUTH_FIELD, PASSWORD_POLICY_FIELD, VERIFICATION_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateBackendAuthForgotPasswordConfig forgotPassword;

    private final UpdateBackendAuthMFAConfig mfa;

    private final UpdateBackendAuthOAuthConfig oAuth;

    private final UpdateBackendAuthPasswordPolicyConfig passwordPolicy;

    private final UpdateBackendAuthVerificationMessageConfig verificationMessage;

    private UpdateBackendAuthUserPoolConfig(BuilderImpl builder) {
        this.forgotPassword = builder.forgotPassword;
        this.mfa = builder.mfa;
        this.oAuth = builder.oAuth;
        this.passwordPolicy = builder.passwordPolicy;
        this.verificationMessage = builder.verificationMessage;
    }

    /**
     * <p>
     * <b>(DEPRECATED)</b> Describes the forgot password policy for your Amazon Cognito user pool, configured as a part
     * of your Amplify project.
     * </p>
     * 
     * @return (DEPRECATED)
     */
    public final UpdateBackendAuthForgotPasswordConfig forgotPassword() {
        return forgotPassword;
    }

    /**
     * <p>
     * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a
     * part of your Amplify project.
     * </p>
     * 
     * @return Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool
     *         configured as a part of your Amplify project.
     */
    public final UpdateBackendAuthMFAConfig mfa() {
        return mfa;
    }

    /**
     * <p>
     * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
     * project.
     * </p>
     * 
     * @return Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your
     *         Amplify project.
     */
    public final UpdateBackendAuthOAuthConfig oAuth() {
        return oAuth;
    }

    /**
     * <p>
     * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.
     * </p>
     * 
     * @return Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
     *         project.
     */
    public final UpdateBackendAuthPasswordPolicyConfig passwordPolicy() {
        return passwordPolicy;
    }

    /**
     * <p>
     * Describes the email or SMS verification message for your Amazon Cognito user pool, configured as a part of your
     * Amplify project.
     * </p>
     * 
     * @return Describes the email or SMS verification message for your Amazon Cognito user pool, configured as a part
     *         of your Amplify project.
     */
    public final UpdateBackendAuthVerificationMessageConfig verificationMessage() {
        return verificationMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forgotPassword());
        hashCode = 31 * hashCode + Objects.hashCode(mfa());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth());
        hashCode = 31 * hashCode + Objects.hashCode(passwordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(verificationMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthUserPoolConfig)) {
            return false;
        }
        UpdateBackendAuthUserPoolConfig other = (UpdateBackendAuthUserPoolConfig) obj;
        return Objects.equals(forgotPassword(), other.forgotPassword()) && Objects.equals(mfa(), other.mfa())
                && Objects.equals(oAuth(), other.oAuth()) && Objects.equals(passwordPolicy(), other.passwordPolicy())
                && Objects.equals(verificationMessage(), other.verificationMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendAuthUserPoolConfig").add("ForgotPassword", forgotPassword()).add("Mfa", mfa())
                .add("OAuth", oAuth()).add("PasswordPolicy", passwordPolicy()).add("VerificationMessage", verificationMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForgotPassword":
            return Optional.ofNullable(clazz.cast(forgotPassword()));
        case "Mfa":
            return Optional.ofNullable(clazz.cast(mfa()));
        case "OAuth":
            return Optional.ofNullable(clazz.cast(oAuth()));
        case "PasswordPolicy":
            return Optional.ofNullable(clazz.cast(passwordPolicy()));
        case "VerificationMessage":
            return Optional.ofNullable(clazz.cast(verificationMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthUserPoolConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthUserPoolConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendAuthUserPoolConfig> {
        /**
         * <p>
         * <b>(DEPRECATED)</b> Describes the forgot password policy for your Amazon Cognito user pool, configured as a
         * part of your Amplify project.
         * </p>
         * 
         * @param forgotPassword
         *        (DEPRECATED)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forgotPassword(UpdateBackendAuthForgotPasswordConfig forgotPassword);

        /**
         * <p>
         * <b>(DEPRECATED)</b> Describes the forgot password policy for your Amazon Cognito user pool, configured as a
         * part of your Amplify project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateBackendAuthForgotPasswordConfig.Builder} avoiding the need to create one manually via
         * {@link UpdateBackendAuthForgotPasswordConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBackendAuthForgotPasswordConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #forgotPassword(UpdateBackendAuthForgotPasswordConfig)}.
         * 
         * @param forgotPassword
         *        a consumer that will call methods on {@link UpdateBackendAuthForgotPasswordConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forgotPassword(UpdateBackendAuthForgotPasswordConfig)
         */
        default Builder forgotPassword(Consumer<UpdateBackendAuthForgotPasswordConfig.Builder> forgotPassword) {
            return forgotPassword(UpdateBackendAuthForgotPasswordConfig.builder().applyMutation(forgotPassword).build());
        }

        /**
         * <p>
         * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured
         * as a part of your Amplify project.
         * </p>
         * 
         * @param mfa
         *        Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool
         *        configured as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfa(UpdateBackendAuthMFAConfig mfa);

        /**
         * <p>
         * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured
         * as a part of your Amplify project.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateBackendAuthMFAConfig.Builder}
         * avoiding the need to create one manually via {@link UpdateBackendAuthMFAConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBackendAuthMFAConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #mfa(UpdateBackendAuthMFAConfig)}.
         * 
         * @param mfa
         *        a consumer that will call methods on {@link UpdateBackendAuthMFAConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfa(UpdateBackendAuthMFAConfig)
         */
        default Builder mfa(Consumer<UpdateBackendAuthMFAConfig.Builder> mfa) {
            return mfa(UpdateBackendAuthMFAConfig.builder().applyMutation(mfa).build());
        }

        /**
         * <p>
         * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * 
         * @param oAuth
         *        Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your
         *        Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth(UpdateBackendAuthOAuthConfig oAuth);

        /**
         * <p>
         * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateBackendAuthOAuthConfig.Builder}
         * avoiding the need to create one manually via {@link UpdateBackendAuthOAuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBackendAuthOAuthConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #oAuth(UpdateBackendAuthOAuthConfig)}.
         * 
         * @param oAuth
         *        a consumer that will call methods on {@link UpdateBackendAuthOAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth(UpdateBackendAuthOAuthConfig)
         */
        default Builder oAuth(Consumer<UpdateBackendAuthOAuthConfig.Builder> oAuth) {
            return oAuth(UpdateBackendAuthOAuthConfig.builder().applyMutation(oAuth).build());
        }

        /**
         * <p>
         * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * 
         * @param passwordPolicy
         *        Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordPolicy(UpdateBackendAuthPasswordPolicyConfig passwordPolicy);

        /**
         * <p>
         * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateBackendAuthPasswordPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link UpdateBackendAuthPasswordPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBackendAuthPasswordPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #passwordPolicy(UpdateBackendAuthPasswordPolicyConfig)}.
         * 
         * @param passwordPolicy
         *        a consumer that will call methods on {@link UpdateBackendAuthPasswordPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordPolicy(UpdateBackendAuthPasswordPolicyConfig)
         */
        default Builder passwordPolicy(Consumer<UpdateBackendAuthPasswordPolicyConfig.Builder> passwordPolicy) {
            return passwordPolicy(UpdateBackendAuthPasswordPolicyConfig.builder().applyMutation(passwordPolicy).build());
        }

        /**
         * <p>
         * Describes the email or SMS verification message for your Amazon Cognito user pool, configured as a part of
         * your Amplify project.
         * </p>
         * 
         * @param verificationMessage
         *        Describes the email or SMS verification message for your Amazon Cognito user pool, configured as a
         *        part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationMessage(UpdateBackendAuthVerificationMessageConfig verificationMessage);

        /**
         * <p>
         * Describes the email or SMS verification message for your Amazon Cognito user pool, configured as a part of
         * your Amplify project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateBackendAuthVerificationMessageConfig.Builder} avoiding the need to create one manually via
         * {@link UpdateBackendAuthVerificationMessageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBackendAuthVerificationMessageConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #verificationMessage(UpdateBackendAuthVerificationMessageConfig)}.
         * 
         * @param verificationMessage
         *        a consumer that will call methods on {@link UpdateBackendAuthVerificationMessageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationMessage(UpdateBackendAuthVerificationMessageConfig)
         */
        default Builder verificationMessage(Consumer<UpdateBackendAuthVerificationMessageConfig.Builder> verificationMessage) {
            return verificationMessage(UpdateBackendAuthVerificationMessageConfig.builder().applyMutation(verificationMessage)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateBackendAuthForgotPasswordConfig forgotPassword;

        private UpdateBackendAuthMFAConfig mfa;

        private UpdateBackendAuthOAuthConfig oAuth;

        private UpdateBackendAuthPasswordPolicyConfig passwordPolicy;

        private UpdateBackendAuthVerificationMessageConfig verificationMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthUserPoolConfig model) {
            forgotPassword(model.forgotPassword);
            mfa(model.mfa);
            oAuth(model.oAuth);
            passwordPolicy(model.passwordPolicy);
            verificationMessage(model.verificationMessage);
        }

        public final UpdateBackendAuthForgotPasswordConfig.Builder getForgotPassword() {
            return forgotPassword != null ? forgotPassword.toBuilder() : null;
        }

        public final void setForgotPassword(UpdateBackendAuthForgotPasswordConfig.BuilderImpl forgotPassword) {
            this.forgotPassword = forgotPassword != null ? forgotPassword.build() : null;
        }

        @Override
        public final Builder forgotPassword(UpdateBackendAuthForgotPasswordConfig forgotPassword) {
            this.forgotPassword = forgotPassword;
            return this;
        }

        public final UpdateBackendAuthMFAConfig.Builder getMfa() {
            return mfa != null ? mfa.toBuilder() : null;
        }

        public final void setMfa(UpdateBackendAuthMFAConfig.BuilderImpl mfa) {
            this.mfa = mfa != null ? mfa.build() : null;
        }

        @Override
        public final Builder mfa(UpdateBackendAuthMFAConfig mfa) {
            this.mfa = mfa;
            return this;
        }

        public final UpdateBackendAuthOAuthConfig.Builder getOAuth() {
            return oAuth != null ? oAuth.toBuilder() : null;
        }

        public final void setOAuth(UpdateBackendAuthOAuthConfig.BuilderImpl oAuth) {
            this.oAuth = oAuth != null ? oAuth.build() : null;
        }

        @Override
        public final Builder oAuth(UpdateBackendAuthOAuthConfig oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        public final UpdateBackendAuthPasswordPolicyConfig.Builder getPasswordPolicy() {
            return passwordPolicy != null ? passwordPolicy.toBuilder() : null;
        }

        public final void setPasswordPolicy(UpdateBackendAuthPasswordPolicyConfig.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        @Override
        public final Builder passwordPolicy(UpdateBackendAuthPasswordPolicyConfig passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final UpdateBackendAuthVerificationMessageConfig.Builder getVerificationMessage() {
            return verificationMessage != null ? verificationMessage.toBuilder() : null;
        }

        public final void setVerificationMessage(UpdateBackendAuthVerificationMessageConfig.BuilderImpl verificationMessage) {
            this.verificationMessage = verificationMessage != null ? verificationMessage.build() : null;
        }

        @Override
        public final Builder verificationMessage(UpdateBackendAuthVerificationMessageConfig verificationMessage) {
            this.verificationMessage = verificationMessage;
            return this;
        }

        @Override
        public UpdateBackendAuthUserPoolConfig build() {
            return new UpdateBackendAuthUserPoolConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
