/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the email sent when an app user forgets their password.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailSettings implements SdkPojo, Serializable, ToCopyableBuilder<EmailSettings.Builder, EmailSettings> {
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailMessage").getter(getter(EmailSettings::emailMessage)).setter(setter(Builder::emailMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailMessage").build()).build();

    private static final SdkField<String> EMAIL_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailSubject").getter(getter(EmailSettings::emailSubject)).setter(setter(Builder::emailSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailSubject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_MESSAGE_FIELD,
            EMAIL_SUBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String emailMessage;

    private final String emailSubject;

    private EmailSettings(BuilderImpl builder) {
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
    }

    /**
     * <p>
     * The contents of the email message.
     * </p>
     * 
     * @return The contents of the email message.
     */
    public final String emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The contents of the subject line of the email message.
     * </p>
     * 
     * @return The contents of the subject line of the email message.
     */
    public final String emailSubject() {
        return emailSubject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailSettings)) {
            return false;
        }
        EmailSettings other = (EmailSettings) obj;
        return Objects.equals(emailMessage(), other.emailMessage()) && Objects.equals(emailSubject(), other.emailSubject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailSettings").add("EmailMessage", emailMessage()).add("EmailSubject", emailSubject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "EmailSubject":
            return Optional.ofNullable(clazz.cast(emailSubject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailSettings, T> g) {
        return obj -> g.apply((EmailSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailSettings> {
        /**
         * <p>
         * The contents of the email message.
         * </p>
         * 
         * @param emailMessage
         *        The contents of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(String emailMessage);

        /**
         * <p>
         * The contents of the subject line of the email message.
         * </p>
         * 
         * @param emailSubject
         *        The contents of the subject line of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubject(String emailSubject);
    }

    static final class BuilderImpl implements Builder {
        private String emailMessage;

        private String emailSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailSettings model) {
            emailMessage(model.emailMessage);
            emailSubject(model.emailSubject);
        }

        public final String getEmailMessage() {
            return emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getEmailSubject() {
            return emailSubject;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        @Override
        public EmailSettings build() {
            return new EmailSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
