/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendConfigRequest
extends AmplifyBackendRequest
implements ToCopyableBuilder<Builder, CreateBackendConfigRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(CreateBackendConfigRequest.getter(CreateBackendConfigRequest::appId)).setter(CreateBackendConfigRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_MANAGER_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendManagerAppId").getter(CreateBackendConfigRequest.getter(CreateBackendConfigRequest::backendManagerAppId)).setter(CreateBackendConfigRequest.setter(Builder::backendManagerAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendManagerAppId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_MANAGER_APP_ID_FIELD));
    private final String appId;
    private final String backendManagerAppId;

    private CreateBackendConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendManagerAppId = builder.backendManagerAppId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendManagerAppId() {
        return this.backendManagerAppId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendManagerAppId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendConfigRequest)) {
            return false;
        }
        CreateBackendConfigRequest other = (CreateBackendConfigRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendManagerAppId(), other.backendManagerAppId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendConfigRequest").add("AppId", (Object)this.appId()).add("BackendManagerAppId", (Object)this.backendManagerAppId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendManagerAppId": {
                return Optional.ofNullable(clazz.cast(this.backendManagerAppId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendConfigRequest, T> g) {
        return obj -> g.apply((CreateBackendConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String backendManagerAppId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendConfigRequest model) {
            super(model);
            this.appId(model.appId);
            this.backendManagerAppId(model.backendManagerAppId);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendManagerAppId() {
            return this.backendManagerAppId;
        }

        public final void setBackendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
        }

        @Override
        public final Builder backendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendConfigRequest build() {
            return new CreateBackendConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackendConfigRequest> {
        public Builder appId(String var1);

        public Builder backendManagerAppId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

