/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;

public class SearchUsersPublisher
implements SdkPublisher<SearchUsersResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchUsersPublisher(AlexaForBusinessAsyncClient client, SearchUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchUsersPublisher(AlexaForBusinessAsyncClient client, SearchUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchUsersResponseFetcher
    implements AsyncPageFetcher<SearchUsersResponse> {
        private SearchUsersResponseFetcher() {
        }

        public boolean hasNextPage(SearchUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchUsersResponse> nextPage(SearchUsersResponse previousPage) {
            if (previousPage == null) {
                return SearchUsersPublisher.this.client.searchUsers(SearchUsersPublisher.this.firstRequest);
            }
            return SearchUsersPublisher.this.client.searchUsers((SearchUsersRequest)((Object)SearchUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

