/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;

public class ListDeviceEventsIterable
implements SdkIterable<ListDeviceEventsResponse> {
    private final AlexaForBusinessClient client;
    private final ListDeviceEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceEventsIterable(AlexaForBusinessClient client, ListDeviceEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeviceEventsResponseFetcher();
    }

    public Iterator<ListDeviceEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeviceEventsResponseFetcher
    implements SyncPageFetcher<ListDeviceEventsResponse> {
        private ListDeviceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceEventsResponse nextPage(ListDeviceEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceEventsIterable.this.client.listDeviceEvents(ListDeviceEventsIterable.this.firstRequest);
            }
            return ListDeviceEventsIterable.this.client.listDeviceEvents((ListDeviceEventsRequest)((Object)ListDeviceEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

