/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData;
import software.amazon.awssdk.services.alexaforbusiness.model.AddressBookDataListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAddressBooksResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchAddressBooksResponse> {
    private static final SdkField<List<AddressBookData>> ADDRESS_BOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressBooks").getter(SearchAddressBooksResponse.getter(SearchAddressBooksResponse::addressBooks)).setter(SearchAddressBooksResponse.setter(Builder::addressBooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressBooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddressBookData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAddressBooksResponse.getter(SearchAddressBooksResponse::nextToken)).setter(SearchAddressBooksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchAddressBooksResponse.getter(SearchAddressBooksResponse::totalCount)).setter(SearchAddressBooksResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_BOOKS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<AddressBookData> addressBooks;
    private final String nextToken;
    private final Integer totalCount;

    private SearchAddressBooksResponse(BuilderImpl builder) {
        super(builder);
        this.addressBooks = builder.addressBooks;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasAddressBooks() {
        return this.addressBooks != null && !(this.addressBooks instanceof SdkAutoConstructList);
    }

    public final List<AddressBookData> addressBooks() {
        return this.addressBooks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressBooks() ? this.addressBooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAddressBooksResponse)) {
            return false;
        }
        SearchAddressBooksResponse other = (SearchAddressBooksResponse)((Object)obj);
        return this.hasAddressBooks() == other.hasAddressBooks() && Objects.equals(this.addressBooks(), other.addressBooks()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAddressBooksResponse").add("AddressBooks", this.hasAddressBooks() ? this.addressBooks() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressBooks": {
                return Optional.ofNullable(clazz.cast(this.addressBooks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAddressBooksResponse, T> g) {
        return obj -> g.apply((SearchAddressBooksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<AddressBookData> addressBooks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAddressBooksResponse model) {
            super(model);
            this.addressBooks(model.addressBooks);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final List<AddressBookData.Builder> getAddressBooks() {
            List<AddressBookData.Builder> result = AddressBookDataListCopier.copyToBuilder(this.addressBooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressBooks(Collection<AddressBookData.BuilderImpl> addressBooks) {
            this.addressBooks = AddressBookDataListCopier.copyFromBuilder(addressBooks);
        }

        @Override
        @Transient
        public final Builder addressBooks(Collection<AddressBookData> addressBooks) {
            this.addressBooks = AddressBookDataListCopier.copy(addressBooks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addressBooks(AddressBookData ... addressBooks) {
            this.addressBooks(Arrays.asList(addressBooks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addressBooks(Consumer<AddressBookData.Builder> ... addressBooks) {
            this.addressBooks(Stream.of(addressBooks).map(c -> (AddressBookData)((AddressBookData.Builder)AddressBookData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        @Transient
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public SearchAddressBooksResponse build() {
            return new SearchAddressBooksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAddressBooksResponse> {
        public Builder addressBooks(Collection<AddressBookData> var1);

        public Builder addressBooks(AddressBookData ... var1);

        public Builder addressBooks(Consumer<AddressBookData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

