/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BusinessReportFormat {
    CSV("CSV"),
    CSV_ZIP("CSV_ZIP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BusinessReportFormat> VALUE_MAP;
    private final String value;

    private BusinessReportFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BusinessReportFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BusinessReportFormat> knownValues() {
        EnumSet<BusinessReportFormat> knownValues = EnumSet.allOf(BusinessReportFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BusinessReportFormat.class, BusinessReportFormat::toString);
    }
}

