/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.internal.UserAgentUtils;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;

public class ListCertificatesIterable
implements SdkIterable<ListCertificatesResponse> {
    private final AcmClient client;
    private final ListCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCertificatesIterable(AcmClient client, ListCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCertificatesResponseFetcher();
    }

    public Iterator<ListCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CertificateSummary> certificateSummaryList() {
        Function<ListCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificateSummaryList() != null) {
                return response.certificateSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCertificatesResponseFetcher
    implements SyncPageFetcher<ListCertificatesResponse> {
        private ListCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCertificatesResponse nextPage(ListCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesIterable.this.client.listCertificates(ListCertificatesIterable.this.firstRequest);
            }
            return ListCertificatesIterable.this.client.listCertificates((ListCertificatesRequest)((Object)ListCertificatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

