/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails;
import software.amazon.awssdk.services.accessanalyzer.model.PolicyGenerationDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPolicyGenerationRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, StartPolicyGenerationRequest> {
    private static final SdkField<PolicyGenerationDetails> POLICY_GENERATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyGenerationDetails").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::policyGenerationDetails)).setter(StartPolicyGenerationRequest.setter(Builder::policyGenerationDetails)).constructor(PolicyGenerationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationDetails").build()}).build();
    private static final SdkField<CloudTrailDetails> CLOUD_TRAIL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudTrailDetails").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::cloudTrailDetails)).setter(StartPolicyGenerationRequest.setter(Builder::cloudTrailDetails)).constructor(CloudTrailDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailDetails").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::clientToken)).setter(StartPolicyGenerationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GENERATION_DETAILS_FIELD, CLOUD_TRAIL_DETAILS_FIELD, CLIENT_TOKEN_FIELD));
    private final PolicyGenerationDetails policyGenerationDetails;
    private final CloudTrailDetails cloudTrailDetails;
    private final String clientToken;

    private StartPolicyGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.policyGenerationDetails = builder.policyGenerationDetails;
        this.cloudTrailDetails = builder.cloudTrailDetails;
        this.clientToken = builder.clientToken;
    }

    public final PolicyGenerationDetails policyGenerationDetails() {
        return this.policyGenerationDetails;
    }

    public final CloudTrailDetails cloudTrailDetails() {
        return this.cloudTrailDetails;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyGenerationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrailDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPolicyGenerationRequest)) {
            return false;
        }
        StartPolicyGenerationRequest other = (StartPolicyGenerationRequest)((Object)obj);
        return Objects.equals(this.policyGenerationDetails(), other.policyGenerationDetails()) && Objects.equals(this.cloudTrailDetails(), other.cloudTrailDetails()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartPolicyGenerationRequest").add("PolicyGenerationDetails", (Object)this.policyGenerationDetails()).add("CloudTrailDetails", (Object)this.cloudTrailDetails()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyGenerationDetails": {
                return Optional.ofNullable(clazz.cast(this.policyGenerationDetails()));
            }
            case "cloudTrailDetails": {
                return Optional.ofNullable(clazz.cast(this.cloudTrailDetails()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPolicyGenerationRequest, T> g) {
        return obj -> g.apply((StartPolicyGenerationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private PolicyGenerationDetails policyGenerationDetails;
        private CloudTrailDetails cloudTrailDetails;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPolicyGenerationRequest model) {
            super(model);
            this.policyGenerationDetails(model.policyGenerationDetails);
            this.cloudTrailDetails(model.cloudTrailDetails);
            this.clientToken(model.clientToken);
        }

        public final PolicyGenerationDetails.Builder getPolicyGenerationDetails() {
            return this.policyGenerationDetails != null ? this.policyGenerationDetails.toBuilder() : null;
        }

        public final void setPolicyGenerationDetails(PolicyGenerationDetails.BuilderImpl policyGenerationDetails) {
            this.policyGenerationDetails = policyGenerationDetails != null ? policyGenerationDetails.build() : null;
        }

        @Override
        public final Builder policyGenerationDetails(PolicyGenerationDetails policyGenerationDetails) {
            this.policyGenerationDetails = policyGenerationDetails;
            return this;
        }

        public final CloudTrailDetails.Builder getCloudTrailDetails() {
            return this.cloudTrailDetails != null ? this.cloudTrailDetails.toBuilder() : null;
        }

        public final void setCloudTrailDetails(CloudTrailDetails.BuilderImpl cloudTrailDetails) {
            this.cloudTrailDetails = cloudTrailDetails != null ? cloudTrailDetails.build() : null;
        }

        @Override
        public final Builder cloudTrailDetails(CloudTrailDetails cloudTrailDetails) {
            this.cloudTrailDetails = cloudTrailDetails;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPolicyGenerationRequest build() {
            return new StartPolicyGenerationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPolicyGenerationRequest> {
        public Builder policyGenerationDetails(PolicyGenerationDetails var1);

        default public Builder policyGenerationDetails(Consumer<PolicyGenerationDetails.Builder> policyGenerationDetails) {
            return this.policyGenerationDetails((PolicyGenerationDetails)((PolicyGenerationDetails.Builder)PolicyGenerationDetails.builder().applyMutation(policyGenerationDetails)).build());
        }

        public Builder cloudTrailDetails(CloudTrailDetails var1);

        default public Builder cloudTrailDetails(Consumer<CloudTrailDetails.Builder> cloudTrailDetails) {
            return this.cloudTrailDetails((CloudTrailDetails)((CloudTrailDetails.Builder)CloudTrailDetails.builder().applyMutation(cloudTrailDetails)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

