/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Locale {
    DE("DE"),
    EN("EN"),
    ES("ES"),
    FR("FR"),
    IT("IT"),
    JA("JA"),
    KO("KO"),
    PT_BR("PT_BR"),
    ZH_CN("ZH_CN"),
    ZH_TW("ZH_TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Locale> VALUE_MAP;
    private final String value;

    private Locale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Locale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Locale> knownValues() {
        EnumSet<Locale> knownValues = EnumSet.allOf(Locale.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Locale.class, Locale::toString);
    }
}

