/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingSourceType {
    POLICY("POLICY"),
    BUCKET_ACL("BUCKET_ACL"),
    S3_ACCESS_POINT("S3_ACCESS_POINT"),
    S3_ACCESS_POINT_ACCOUNT("S3_ACCESS_POINT_ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingSourceType> VALUE_MAP;
    private final String value;

    private FindingSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingSourceType> knownValues() {
        EnumSet<FindingSourceType> knownValues = EnumSet.allOf(FindingSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingSourceType.class, FindingSourceType::toString);
    }
}

