/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse;

public class ListArchiveRulesPublisher
implements SdkPublisher<ListArchiveRulesResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListArchiveRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArchiveRulesPublisher(AccessAnalyzerAsyncClient client, ListArchiveRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArchiveRulesPublisher(AccessAnalyzerAsyncClient client, ListArchiveRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArchiveRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArchiveRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ArchiveRuleSummary> archiveRules() {
        Function<ListArchiveRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.archiveRules() != null) {
                return response.archiveRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListArchiveRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListArchiveRulesResponseFetcher
    implements AsyncPageFetcher<ListArchiveRulesResponse> {
        private ListArchiveRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListArchiveRulesResponse> nextPage(ListArchiveRulesResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveRulesPublisher.this.client.listArchiveRules(ListArchiveRulesPublisher.this.firstRequest);
            }
            return ListArchiveRulesPublisher.this.client.listArchiveRules((ListArchiveRulesRequest)((Object)ListArchiveRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

