/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse;

public class ListAccessPreviewsIterable
implements SdkIterable<ListAccessPreviewsResponse> {
    private final AccessAnalyzerClient client;
    private final ListAccessPreviewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPreviewsIterable(AccessAnalyzerClient client, ListAccessPreviewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessPreviewsResponseFetcher();
    }

    public Iterator<ListAccessPreviewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPreviewSummary> accessPreviews() {
        Function<ListAccessPreviewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPreviews() != null) {
                return response.accessPreviews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPreviewsResponseFetcher
    implements SyncPageFetcher<ListAccessPreviewsResponse> {
        private ListAccessPreviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPreviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPreviewsResponse nextPage(ListAccessPreviewsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPreviewsIterable.this.client.listAccessPreviews(ListAccessPreviewsIterable.this.firstRequest);
            }
            return ListAccessPreviewsIterable.this.client.listAccessPreviews((ListAccessPreviewsRequest)((Object)ListAccessPreviewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

