/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.licensemanager;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.licensemanager.CfnLicense;
import software.amazon.awscdk.services.licensemanager.CfnLicenseProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense")
public class CfnLicense
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLicense.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLicense(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLicense(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLicense(@NotNull Construct scope, @NotNull String id, @NotNull CfnLicenseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrLicenseArn() {
        return (String)Kernel.get((Object)this, (String)"attrLicenseArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrVersion() {
        return (String)Kernel.get((Object)this, (String)"attrVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getConsumptionConfiguration() {
        return Kernel.get((Object)this, (String)"consumptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConsumptionConfiguration(@NotNull ConsumptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"consumptionConfiguration", (Object)Objects.requireNonNull(value, "consumptionConfiguration is required"));
    }

    public void setConsumptionConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"consumptionConfiguration", (Object)Objects.requireNonNull(value, "consumptionConfiguration is required"));
    }

    @NotNull
    public Object getEntitlements() {
        return Kernel.get((Object)this, (String)"entitlements", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEntitlements(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"entitlements", (Object)Objects.requireNonNull(value, "entitlements is required"));
    }

    public void setEntitlements(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof EntitlementProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.licensemanager.CfnLicense.EntitlementProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"entitlements", Objects.requireNonNull(value, "entitlements is required"));
    }

    @NotNull
    public String getHomeRegion() {
        return (String)Kernel.get((Object)this, (String)"homeRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setHomeRegion(@NotNull String value) {
        Kernel.set((Object)this, (String)"homeRegion", (Object)Objects.requireNonNull(value, "homeRegion is required"));
    }

    @NotNull
    public Object getIssuer() {
        return Kernel.get((Object)this, (String)"issuer", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIssuer(@NotNull IssuerDataProperty value) {
        Kernel.set((Object)this, (String)"issuer", (Object)Objects.requireNonNull(value, "issuer is required"));
    }

    public void setIssuer(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"issuer", (Object)Objects.requireNonNull(value, "issuer is required"));
    }

    @NotNull
    public String getLicenseName() {
        return (String)Kernel.get((Object)this, (String)"licenseName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLicenseName(@NotNull String value) {
        Kernel.set((Object)this, (String)"licenseName", (Object)Objects.requireNonNull(value, "licenseName is required"));
    }

    @NotNull
    public String getProductName() {
        return (String)Kernel.get((Object)this, (String)"productName", (NativeType)NativeType.forClass(String.class));
    }

    public void setProductName(@NotNull String value) {
        Kernel.set((Object)this, (String)"productName", (Object)Objects.requireNonNull(value, "productName is required"));
    }

    @NotNull
    public Object getValidity() {
        return Kernel.get((Object)this, (String)"validity", (NativeType)NativeType.forClass(Object.class));
    }

    public void setValidity(@NotNull ValidityDateFormatProperty value) {
        Kernel.set((Object)this, (String)"validity", (Object)Objects.requireNonNull(value, "validity is required"));
    }

    public void setValidity(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"validity", (Object)Objects.requireNonNull(value, "validity is required"));
    }

    @Nullable
    public String getBeneficiary() {
        return (String)Kernel.get((Object)this, (String)"beneficiary", (NativeType)NativeType.forClass(String.class));
    }

    public void setBeneficiary(@Nullable String value) {
        Kernel.set((Object)this, (String)"beneficiary", (Object)value);
    }

    @Nullable
    public Object getLicenseMetadata() {
        return Kernel.get((Object)this, (String)"licenseMetadata", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLicenseMetadata(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"licenseMetadata", (Object)value);
    }

    public void setLicenseMetadata(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof MetadataProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.licensemanager.CfnLicense.MetadataProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"licenseMetadata", value);
    }

    @Nullable
    public String getProductSku() {
        return (String)Kernel.get((Object)this, (String)"productSku", (NativeType)NativeType.forClass(String.class));
    }

    public void setProductSku(@Nullable String value) {
        Kernel.set((Object)this, (String)"productSku", (Object)value);
    }

    @Nullable
    public String getStatus() {
        return (String)Kernel.get((Object)this, (String)"status", (NativeType)NativeType.forClass(String.class));
    }

    public void setStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"status", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLicense> {
        private final Construct scope;
        private final String id;
        private final CfnLicenseProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnLicenseProps.Builder();
        }

        public Builder consumptionConfiguration(ConsumptionConfigurationProperty consumptionConfiguration) {
            this.props.consumptionConfiguration(consumptionConfiguration);
            return this;
        }

        public Builder consumptionConfiguration(IResolvable consumptionConfiguration) {
            this.props.consumptionConfiguration(consumptionConfiguration);
            return this;
        }

        public Builder entitlements(IResolvable entitlements) {
            this.props.entitlements(entitlements);
            return this;
        }

        public Builder entitlements(List<? extends Object> entitlements) {
            this.props.entitlements(entitlements);
            return this;
        }

        public Builder homeRegion(String homeRegion) {
            this.props.homeRegion(homeRegion);
            return this;
        }

        public Builder issuer(IssuerDataProperty issuer) {
            this.props.issuer(issuer);
            return this;
        }

        public Builder issuer(IResolvable issuer) {
            this.props.issuer(issuer);
            return this;
        }

        public Builder licenseName(String licenseName) {
            this.props.licenseName(licenseName);
            return this;
        }

        public Builder productName(String productName) {
            this.props.productName(productName);
            return this;
        }

        public Builder validity(ValidityDateFormatProperty validity) {
            this.props.validity(validity);
            return this;
        }

        public Builder validity(IResolvable validity) {
            this.props.validity(validity);
            return this;
        }

        public Builder beneficiary(String beneficiary) {
            this.props.beneficiary(beneficiary);
            return this;
        }

        public Builder licenseMetadata(IResolvable licenseMetadata) {
            this.props.licenseMetadata(licenseMetadata);
            return this;
        }

        public Builder licenseMetadata(List<? extends Object> licenseMetadata) {
            this.props.licenseMetadata(licenseMetadata);
            return this;
        }

        public Builder productSku(String productSku) {
            this.props.productSku(productSku);
            return this;
        }

        public Builder status(String status) {
            this.props.status(status);
            return this;
        }

        public CfnLicense build() {
            return new CfnLicense(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.ValidityDateFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ValidityDateFormatProperty
    extends JsiiSerializable {
        @NotNull
        public String getBegin();

        @NotNull
        public String getEnd();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ValidityDateFormatProperty> {
            String begin;
            String end;

            public Builder begin(String begin) {
                this.begin = begin;
                return this;
            }

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public ValidityDateFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.ProvisionalConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionalConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxTimeToLiveInMinutes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionalConfigurationProperty> {
            Number maxTimeToLiveInMinutes;

            public Builder maxTimeToLiveInMinutes(Number maxTimeToLiveInMinutes) {
                this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
                return this;
            }

            public ProvisionalConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.MetadataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetadataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.IssuerDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IssuerDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getSignKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IssuerDataProperty> {
            String name;
            String signKey;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder signKey(String signKey) {
                this.signKey = signKey;
                return this;
            }

            public IssuerDataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.EntitlementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EntitlementProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getUnit();

        @Nullable
        default public Object getAllowCheckIn() {
            return null;
        }

        @Nullable
        default public Number getMaxCount() {
            return null;
        }

        @Nullable
        default public Object getOverage() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EntitlementProperty> {
            String name;
            String unit;
            Object allowCheckIn;
            Number maxCount;
            Object overage;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Builder allowCheckIn(Boolean allowCheckIn) {
                this.allowCheckIn = allowCheckIn;
                return this;
            }

            public Builder allowCheckIn(IResolvable allowCheckIn) {
                this.allowCheckIn = allowCheckIn;
                return this;
            }

            public Builder maxCount(Number maxCount) {
                this.maxCount = maxCount;
                return this;
            }

            public Builder overage(Boolean overage) {
                this.overage = overage;
                return this;
            }

            public Builder overage(IResolvable overage) {
                this.overage = overage;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EntitlementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.ConsumptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConsumptionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBorrowConfiguration() {
            return null;
        }

        @Nullable
        default public Object getProvisionalConfiguration() {
            return null;
        }

        @Nullable
        default public String getRenewType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConsumptionConfigurationProperty> {
            Object borrowConfiguration;
            Object provisionalConfiguration;
            String renewType;

            public Builder borrowConfiguration(BorrowConfigurationProperty borrowConfiguration) {
                this.borrowConfiguration = borrowConfiguration;
                return this;
            }

            public Builder borrowConfiguration(IResolvable borrowConfiguration) {
                this.borrowConfiguration = borrowConfiguration;
                return this;
            }

            public Builder provisionalConfiguration(ProvisionalConfigurationProperty provisionalConfiguration) {
                this.provisionalConfiguration = provisionalConfiguration;
                return this;
            }

            public Builder provisionalConfiguration(IResolvable provisionalConfiguration) {
                this.provisionalConfiguration = provisionalConfiguration;
                return this;
            }

            public Builder renewType(String renewType) {
                this.renewType = renewType;
                return this;
            }

            public ConsumptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_licensemanager.CfnLicense.BorrowConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BorrowConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAllowEarlyCheckIn();

        @NotNull
        public Number getMaxTimeToLiveInMinutes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BorrowConfigurationProperty> {
            Object allowEarlyCheckIn;
            Number maxTimeToLiveInMinutes;

            public Builder allowEarlyCheckIn(Boolean allowEarlyCheckIn) {
                this.allowEarlyCheckIn = allowEarlyCheckIn;
                return this;
            }

            public Builder allowEarlyCheckIn(IResolvable allowEarlyCheckIn) {
                this.allowEarlyCheckIn = allowEarlyCheckIn;
                return this;
            }

            public Builder maxTimeToLiveInMinutes(Number maxTimeToLiveInMinutes) {
                this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
                return this;
            }

            public BorrowConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

