/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appmesh;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appmesh.AccessLog;
import software.amazon.awscdk.services.appmesh.Backend;
import software.amazon.awscdk.services.appmesh.BackendDefaults;
import software.amazon.awscdk.services.appmesh.IMesh;
import software.amazon.awscdk.services.appmesh.IVirtualNode;
import software.amazon.awscdk.services.appmesh.ServiceDiscovery;
import software.amazon.awscdk.services.appmesh.VirtualNodeAttributes;
import software.amazon.awscdk.services.appmesh.VirtualNodeListener;
import software.amazon.awscdk.services.appmesh.VirtualNodeProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appmesh.VirtualNode")
public class VirtualNode
extends Resource
implements IVirtualNode {
    protected VirtualNode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VirtualNode(@NotNull Construct scope, @NotNull String id, @NotNull VirtualNodeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IVirtualNode fromVirtualNodeArn(@NotNull Construct scope, @NotNull String id, @NotNull String virtualNodeArn) {
        return (IVirtualNode)JsiiObject.jsiiStaticCall(VirtualNode.class, (String)"fromVirtualNodeArn", (NativeType)NativeType.forClass(IVirtualNode.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(virtualNodeArn, "virtualNodeArn is required")});
    }

    @NotNull
    public static IVirtualNode fromVirtualNodeAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VirtualNodeAttributes attrs) {
        return (IVirtualNode)JsiiObject.jsiiStaticCall(VirtualNode.class, (String)"fromVirtualNodeAttributes", (NativeType)NativeType.forClass(IVirtualNode.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addBackend(@NotNull Backend backend) {
        Kernel.call((Object)this, (String)"addBackend", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(backend, "backend is required")});
    }

    public void addListener(@NotNull VirtualNodeListener listener) {
        Kernel.call((Object)this, (String)"addListener", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(listener, "listener is required")});
    }

    @Override
    @NotNull
    public Grant grantStreamAggregatedResources(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantStreamAggregatedResources", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public IMesh getMesh() {
        return (IMesh)Kernel.get((Object)this, (String)"mesh", (NativeType)NativeType.forClass(IMesh.class));
    }

    @Override
    @NotNull
    public String getVirtualNodeArn() {
        return (String)Kernel.get((Object)this, (String)"virtualNodeArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVirtualNodeName() {
        return (String)Kernel.get((Object)this, (String)"virtualNodeName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VirtualNode> {
        private final Construct scope;
        private final String id;
        private final VirtualNodeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VirtualNodeProps.Builder();
        }

        public Builder accessLog(AccessLog accessLog) {
            this.props.accessLog(accessLog);
            return this;
        }

        public Builder backendDefaults(BackendDefaults backendDefaults) {
            this.props.backendDefaults(backendDefaults);
            return this;
        }

        public Builder backends(List<? extends Backend> backends) {
            this.props.backends(backends);
            return this;
        }

        public Builder listeners(List<? extends VirtualNodeListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        public Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.props.serviceDiscovery(serviceDiscovery);
            return this;
        }

        public Builder virtualNodeName(String virtualNodeName) {
            this.props.virtualNodeName(virtualNodeName);
            return this;
        }

        public Builder mesh(IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        public VirtualNode build() {
            return new VirtualNode(this.scope, this.id, this.props.build());
        }
    }
}

