/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.assertions;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.assertions.TemplateParsingOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.assertions.Template")
public class Template
extends JsiiObject {
    protected Template(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Template(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    @NotNull
    public static Template fromJSON(@NotNull Map<String, ? extends Object> template, @Nullable TemplateParsingOptions templateParsingOptions) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromJSON", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(template, "template is required"), templateParsingOptions}));
    }

    @NotNull
    public static Template fromJSON(@NotNull Map<String, ? extends Object> template) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromJSON", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(template, "template is required")}));
    }

    @NotNull
    public static Template fromStack(@NotNull Stack stack, @Nullable TemplateParsingOptions templateParsingOptions) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromStack", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required"), templateParsingOptions}));
    }

    @NotNull
    public static Template fromStack(@NotNull Stack stack) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromStack", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required")}));
    }

    @NotNull
    public static Template fromString(@NotNull String template, @Nullable TemplateParsingOptions templateParsingOptions) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromString", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(template, "template is required"), templateParsingOptions}));
    }

    @NotNull
    public static Template fromString(@NotNull String template) {
        return (Template)((Object)JsiiObject.jsiiStaticCall(Template.class, (String)"fromString", (NativeType)NativeType.forClass(Template.class), (Object[])new Object[]{Objects.requireNonNull(template, "template is required")}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findConditions(@NotNull String logicalId, @Nullable Object props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findConditions", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findConditions(@NotNull String logicalId) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findConditions", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required")}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findMappings(@NotNull String logicalId, @Nullable Object props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findMappings", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findMappings(@NotNull String logicalId) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findMappings", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required")}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findOutputs(@NotNull String logicalId, @Nullable Object props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findOutputs", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findOutputs(@NotNull String logicalId) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findOutputs", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required")}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findParameters(@NotNull String logicalId, @Nullable Object props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findParameters", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findParameters(@NotNull String logicalId) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findParameters", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required")}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findResources(@NotNull String type, @Nullable Object props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findResources", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(type, "type is required"), props}));
    }

    @NotNull
    public Map<String, Map<String, Object>> findResources(@NotNull String type) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"findResources", (NativeType)NativeType.mapOf((NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{Objects.requireNonNull(type, "type is required")}));
    }

    public void hasCondition(@NotNull String logicalId, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasCondition", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props});
    }

    public void hasMapping(@NotNull String logicalId, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasMapping", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props});
    }

    public void hasOutput(@NotNull String logicalId, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasOutput", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props});
    }

    public void hasParameter(@NotNull String logicalId, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasParameter", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(logicalId, "logicalId is required"), props});
    }

    public void hasResource(@NotNull String type, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasResource", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(type, "type is required"), props});
    }

    public void hasResourceProperties(@NotNull String type, @NotNull Object props) {
        Kernel.call((Object)((Object)this), (String)"hasResourceProperties", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(type, "type is required"), props});
    }

    public void resourceCountIs(@NotNull String type, @NotNull Number count) {
        Kernel.call((Object)((Object)this), (String)"resourceCountIs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(type, "type is required"), Objects.requireNonNull(count, "count is required")});
    }

    public void resourcePropertiesCountIs(@NotNull String type, @NotNull Object props, @NotNull Number count) {
        Kernel.call((Object)((Object)this), (String)"resourcePropertiesCountIs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(type, "type is required"), props, Objects.requireNonNull(count, "count is required")});
    }

    public void templateMatches(@NotNull Object expected) {
        Kernel.call((Object)((Object)this), (String)"templateMatches", (NativeType)NativeType.VOID, (Object[])new Object[]{expected});
    }

    @NotNull
    public Map<String, Object> toJSON() {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"toJSON", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[0]));
    }
}

