/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import se.vandmo.dependencylock.maven.DependenciesLockFileJson;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.mojos.AbstractDependencyLockMojo;

@Mojo(name="lock", requiresDependencyResolution=ResolutionScope.TEST)
public final class LockMojo
extends AbstractDependencyLockMojo {
    public void execute() throws MojoFailureException {
        this.getLog().warn((CharSequence)"The 'lock' goal is deprecated, use 'create-lock-file' instead.");
        switch (this.format()) {
            case json: {
                DependenciesLockFileJson lockFileJson = DependenciesLockFileJson.from(this.lockFile(), this.getLog());
                LockedDependencies existingLockedDependencies = this.getExistingLockedDependencies(lockFileJson);
                LockedDependencies lockedDependencies = existingLockedDependencies.updateWith(this.projectDependencies());
                lockFileJson.write(lockedDependencies);
                break;
            }
            default: {
                throw new MojoFailureException("Only supported for json lock files, use create-lock-file instead");
            }
        }
    }

    private LockedDependencies getExistingLockedDependencies(DependenciesLockFileJson lockFile) {
        if (lockFile.exists()) {
            return lockFile.read();
        }
        return LockedDependencies.empty(this.getLog());
    }
}

