/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.util.Locale;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.DependenciesLockFileJson;
import se.vandmo.dependencylock.maven.DependenciesLockFilePom;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.mojos.AbstractDependencyLockMojo;

@Mojo(name="create-lock-file", requiresDependencyResolution=ResolutionScope.TEST)
public final class CreateLockFileMojo
extends AbstractDependencyLockMojo {
    public void execute() {
        DependenciesLockFileAccessor lockFile = this.lockFile();
        this.getLog().info((CharSequence)String.format(Locale.ROOT, "Creating %s", lockFile.filename()));
        switch (this.format()) {
            case json: {
                DependenciesLockFileJson lockFileJson = DependenciesLockFileJson.from(lockFile, this.getLog());
                LockedDependencies lockedDependencies = LockedDependencies.from(this.projectDependencies(), this.getLog());
                lockFileJson.write(lockedDependencies);
                break;
            }
            case pom: {
                DependenciesLockFilePom lockFilePom = DependenciesLockFilePom.from(lockFile, this.pomMinimums(), this.getLog());
                lockFilePom.write(this.projectDependencies());
                break;
            }
            default: {
                throw new RuntimeException("This should not happen!");
            }
        }
    }
}

