/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.util.Arrays;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.mojos.AbstractDependencyLockMojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public final class CheckMojo
extends AbstractDependencyLockMojo {
    @Parameter
    private String[] useMyVersionFor = new String[0];

    public void execute() throws MojoExecutionException {
        DependenciesLockFileAccessor lockFile = this.lockFile();
        if (!lockFile.exists()) {
            throw new MojoExecutionException("No lock file found, create one by running 'mvn se.vandmo:dependency-lock-maven-plugin:create-lock-file'");
        }
        StrictPatternIncludesArtifactFilter useMyVersionForFilter = new StrictPatternIncludesArtifactFilter(Arrays.asList(this.useMyVersionFor));
        LockedDependencies lockedDependencies = this.format().dependenciesLockFile_from(lockFile, this.pomMinimums(), this.getLog()).read();
        LockedDependencies.Diff diff = lockedDependencies.compareWith(this.projectDependencies(), this.projectVersion(), (ArtifactFilter)useMyVersionForFilter);
        if (!diff.equals()) {
            diff.logTo(this.getLog());
            throw new MojoExecutionException("Dependencies differ");
        }
        this.getLog().info((CharSequence)"Actual dependencies matches locked dependencies");
    }
}

