/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.LockFileFormat;
import se.vandmo.dependencylock.maven.PomMinimums;

public abstract class AbstractDependencyLockMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="dependencyLock.filename")
    private String filename;
    @Parameter(property="dependencyLock.format")
    private LockFileFormat format = LockFileFormat.json;

    DependenciesLockFileAccessor lockFile() {
        return this.format.dependenciesLockFileAccessor_fromBasedirAndFilename(this.basedir, this.filename);
    }

    Artifacts projectDependencies() {
        return Artifacts.from(this.project.getArtifacts());
    }

    PomMinimums pomMinimums() {
        return PomMinimums.from(this.project);
    }

    String projectVersion() {
        return this.project.getVersion();
    }

    LockFileFormat format() {
        return this.format;
    }
}

