/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class LockedVersion
implements Comparable<LockedVersion> {
    public static final LockedVersion USE_MINE = new LockedVersion(Optional.empty(), true);
    public final Optional<String> version;
    public final boolean useMine;

    private LockedVersion(Optional<String> version, boolean useMine) {
        this.version = Objects.requireNonNull(version);
        this.useMine = useMine;
    }

    public static LockedVersion fromJson(JsonNode json) {
        if (json.isTextual()) {
            if (StringUtils.isBlank((CharSequence)json.textValue())) {
                throw new IllegalArgumentException("version may not be blank");
            }
            return new LockedVersion(Optional.of(json.textValue()), false);
        }
        if (json.isObject()) {
            JsonNode value = json.get("use-mine");
            if (value == null || !value.isBoolean()) {
                throw new IllegalArgumentException("Illegal version " + json);
            }
            if (value.booleanValue()) {
                return new LockedVersion(Optional.empty(), true);
            }
            throw new IllegalArgumentException("Illegal version. 'use-mine' needs to be true");
        }
        throw new IllegalArgumentException("Invalid value for version " + json);
    }

    public static LockedVersion fromVersion(String version) {
        return new LockedVersion(Optional.of(Objects.requireNonNull(version)), false);
    }

    public JsonNode asJson() {
        if (this.useMine) {
            ObjectNode json = JsonNodeFactory.instance.objectNode();
            json.put("use-mine", true);
            return json;
        }
        return JsonNodeFactory.instance.textNode(this.version.get());
    }

    @Override
    public int compareTo(LockedVersion other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LockedVersion{");
        this.version.ifPresent(presentVersion -> sb.append("version=").append((String)presentVersion));
        if (this.useMine) {
            sb.append("useMine");
        }
        sb.append('}');
        return sb.toString();
    }

    public String resolveWithProjectVersion(String projectVersion) {
        if (this.useMine) {
            return projectVersion;
        }
        return this.version.get();
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.version);
        hash = 83 * hash + (this.useMine ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockedVersion other = (LockedVersion)obj;
        if (this.useMine != other.useMine) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public boolean matches(String version, String projectVersion) {
        String resolvedVersion = this.useMine ? projectVersion : this.version.get();
        return resolvedVersion.equals(version);
    }
}

