/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.JsonUtils;
import se.vandmo.dependencylock.maven.LockedVersion;

public final class LockedDependency
implements Comparable<LockedDependency> {
    public final ArtifactIdentifier identifier;
    public final LockedVersion version;
    public final String scope;
    public final String type;

    private LockedDependency(ArtifactIdentifier identifier, LockedVersion version, String scope, String type) {
        this.identifier = Objects.requireNonNull(identifier);
        this.version = Objects.requireNonNull(version);
        this.scope = Objects.requireNonNull(scope);
        this.type = Objects.requireNonNull(type);
    }

    public static LockedDependency fromJson(JsonNode json) {
        return new LockedDependency(new ArtifactIdentifier(JsonUtils.getStringValue(json, "groupId"), JsonUtils.getStringValue(json, "artifactId"), JsonUtils.possiblyGetStringValue(json, "classifier"), JsonUtils.possiblyGetStringValue(json, "type")), LockedVersion.fromJson(json.get("version")), JsonUtils.getStringValue(json, "scope"), JsonUtils.getStringValue(json, "type"));
    }

    public static LockedDependency from(Artifact artifact) {
        return new LockedDependency(artifact.identifier, LockedVersion.fromVersion(artifact.version), artifact.scope, artifact.type);
    }

    public JsonNode asJson() {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("groupId", this.identifier.groupId);
        json.put("artifactId", this.identifier.artifactId);
        json.set("version", this.version.asJson());
        json.put("scope", this.scope);
        json.put("type", this.type);
        this.identifier.classifier.ifPresent(actualClassifier -> json.put("classifier", actualClassifier));
        return json;
    }

    public LockedDependency withVersion(LockedVersion version) {
        return new LockedDependency(this.identifier, version, this.scope, this.type);
    }

    public boolean matches(Artifact artifact, String projectVersion) {
        return this.identifier.equals(artifact.identifier) && this.version.matches(artifact.version, projectVersion) && this.scope.equals(artifact.scope) && this.type.equals(artifact.type);
    }

    @Override
    public int compareTo(LockedDependency other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return this.identifier + ':' + this.version + ':' + this.scope + ':' + this.type;
    }

    public String toResolvedString(String projectVersion) {
        return this.identifier + ':' + this.version.resolveWithProjectVersion(projectVersion) + ':' + this.scope + ':' + this.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.identifier);
        hash = 17 * hash + Objects.hashCode(this.version);
        hash = 17 * hash + Objects.hashCode(this.scope);
        hash = 17 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockedDependency other = (LockedDependency)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }
}

