/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.LockedDependency;
import se.vandmo.dependencylock.maven.LockedVersion;

public final class LockedDependencies {
    public final List<LockedDependency> lockedDependencies;
    private final Log log;

    private LockedDependencies(List<LockedDependency> lockedDependencies, Log log) {
        this.lockedDependencies = lockedDependencies;
        this.log = log;
    }

    public static LockedDependencies fromJson(JsonNode json, Log log) {
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        ArrayList<LockedDependency> lockedDependencies = new ArrayList<LockedDependency>();
        for (JsonNode entry : json) {
            lockedDependencies.add(LockedDependency.fromJson(entry));
        }
        return new LockedDependencies(Collections.unmodifiableList(lockedDependencies), log);
    }

    public static LockedDependencies empty(Log log) {
        return new LockedDependencies(Collections.emptyList(), log);
    }

    public static LockedDependencies from(Artifacts artifacts, Log log) {
        ArrayList<LockedDependency> lockedDependencies = new ArrayList<LockedDependency>();
        for (Artifact artifact : artifacts.artifacts) {
            lockedDependencies.add(LockedDependency.from(artifact));
        }
        return new LockedDependencies(Collections.unmodifiableList(lockedDependencies), log);
    }

    public JsonNode asJson() {
        ArrayNode json = JsonNodeFactory.instance.arrayNode();
        for (LockedDependency lockedDependency : this.lockedDependencies) {
            json.add(lockedDependency.asJson());
        }
        return json;
    }

    public LockedDependencies updateWith(Artifacts artifacts) {
        ArrayList<LockedDependency> updatedLockedDependencies = new ArrayList<LockedDependency>();
        for (Artifact artifact : artifacts.artifacts) {
            updatedLockedDependencies.add(this.maybeChangeTo_UseMine(artifact));
        }
        return new LockedDependencies(Collections.unmodifiableList(updatedLockedDependencies), this.log);
    }

    private LockedDependency maybeChangeTo_UseMine(Artifact artifact) {
        LockedDependency lockedDependency = LockedDependency.from(artifact);
        Optional<LockedVersion> possiblyExistingVersion = this.getExistingVersion(artifact.identifier);
        if (possiblyExistingVersion.isPresent() && possiblyExistingVersion.get().useMine) {
            return lockedDependency.withVersion(LockedVersion.USE_MINE);
        }
        return lockedDependency;
    }

    private Optional<LockedVersion> getExistingVersion(ArtifactIdentifier identifier) {
        return this.by(identifier).map(lockedDependency -> lockedDependency.version);
    }

    public Diff compareWith(Artifacts artifacts, String projectVersion, ArtifactFilter useMyVersionForFilter) {
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> different = new ArrayList<String>();
        ArrayList<String> added = new ArrayList<String>();
        for (LockedDependency lockedDependency : this.lockedDependencies) {
            Optional<Artifact> possiblyOtherArtifact = artifacts.by(lockedDependency.identifier);
            if (!possiblyOtherArtifact.isPresent()) {
                missing.add(lockedDependency.toResolvedString(projectVersion));
                continue;
            }
            Artifact otherArtifact = possiblyOtherArtifact.get();
            LockedDependency possiblyChangedLockedDependency = this.maybeChangeTo_UseMine(useMyVersionForFilter, lockedDependency, otherArtifact);
            if (possiblyChangedLockedDependency.matches(otherArtifact, projectVersion)) continue;
            different.add(String.format(Locale.ROOT, "Expected %s but found %s", possiblyChangedLockedDependency.toResolvedString(projectVersion), otherArtifact));
        }
        for (Artifact otherArtifact : artifacts.artifacts) {
            if (this.by(otherArtifact.identifier).isPresent()) continue;
            added.add(otherArtifact.toString());
        }
        return new Diff(missing, different, added);
    }

    private LockedDependency maybeChangeTo_UseMine(ArtifactFilter useMyVersionForFilter, LockedDependency lockedDependency, Artifact otherArtifact) {
        if (useMyVersionForFilter.include(otherArtifact.toMavenArtifact())) {
            this.log.info((CharSequence)String.format(Locale.ROOT, "Using my version for %s", otherArtifact));
            return lockedDependency.withVersion(LockedVersion.USE_MINE);
        }
        return lockedDependency;
    }

    public Optional<LockedDependency> by(ArtifactIdentifier identifier) {
        for (LockedDependency lockedDependency : this.lockedDependencies) {
            if (!lockedDependency.identifier.equals(identifier)) continue;
            return Optional.of(lockedDependency);
        }
        return Optional.empty();
    }

    public static final class Diff {
        private final List<String> missing;
        private final List<String> different;
        private final List<String> added;

        private Diff(List<String> missing, List<String> different, List<String> added) {
            this.missing = missing;
            this.different = different;
            this.added = added;
        }

        public boolean equals() {
            return this.missing.isEmpty() && this.different.isEmpty() && this.added.isEmpty();
        }

        public void logTo(Log log) {
            if (!this.missing.isEmpty()) {
                log.error((CharSequence)"Missing dependencies:");
                this.missing.forEach(line -> log.error((CharSequence)("  " + line)));
            }
            if (!this.different.isEmpty()) {
                log.error((CharSequence)"The following dependencies differ:");
                this.different.forEach(line -> log.error((CharSequence)("  " + line)));
            }
            if (!this.added.isEmpty()) {
                log.error((CharSequence)"Extraneous dependencies:");
                this.added.forEach(line -> log.error((CharSequence)("  " + line)));
            }
        }
    }
}

