/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.DependenciesLockFileJson;
import se.vandmo.dependencylock.maven.DependenciesLockFilePom;
import se.vandmo.dependencylock.maven.PomMinimums;

public enum LockFileFormat {
    json{

        @Override
        public String defaultFilename() {
            return "dependencies-lock.json";
        }

        @Override
        public DependenciesLockFile dependenciesLockFile_from(DependenciesLockFileAccessor dependenciesLockFileAccessor, PomMinimums pomMinimums, Log log) {
            return DependenciesLockFileJson.from(dependenciesLockFileAccessor, log);
        }
    }
    ,
    pom{

        @Override
        public String defaultFilename() {
            return ".dependency-lock/pom.xml";
        }

        @Override
        public DependenciesLockFile dependenciesLockFile_from(DependenciesLockFileAccessor dependenciesLockFileAccessor, PomMinimums pomMinimums, Log log) {
            return DependenciesLockFilePom.from(dependenciesLockFileAccessor, pomMinimums, log);
        }
    };


    abstract String defaultFilename();

    private String getLockFilename(String filename) {
        if (filename != null) {
            return filename;
        }
        return this.defaultFilename();
    }

    public DependenciesLockFileAccessor dependenciesLockFileAccessor_fromBasedirAndFilename(File basedir, String filename) {
        return DependenciesLockFileAccessor.fromBasedir(basedir, this.getLockFilename(filename));
    }

    public abstract DependenciesLockFile dependenciesLockFile_from(DependenciesLockFileAccessor var1, PomMinimums var2, Log var3);
}

