/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.PomMinimums;

public final class DependenciesLockFilePom
implements DependenciesLockFile {
    private static final Version VERSION = Configuration.VERSION_2_3_31;
    private final DependenciesLockFileAccessor dependenciesLockFile;
    private final PomMinimums pomMinimums;
    private final Log log;

    private DependenciesLockFilePom(DependenciesLockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.pomMinimums = pomMinimums;
        this.log = log;
    }

    public static DependenciesLockFilePom from(DependenciesLockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        return new DependenciesLockFilePom(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(pomMinimums), Objects.requireNonNull(log));
    }

    @Override
    public void write(Artifacts projectDependencies) {
        Configuration cfg = DependenciesLockFilePom.createConfiguration();
        try {
            Template template = cfg.getTemplate("pom.ftlx");
            try (Writer writer = this.dependenciesLockFile.writer();){
                template.process(DependenciesLockFilePom.makeDataModel(this.pomMinimums, projectDependencies), writer);
            }
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> makeDataModel(PomMinimums pomMinimums, Artifacts artifacts) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("pom", pomMinimums);
        dataModel.put("dependencies", artifacts);
        return dataModel;
    }

    private static Configuration createConfiguration() {
        Configuration cfg = new Configuration(VERSION);
        cfg.setClassForTemplateLoading(DependenciesLockFilePom.class, "");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setObjectWrapper(DependenciesLockFilePom.getObjectWrapper());
        return cfg;
    }

    private static ObjectWrapper getObjectWrapper() {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(VERSION);
        builder.setExposeFields(true);
        builder.setIterableSupport(true);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LockedDependencies read() {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        try (Reader reader = this.dependenciesLockFile.reader();){
            Model pom = pomReader.read(reader);
            Artifacts artifacts = Artifacts.from(pom.getDependencies());
            LockedDependencies lockedDependencies = LockedDependencies.from(artifacts, this.log);
            return lockedDependencies;
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }
}

