/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.DependenciesLockFileAccessor;
import se.vandmo.dependencylock.maven.JsonUtils;
import se.vandmo.dependencylock.maven.LockedDependencies;

public final class DependenciesLockFileJson
implements DependenciesLockFile {
    private final DependenciesLockFileAccessor dependenciesLockFile;
    private final Log log;

    private DependenciesLockFileJson(DependenciesLockFileAccessor dependenciesLockFile, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.log = log;
    }

    public static DependenciesLockFileJson from(DependenciesLockFileAccessor dependenciesLockFile, Log log) {
        return new DependenciesLockFileJson(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(log));
    }

    @Override
    public LockedDependencies read() {
        JsonNode json = this.readJsonNode();
        if (!json.isObject()) {
            throw new IllegalStateException("Expected top level type to be an object");
        }
        JsonNode dependencies = json.get("dependencies");
        if (dependencies == null || !dependencies.isArray()) {
            throw new IllegalStateException("Expected a property named 'dependencies' of type array");
        }
        return LockedDependencies.fromJson(dependencies, this.log);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode readJsonNode() {
        try (Reader reader = this.dependenciesLockFile.reader();){
            JsonNode jsonNode = JsonUtils.readJson(reader);
            return jsonNode;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(Artifacts projectDependencies) {
        this.write(LockedDependencies.from(projectDependencies, this.log));
    }

    public void write(LockedDependencies lockedDependencies) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.set("dependencies", lockedDependencies.asJson());
        try (Writer writer = this.dependenciesLockFile.writer();){
            JsonUtils.writeJson(writer, (JsonNode)json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean exists() {
        return this.dependenciesLockFile.exists();
    }
}

