/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;

public final class Artifacts
implements Iterable<Artifact> {
    public final List<Artifact> artifacts;

    Artifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> copy = new ArrayList<Artifact>(artifacts);
        Collections.sort(copy);
        this.artifacts = Collections.unmodifiableList(copy);
    }

    public static Artifacts from(Set<org.apache.maven.artifact.Artifact> artifacts) {
        return new Artifacts(artifacts.stream().map(Artifact::from).collect(Collectors.toList()));
    }

    public static Artifacts from(Collection<Dependency> dependencies) {
        return new Artifacts(dependencies.stream().map(Artifact::from).collect(Collectors.toList()));
    }

    public Optional<Artifact> by(ArtifactIdentifier identifier) {
        for (Artifact artifact : this.artifacts) {
            if (!identifier.equals(artifact.identifier)) continue;
            return Optional.of(artifact);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Artifact> iterator() {
        return this.artifacts.iterator();
    }
}

