/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;

public final class ArtifactIdentifier
implements Comparable<ArtifactIdentifier> {
    public final String groupId;
    public final String artifactId;
    public final Optional<String> classifier;
    public final Optional<String> type;

    public static ArtifactIdentifier from(Artifact artifact) {
        return new ArtifactIdentifier(artifact.getGroupId(), artifact.getArtifactId(), Optional.ofNullable(artifact.getClassifier()), Optional.ofNullable(artifact.getType()));
    }

    ArtifactIdentifier(String groupId, String artifactId, Optional<String> classifier, Optional<String> type) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.classifier = Objects.requireNonNull(classifier);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public int compareTo(ArtifactIdentifier other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':').append(this.artifactId);
        this.classifier.ifPresent(actualClassifier -> sb.append(':').append((String)actualClassifier));
        this.type.ifPresent(actualType -> sb.append(':').append((String)actualType));
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.groupId);
        hash = 17 * hash + Objects.hashCode(this.artifactId);
        hash = 17 * hash + Objects.hashCode(this.classifier);
        hash = 17 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIdentifier other = (ArtifactIdentifier)obj;
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }
}

