/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator.aop;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ru.vyarus.guice.validator.group.ValidationContext;

@Singleton
public class ValidationMethodInterceptor
implements MethodInterceptor {
    @Inject
    private ExecutableValidator validator;
    @Inject
    private ValidationContext context;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class[] groups = this.context.getContextGroups();
        Set violations = this.validator.validateParameters(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(invocation.getMethod(), invocation.getArguments(), violations), violations);
        }
        Object result = invocation.proceed();
        violations = this.validator.validateReturnValue(invocation.getThis(), invocation.getMethod(), result, groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(invocation.getMethod(), invocation.getArguments(), violations), violations);
        }
        return result;
    }

    private String getMessage(Member member, Object[] args, Set<? extends ConstraintViolation<?>> violations) {
        StringBuilder message = new StringBuilder(200).append(violations.size()).append(" constraint violation(s) occurred during method validation.").append("\nConstructor or Method: ").append(member).append("\nArgument values: ").append(Arrays.toString(args)).append("\nConstraint violations: ");
        int i = 1;
        for (ConstraintViolation<?> constraintViolation : violations) {
            Path.Node leafNode = this.getLeafNode(constraintViolation);
            message.append("\n (").append(i++).append(") Kind: ").append(leafNode.getKind());
            if (leafNode.getKind() == ElementKind.PARAMETER) {
                message.append("\n parameter index: ").append(((Path.ParameterNode)leafNode.as(Path.ParameterNode.class)).getParameterIndex());
            }
            message.append("\n message: ").append(constraintViolation.getMessage()).append("\n root bean: ").append(constraintViolation.getRootBean()).append("\n property path: ").append(constraintViolation.getPropertyPath()).append("\n constraint: ").append(constraintViolation.getConstraintDescriptor().getAnnotation());
        }
        return message.toString();
    }

    private Path.Node getLeafNode(ConstraintViolation<?> constraintViolation) {
        Iterator nodes = constraintViolation.getPropertyPath().iterator();
        Path.Node leafNode = null;
        while (nodes.hasNext()) {
            leafNode = (Path.Node)nodes.next();
        }
        return leafNode;
    }
}

