/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.guice.validator.aop.ValidationMethodInterceptor;
import ru.vyarus.guice.validator.constraint.GuiceConstraintValidatorFactory;
import ru.vyarus.guice.validator.group.aop.ValidationGroupInterceptor;
import ru.vyarus.guice.validator.group.aop.ValidationGroupMatcher;

public abstract class AbstractValidationModule
extends AbstractModule {
    private ValidatorFactory factory;
    private boolean addDefaultGroup = true;

    public AbstractValidationModule() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public AbstractValidationModule(ValidatorFactory factory) {
        this.factory = factory;
    }

    public <T extends AbstractValidationModule> T alwaysAddDefaultGroup(boolean addDefaultGroup) {
        this.addDefaultGroup = addDefaultGroup;
        return (T)((Object)this);
    }

    protected void configure() {
        GuiceConstraintValidatorFactory constraintValidatorFactory = new GuiceConstraintValidatorFactory();
        this.requestInjection(constraintValidatorFactory);
        Validator validator = this.factory.usingContext().constraintValidatorFactory((ConstraintValidatorFactory)constraintValidatorFactory).getValidator();
        this.bind(Validator.class).toInstance((Object)validator);
        this.bind(ExecutableValidator.class).toInstance((Object)validator.forExecutables());
        this.bind(ValidatorFactory.class).toInstance((Object)this.factory);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"guice.validator.addDefaultGroup")).to(this.addDefaultGroup);
        ValidationGroupInterceptor groupInterceptor = new ValidationGroupInterceptor();
        this.requestInjection(groupInterceptor);
        this.configureGroupsAop(groupInterceptor);
        ValidationMethodInterceptor interceptor = new ValidationMethodInterceptor();
        this.requestInjection(interceptor);
        this.configureAop(interceptor);
    }

    protected void configureGroupsAop(ValidationGroupInterceptor interceptor) {
        this.bindInterceptor(Matchers.any(), (Matcher)new ValidationGroupMatcher(), new MethodInterceptor[]{interceptor});
    }

    protected abstract void configureAop(ValidationMethodInterceptor var1);
}

