/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.sparklens.scheduler;

import com.qubole.sparklens.common.AppContext;
import com.qubole.sparklens.scheduler.CompletionEstimator$;
import com.qubole.sparklens.scheduler.CompletionEstimator$$anon$1$;
import com.qubole.sparklens.scheduler.EstimatorState;
import com.qubole.sparklens.scheduler.PQParallelStageScheduler;
import com.qubole.sparklens.timespan.JobTimeSpan;
import com.qubole.sparklens.timespan.StageTimeSpan;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.TreeSet;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class CompletionEstimator$ {
    public static final CompletionEstimator$ MODULE$;

    static {
        new CompletionEstimator$();
    }

    public void com$qubole$sparklens$scheduler$CompletionEstimator$$scheduleStage(int stageID, EstimatorState estate, PQParallelStageScheduler scheduler) {
        Tuple2 stageData = (Tuple2)estate.stagesData().getOrElse((Object)BoxesRunTime.boxToInteger((int)stageID), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<int[], List<Object>> apply() {
                return new Tuple2((Object)Array$.MODULE$.emptyIntArray(), (Object)List$.MODULE$.empty());
            }
        });
        if (((int[])stageData._1()).length > 0) {
            if (((SeqLike)stageData._2()).isEmpty()) {
                estate.runnableStages().$plus$eq((Object)BoxesRunTime.boxToInteger((int)stageID));
            } else {
                int nonSkippedParents = ((SeqLike)((TraversableLike)stageData._2()).filter((Function1)new Serializable(estate){
                    public static final long serialVersionUID = 0L;
                    private final EstimatorState estate$1;

                    public final boolean apply(int parentStage) {
                        return this.apply$mcZI$sp(parentStage);
                    }

                    public boolean apply$mcZI$sp(int parentStage) {
                        return this.estate$1.stagesData().get((Object)BoxesRunTime.boxToInteger((int)parentStage)).isDefined();
                    }
                    {
                        this.estate$1 = estate$1;
                    }
                })).size();
                if (nonSkippedParents > 0) {
                    estate.waitingStages().$plus$eq((Object)BoxesRunTime.boxToInteger((int)stageID));
                    ((IterableLike)stageData._2()).foreach((Function1)new Serializable(estate, scheduler){
                        public static final long serialVersionUID = 0L;
                        private final EstimatorState estate$1;
                        private final PQParallelStageScheduler scheduler$1;

                        public final void apply(int parentStage) {
                            this.apply$mcVI$sp(parentStage);
                        }

                        public void apply$mcVI$sp(int parentStage) {
                            CompletionEstimator$.MODULE$.com$qubole$sparklens$scheduler$CompletionEstimator$$scheduleStage(parentStage, this.estate$1, this.scheduler$1);
                        }
                        {
                            this.estate$1 = estate$1;
                            this.scheduler$1 = scheduler$1;
                        }
                    });
                } else {
                    estate.runnableStages().$plus$eq((Object)BoxesRunTime.boxToInteger((int)stageID));
                }
            }
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped stage ", " with 0 tasks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageID)})));
        }
    }

    private long processStages(int maxStageID, EstimatorState estate, PQParallelStageScheduler scheduler) {
        long l;
        int MAX_COMPLETION_TRIES = estate.stagesData().size() + 1;
        int completionRetries = 0;
        while (!scheduler.isStageComplete(maxStageID) && completionRetries < MAX_COMPLETION_TRIES) {
            if (estate.runnableStages().nonEmpty()) {
                TreeSet copyOfRunningStages = estate.runnableStages().clone();
                TreeSet eligibleStages = (TreeSet)copyOfRunningStages.filterNot((Function1)new Serializable(estate){
                    public static final long serialVersionUID = 0L;
                    private final EstimatorState estate$2;

                    public final boolean apply(int stageID) {
                        return this.apply$mcZI$sp(stageID);
                    }

                    public boolean apply$mcZI$sp(int stageID) {
                        return this.estate$2.runningStages().contains((Object)BoxesRunTime.boxToInteger((int)stageID));
                    }
                    {
                        this.estate$2 = estate$2;
                    }
                });
                if (eligibleStages.size() <= 0) continue;
                int currentStageID = BoxesRunTime.unboxToInt((Object)eligibleStages.toList().apply(0));
                estate.runningStages().$plus$eq((Object)BoxesRunTime.boxToInteger((int)currentStageID));
                estate.runnableStages().$minus$eq((Object)BoxesRunTime.boxToInteger((int)currentStageID));
                Predef$.MODULE$.intArrayOps((int[])((Tuple2)estate.stagesData().getOrElse((Object)BoxesRunTime.boxToInteger((int)currentStageID), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<int[], List<Object>> apply() {
                        return new Tuple2((Object)Array$.MODULE$.emptyIntArray(), (Object)List$.MODULE$.empty());
                    }
                }))._1()).foreach((Function1)new Serializable(scheduler, currentStageID){
                    public static final long serialVersionUID = 0L;
                    private final PQParallelStageScheduler scheduler$2;
                    private final int currentStageID$1;

                    public final void apply(int taskTime) {
                        this.apply$mcVI$sp(taskTime);
                    }

                    public void apply$mcVI$sp(int taskTime) {
                        if (taskTime <= 0) {
                            this.scheduler$2.schedule(1, this.currentStageID$1);
                        } else {
                            this.scheduler$2.schedule(taskTime, this.currentStageID$1);
                        }
                    }
                    {
                        this.scheduler$2 = scheduler$2;
                        this.currentStageID$1 = currentStageID$1;
                    }
                });
                continue;
            }
            scheduler.runTillStageCompletion();
            ++completionRetries;
        }
        if (completionRetries >= MAX_COMPLETION_TRIES) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Estimation of job completion time aborted ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)completionRetries)})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"runnableStages ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estate.runnableStages()})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"runningStages ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estate.runningStages()})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"waitingStages ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estate.waitingStages()})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxStageID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxStageID)})));
            l = 0L;
        } else {
            l = scheduler.wallClockTime();
        }
        return l;
    }

    public long estimateJobWallClockTime(JobTimeSpan jobTimeSpan, int executorCount, int perExecutorCores) {
        if (jobTimeSpan.stageMap().isEmpty()) {
            return BoxesRunTime.unboxToLong((Object)jobTimeSpan.duration().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
        }
        int maxStageID = BoxesRunTime.unboxToInt((Object)((TraversableOnce)jobTimeSpan.stageMap().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, StageTimeSpan> x) {
                return x._1$mcI$sp();
            }
        }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Map data = ((TraversableOnce)jobTimeSpan.stageMap().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<int[], Seq<Object>>> apply(Tuple2<Object, StageTimeSpan> x) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)new Tuple2((Object)((StageTimeSpan)x._2()).taskExecutionTimes(), ((StageTimeSpan)x._2()).parentStageIDs()));
            }
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap taskCountMap = new HashMap();
        data.foreach((Function1)new Serializable(taskCountMap){
            public static final long serialVersionUID = 0L;
            private final HashMap taskCountMap$1;

            public final void apply(Tuple2<Object, Tuple2<int[], Seq<Object>>> x) {
                this.taskCountMap$1.update((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)((int[])((Tuple2)x._2())._1()).length));
            }
            {
                this.taskCountMap$1 = taskCountMap$1;
            }
        });
        EstimatorState estate = new EstimatorState((Map<Object, Tuple2<int[], Seq<Object>>>)data);
        PQParallelStageScheduler scheduler = new PQParallelStageScheduler(executorCount, perExecutorCores, taskCountMap, estate){
            public final EstimatorState estate$3;

            public void onStageFinished(int stageID) {
                this.estate$3.runningStages().$minus$eq((Object)BoxesRunTime.boxToInteger((int)stageID));
                TreeSet nowRunnableStages = (TreeSet)this.estate$3.waitingStages().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final boolean apply(int eachStage) {
                        return this.apply$mcZI$sp(eachStage);
                    }

                    public boolean apply$mcZI$sp(int eachStage) {
                        return ((IterableLike)((Tuple2)this.$outer.estate$3.stagesData().apply((Object)BoxesRunTime.boxToInteger((int)eachStage)))._2()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$1$$anonfun$3 $outer;

                            public final boolean apply(int parentStage) {
                                return this.apply$mcZI$sp(parentStage);
                            }

                            public boolean apply$mcZI$sp(int parentStage) {
                                return this.$outer.com$qubole$sparklens$scheduler$CompletionEstimator$$anon$$anonfun$$$outer().isStageComplete(parentStage);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anon.1 com$qubole$sparklens$scheduler$CompletionEstimator$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.estate$3.waitingStages().$minus$minus$eq((TraversableOnce)nowRunnableStages);
                this.estate$3.runnableStages().$plus$plus$eq((TraversableOnce)nowRunnableStages);
            }
            {
                this.estate$3 = estate$3;
                super(executorCount$2 * perExecutorCores$2, (HashMap<Object, Object>)taskCountMap$1);
            }
        };
        this.com$qubole$sparklens$scheduler$CompletionEstimator$$scheduleStage(maxStageID, estate, scheduler);
        return this.processStages(maxStageID, estate, scheduler);
    }

    public long estimateAppWallClockTime(AppContext ac, int executorCount, int perExecutorCores, long appRealDuration) {
        long appTotalTime = appRealDuration;
        long jobTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)ac.jobMap().values().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JobTimeSpan x) {
                return x.endTime() > 0L;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(JobTimeSpan x) {
                return x.endTime() - x.startTime();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long driverTimeJobBased = appTotalTime - jobTime;
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)ac.jobMap().values().map((Function1)new Serializable(executorCount, perExecutorCores){
            public static final long serialVersionUID = 0L;
            private final int executorCount$1;
            private final int perExecutorCores$1;

            public final long apply(JobTimeSpan x) {
                return CompletionEstimator$.MODULE$.estimateJobWallClockTime(x, this.executorCount$1, this.perExecutorCores$1);
            }
            {
                this.executorCount$1 = executorCount$1;
                this.perExecutorCores$1 = perExecutorCores$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + driverTimeJobBased;
    }

    private CompletionEstimator$() {
        MODULE$ = this;
    }
}

