/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.sparklens.app;

import com.ning.compress.lzf.LZFInputStream;
import com.qubole.sparklens.QuboleJobListener;
import com.qubole.sparklens.analyzer.AppAnalyzer$;
import com.qubole.sparklens.app.EventHistoryReporter;
import com.qubole.sparklens.app.EventHistoryReporter$;
import com.qubole.sparklens.app.ReporterApp;
import com.qubole.sparklens.common.AppContext;
import com.qubole.sparklens.common.AppContext$;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.xerial.snappy.SnappyInputStream;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class ReporterApp$
implements App {
    public static final ReporterApp$ MODULE$;
    private final String usage;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ReporterApp$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public String usage() {
        return this.usage;
    }

    private void checkArgs() {
        int n = Predef$.MODULE$.refArrayOps((Object[])this.args()).size();
        switch (n) {
            default: 
        }
        if (n < 1) {
            throw new IllegalArgumentException(this.usage());
        }
    }

    public void startAnalysersFromString(String json) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue map = (JsonAST.JValue)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class));
        AppContext appContext = AppContext$.MODULE$.getContext(map);
        this.startAnalysersFromAppContext(appContext);
    }

    private void startAnalysersFromAppContext(AppContext appContext) {
        AppAnalyzer$.MODULE$.startAnalyzers(appContext);
    }

    private void parseInput() {
        String string = this.getSource();
        if ("sparklens".equals(string)) {
            this.reportFromSparklensDump(this.args()[0]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            new EventHistoryReporter(this.args()[0], EventHistoryReporter$.MODULE$.$lessinit$greater$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String getSource() {
        Object object = new Object();
        try {
            Predef$.MODULE$.refArrayOps((Object[])this.args()).foreach((Function1)new Serializable(object){
                public static final long serialVersionUID = 0L;
                private final Object nonLocalReturnKey1$1;

                public final Object apply(String arg) {
                    Object object;
                    String[] splits = arg.split("=");
                    if (Predef$.MODULE$.refArrayOps((Object[])splits).size() == 2) {
                        if ("source".equalsIgnoreCase(splits[0])) {
                            if ("history".equalsIgnoreCase(splits[1])) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)"history");
                            }
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)"sparklens");
                        }
                        object = new IllegalArgumentException(ReporterApp$.MODULE$.usage());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                {
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return "sparklens";
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (String)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    private void reportFromSparklensDump(String file) {
        FileSystem fs = FileSystem.get((URI)new URI(file), (Configuration)new Configuration());
        Path path = new Path(file);
        byte[] byteArray = new byte[(int)fs.getFileStatus(path).getLen()];
        fs.open(path).readFully(byteArray);
        String json = Predef$.MODULE$.charArrayOps((char[])Predef$.MODULE$.byteArrayOps(byteArray).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char apply(byte x$1) {
                return (char)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()))).mkString();
        this.startAnalysersFromString(json);
    }

    public void reportFromEventHistory(String file) {
        Class<?> busKlass = Class.forName("org.apache.spark.scheduler.ReplayListenerBus");
        Object bus = busKlass.newInstance();
        Method addListenerMethod = busKlass.getMethod("addListener", Object.class);
        SparkConf conf = new SparkConf().set("spark.sparklens.reporting.disabled", "false").set("spark.sparklens.save.data", "false");
        QuboleJobListener listener = new QuboleJobListener(conf);
        addListenerMethod.invoke(bus, new Object[]{listener});
        Method replayMethod = busKlass.getMethod("replay", InputStream.class, String.class, Boolean.TYPE, Function1.class);
        replayMethod.invoke(bus, this.getDecodedInputStream(file, conf), file, Predef$.MODULE$.boolean2Boolean(false), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String eventString) {
                return ReporterApp$.MODULE$.com$qubole$sparklens$app$ReporterApp$$getFilter(eventString);
            }
        });
    }

    private InputStream getDecodedInputStream(String file, SparkConf conf) {
        FileSystem fs = FileSystem.get((URI)new URI(file), (Configuration)new Configuration());
        Path path = new Path(file);
        BufferedInputStream bufStream = new BufferedInputStream((InputStream)fs.open(path));
        String logName = new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".inprogress");
        Option codecName = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logName.split("\\.")).tail()).lastOption();
        String string = (String)codecName.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Object object = "lz4".equals(string) ? new LZ4BlockInputStream((InputStream)bufStream) : ("lzf".equals(string) ? new LZFInputStream((InputStream)bufStream) : ("snappy".equals(string) ? new SnappyInputStream((InputStream)bufStream) : bufStream));
        return object;
    }

    public boolean com$qubole$sparklens$app$ReporterApp$$getFilter(String eventString) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        return this.eventFilter().contains((Object)((String)((MapLike)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(eventString), JsonMethods$.MODULE$.parse$default$2())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})))).get((Object)"Event").get()));
    }

    private Set<String> eventFilter() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparkListenerTaskEnd", "SparkListenerApplicationStart", "SparkListenerApplicationEnd", "SparkListenerExecutorAdded", "SparkListenerExecutorRemoved", "SparkListenerJobStart", "SparkListenerJobEnd", "SparkListenerStageSubmitted", "SparkListenerStageCompleted"}));
    }

    public final void delayedEndpoint$com$qubole$sparklens$app$ReporterApp$1() {
        this.usage = "Need to specify sparklens data file\nOf specify event-history file and also add \"source=history\" or \"source=sparklens\".\nIf \"source\" is not specified, sparklens is chosen by default.";
        this.checkArgs();
        this.parseInput();
    }

    private ReporterApp$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ReporterApp.delayedInit.body(this));
    }
}

