/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.sparklens.analyzer;

import com.qubole.sparklens.analyzer.AppAnalyzer;
import com.qubole.sparklens.analyzer.AppAnalyzer$class;
import com.qubole.sparklens.common.AggregateMetrics$;
import com.qubole.sparklens.common.AggregateValue;
import com.qubole.sparklens.common.AppContext;
import com.qubole.sparklens.common.AppContext$;
import com.qubole.sparklens.timespan.ExecutorTimeSpan;
import com.qubole.sparklens.timespan.JobTimeSpan;
import com.qubole.sparklens.timespan.TimeSpan;
import java.text.SimpleDateFormat;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u0017\taRI\u001a4jG&,gnY=Ti\u0006$\u0018n\u001d;jGN\fe.\u00197zu\u0016\u0014(BA\u0002\u0005\u0003!\tg.\u00197zu\u0016\u0014(BA\u0003\u0007\u0003%\u0019\b/\u0019:lY\u0016t7O\u0003\u0002\b\u0011\u00051\u0011/\u001e2pY\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tY\u0011\t\u001d9B]\u0006d\u0017P_3s\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0014\u0001!)1\u0004\u0001C\u00019\u00059\u0011M\\1msj,G\u0003B\u000f%YE\u0002\"AH\u0011\u000f\u00055y\u0012B\u0001\u0011\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001r\u0001\"B\u0013\u001b\u0001\u00041\u0013AC1qa\u000e{g\u000e^3yiB\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006B\u0001\u0007G>lWn\u001c8\n\u0005-B#AC!qa\u000e{g\u000e^3yi\")QF\u0007a\u0001]\u0005I1\u000f^1siRKW.\u001a\t\u0003\u001b=J!\u0001\r\b\u0003\t1{gn\u001a\u0005\u0006ei\u0001\rAL\u0001\bK:$G+[7f\u0001")
public class EfficiencyStatisticsAnalyzer
implements AppAnalyzer {
    private final SimpleDateFormat DF;
    private final SimpleDateFormat MINUTES_DF;

    @Override
    public SimpleDateFormat DF() {
        return this.DF;
    }

    @Override
    public SimpleDateFormat MINUTES_DF() {
        return this.MINUTES_DF;
    }

    @Override
    public void com$qubole$sparklens$analyzer$AppAnalyzer$_setter_$DF_$eq(SimpleDateFormat x$1) {
        this.DF = x$1;
    }

    @Override
    public void com$qubole$sparklens$analyzer$AppAnalyzer$_setter_$MINUTES_DF_$eq(SimpleDateFormat x$1) {
        this.MINUTES_DF = x$1;
    }

    @Override
    public String analyze(AppContext ac) {
        return AppAnalyzer$class.analyze(this, ac);
    }

    @Override
    public String pt(long x) {
        return AppAnalyzer$class.pt(this, x);
    }

    @Override
    public String pd(long millis) {
        return AppAnalyzer$class.pd(this, millis);
    }

    @Override
    public String pcm(long millis) {
        return AppAnalyzer$class.pcm(this, millis);
    }

    @Override
    public AppAnalyzer.PrintlnStringBuilder PrintlnStringBuilder(StringBuilder sb) {
        return AppAnalyzer$class.PrintlnStringBuilder(this, sb);
    }

    @Override
    public String analyze(AppContext appContext, long startTime, long endTime) {
        AppContext ac = appContext.filterByStartAndEndTime(startTime, endTime);
        StringBuilder out = new StringBuilder();
        long appTotalTime = endTime - startTime;
        long jobTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)ac.jobMap().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JobTimeSpan x) {
                return x.endTime() >= x.startTime();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(JobTimeSpan x) {
                return x.endTime() - x.startTime();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long maxExecutors = AppContext$.MODULE$.getMaxConcurrent(ac.executorMap(), ac);
        int executorCores = AppContext$.MODULE$.getExecutorCores(ac);
        long totalCores = (long)executorCores * maxExecutors;
        long appComputeMillisAvailable = totalCores * appTotalTime;
        long computeMillisFromExecutorLifetime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)ac.executorMap().map((Function1)new Serializable(this, startTime, endTime){
            public static final long serialVersionUID = 0L;
            private final long startTime$1;
            private final long endTime$1;

            public final long apply(Tuple2<String, ExecutorTimeSpan> x) {
                int ecores = ((ExecutorTimeSpan)x._2()).cores();
                long estartTime = Math.max(this.startTime$1, ((TimeSpan)x._2()).startTime());
                long eendTime = ((TimeSpan)x._2()).isFinished() ? Math.min(this.endTime$1, ((TimeSpan)x._2()).endTime()) : this.endTime$1;
                return (long)ecores * (eendTime - estartTime);
            }
            {
                this.startTime$1 = startTime$1;
                this.endTime$1 = endTime$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long inJobComputeMillisAvailable = totalCores * jobTime;
        long criticalPathTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)ac.jobMap().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, JobTimeSpan> x) {
                return ((JobTimeSpan)x._2()).computeCriticalTimeForJob();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long inJobComputeMillisUsed = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)ac.jobMap().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JobTimeSpan x) {
                return x.endTime() > 0L;
            }
        })).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JobTimeSpan x) {
                return x.jobMetrics().map().isDefinedAt((Object)AggregateMetrics$.MODULE$.executorRuntime());
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(JobTimeSpan x) {
                return ((AggregateValue)x.jobMetrics().map().apply((Object)AggregateMetrics$.MODULE$.executorRuntime())).value();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long perfectJobTime = inJobComputeMillisUsed / totalCores;
        long driverTimeJobBased = appTotalTime - jobTime;
        long driverComputeMillisWastedJobBased = driverTimeJobBased * totalCores;
        String arg$macro$2 = this.pd(driverTimeJobBased);
        float arg$macro$3 = (float)((double)(driverTimeJobBased * 100L) / (double)appTotalTime);
        String arg$macro$4 = this.pd(jobTime);
        float arg$macro$5 = (float)((double)(jobTime * 100L) / (double)appTotalTime);
        String arg$macro$6 = this.pd(appTotalTime);
        this.PrintlnStringBuilder(out).println(new StringOps(Predef$.MODULE$.augmentString(new StringOps(" Time spent in Driver vs Executors\n              | Driver WallClock Time    %s   %3.2f%%\n              | Executor WallClock Time  %s   %3.2f%%\n              | Total WallClock Time     %s\n      ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2, BoxesRunTime.boxToFloat((float)arg$macro$3), arg$macro$4, BoxesRunTime.boxToFloat((float)arg$macro$5), arg$macro$6})))).stripMargin());
        this.PrintlnStringBuilder(out).println(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |\n         |Minimum possible time for the app based on the critical path (with infinite resources)   ", "\n         |Minimum possible time for the app with same executors, perfect parallelism and zero skew ", "\n         |If we were to run this app with single executor and single core                          ", "\n         |\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pd(driverTimeJobBased + criticalPathTime), this.pd(driverTimeJobBased + perfectJobTime), this.pcm(driverTimeJobBased + inJobComputeMillisUsed)})))).stripMargin());
        this.PrintlnStringBuilder(out).println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Total cores available to the app ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalCores)})));
        float executorUsedPercent = (float)((double)(inJobComputeMillisUsed * 100L) / (double)inJobComputeMillisAvailable);
        float executorWastedPercent = (float)((double)((inJobComputeMillisAvailable - inJobComputeMillisUsed) * 100L) / (double)inJobComputeMillisAvailable);
        float driverWastedPercentOverAll = (float)((double)(driverComputeMillisWastedJobBased * 100L) / (double)appComputeMillisAvailable);
        float executorWastedPercentOverAll = (float)((double)((inJobComputeMillisAvailable - inJobComputeMillisUsed) * 100L) / (double)appComputeMillisAvailable);
        String arg$macro$7 = this.pcm(appComputeMillisAvailable);
        String arg$macro$8 = this.pcm(computeMillisFromExecutorLifetime);
        String arg$macro$9 = this.pcm(driverComputeMillisWastedJobBased);
        String arg$macro$10 = this.pcm(inJobComputeMillisAvailable);
        String arg$macro$11 = this.pcm(inJobComputeMillisUsed);
        float arg$macro$12 = executorUsedPercent;
        String arg$macro$13 = this.pcm(inJobComputeMillisAvailable - inJobComputeMillisUsed);
        float arg$macro$14 = executorWastedPercent;
        float arg$macro$15 = driverWastedPercentOverAll;
        float arg$macro$16 = executorWastedPercentOverAll;
        float arg$macro$17 = driverWastedPercentOverAll + executorWastedPercentOverAll;
        this.PrintlnStringBuilder(out).println(new StringOps(Predef$.MODULE$.augmentString(new StringOps("\n         | OneCoreComputeHours: Measure of total compute power available from cluster. One core in the executor, running\n         |                      for one hour, counts as one OneCoreComputeHour. Executors with 4 cores, will have 4 times\n         |                      the OneCoreComputeHours compared to one with just one core. Similarly, one core executor\n         |                      running for 4 hours will OnCoreComputeHours equal to 4 core executor running for 1 hour.\n         |\n         | Driver Utilization (Cluster idle because of driver)\n         |\n         | Total OneCoreComputeHours available                     %15s\n         | Total OneCoreComputeHours available (AutoScale Aware)   %15s\n         | OneCoreComputeHours wasted by driver                    %15s\n         |\n         | AutoScale Aware: Most of the calculations by this tool will assume that all executors are available throughout\n         |                  the runtime of the application. The number above is printed to show possible caution to be\n         |                  taken in interpreting the efficiency metrics.\n         |\n         | Cluster Utilization (Executors idle because of lack of tasks or skew)\n         |\n         | Executor OneCoreComputeHours available          %15s\n         | Executor OneCoreComputeHours used               %15s        %3.2f%%\n         | OneCoreComputeHours wasted                      %15s        %3.2f%%\n         |\n         | App Level Wastage Metrics (Driver + Executor)\n         |\n         | OneCoreComputeHours wasted Driver               %3.2f%%\n         | OneCoreComputeHours wasted Executor             %3.2f%%\n         | OneCoreComputeHours wasted Total                %3.2f%%\n         |\n       ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$7, arg$macro$8, arg$macro$9, arg$macro$10, arg$macro$11, BoxesRunTime.boxToFloat((float)arg$macro$12), arg$macro$13, BoxesRunTime.boxToFloat((float)arg$macro$14), BoxesRunTime.boxToFloat((float)arg$macro$15), BoxesRunTime.boxToFloat((float)arg$macro$16), BoxesRunTime.boxToFloat((float)arg$macro$17)})))).stripMargin());
        return out.toString();
    }

    public EfficiencyStatisticsAnalyzer() {
        AppAnalyzer$class.$init$(this);
    }
}

