/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.sparklens;

import com.qubole.sparklens.QuboleJobListener;
import com.qubole.sparklens.QuboleNotebookListener$;
import com.qubole.sparklens.analyzer.AppAnalyzer;
import com.qubole.sparklens.analyzer.EfficiencyStatisticsAnalyzer;
import com.qubole.sparklens.analyzer.ExecutorWallclockAnalyzer;
import com.qubole.sparklens.analyzer.StageSkewAnalyzer;
import com.qubole.sparklens.common.AppContext;
import com.qubole.sparklens.timespan.ExecutorTimeSpan;
import com.qubole.sparklens.timespan.HostTimeSpan;
import com.qubole.sparklens.timespan.StageTimeSpan;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.util.SizeEstimator$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001%\u0011a#U;c_2,gj\u001c;fE>|7\u000eT5ti\u0016tWM\u001d\u0006\u0003\u0007\u0011\t\u0011b\u001d9be.dWM\\:\u000b\u0005\u00151\u0011AB9vE>dWMC\u0001\b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u00195\t!!\u0003\u0002\u000e\u0005\t\t\u0012+\u001e2pY\u0016TuN\u0019'jgR,g.\u001a:\t\u0011=\u0001!\u0011!Q\u0001\nA\t\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001eL!!\u0007\n\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e=A\u00111\u0002\u0001\u0005\u0006\u001fi\u0001\r\u0001\u0005\u0005\tA\u0001A)\u0019!C\u0005C\u0005!B-\u001a4bk2$X\t_3dkR|'oQ8sKN,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0004\u0013:$\b\u0002C\u0015\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0012\u0002+\u0011,g-Y;mi\u0016CXmY;u_J\u001cuN]3tA!)1\u0006\u0001C!Y\u0005\u0001rN\\!qa2L7-\u0019;j_:,e\u000e\u001a\u000b\u0003[A\u0002\"a\t\u0018\n\u0005=\"#\u0001B+oSRDQ!\r\u0016A\u0002I\na\"\u00199qY&\u001c\u0017\r^5p]\u0016sG\r\u0005\u00024m5\tAG\u0003\u00026%\u0005I1o\u00195fIVdWM]\u0005\u0003oQ\u00121d\u00159be.d\u0015n\u001d;f]\u0016\u0014\u0018\t\u001d9mS\u000e\fG/[8o\u000b:$\u0007\"B\u001d\u0001\t\u0003R\u0014aC8o)\u0006\u001c8n\u0015;beR$\"!L\u001e\t\u000bqB\u0004\u0019A\u001f\u0002\u0013Q\f7o[*uCJ$\bCA\u001a?\u0013\tyDG\u0001\fTa\u0006\u00148\u000eT5ti\u0016tWM\u001d+bg.\u001cF/\u0019:u\u0011\u0015\t\u0005\u0001\"\u0001C\u00031)7\u000f^5nCR,7+\u001b>f)\u0005\u0019\u0005CA\u0012E\u0013\t)EE\u0001\u0003M_:<\u0007\"B$\u0001\t\u0003A\u0015A\u00059ve\u001e,'j\u001c2t\u0003:$7\u000b^1hKN$\u0012!\f\u0005\u0006\u0015\u0002!\taS\u0001\tO\u0016$8\u000b^1ugR\u0019AjU+\u0011\u00055\u0003fBA\u0012O\u0013\tyE%\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(%\u0011\u0015!\u0016\n1\u0001D\u0003!1'o\\7US6,\u0007\"\u0002,J\u0001\u0004\u0019\u0015A\u0002;p)&lW\rC\u0003Y\u0001\u0011\u0005\u0011,\u0001\bhKRl\u0015\r\u001f#bi\u0006\u001c\u0016N_3\u0015\u0003\tBQa\u0017\u0001\u0005\u0002e\u000b1cZ3u/\u0006LG+[7f\u0013:\u001cVmY8oINDq!\u0018\u0001C\u0002\u0013\u0005\u0011%A\u0006nCb$\u0015\r^1TSj,\u0007BB0\u0001A\u0003%!%\u0001\u0007nCb$\u0015\r^1TSj,\u0007\u0005C\u0004b\u0001\t\u0007I\u0011A\u0011\u0002\u0015]\f\u0017\u000e\u001e+j[\u0016l5\u000f\u0003\u0004d\u0001\u0001\u0006IAI\u0001\fo\u0006LG\u000fV5nK6\u001b\b\u0005C\u0003f\u0001\u0011\u0005a-A\u0005qe>4\u0017\u000e\\3JiV\u0011qM\u001b\u000b\u0003QN\u0004\"!\u001b6\r\u0001\u0011)1\u000e\u001ab\u0001Y\n\t!+\u0005\u0002naB\u00111E\\\u0005\u0003_\u0012\u0012qAT8uQ&tw\r\u0005\u0002$c&\u0011!\u000f\n\u0002\u0004\u0003:L\bB\u0002;e\t\u0003\u0007Q/A\u0003cY>\u001c7\u000eE\u0002$m\"L!a\u001e\u0013\u0003\u0011q\u0012\u0017P\\1nKz:Q!\u001f\u0002\t\u0002i\fa#U;c_2,gj\u001c;fE>|7\u000eT5ti\u0016tWM\u001d\t\u0003\u0017m4Q!\u0001\u0002\t\u0002q\u001c\"a_?\u0011\u0005\rr\u0018BA@%\u0005\u0019\te.\u001f*fM\"11d\u001fC\u0001\u0003\u0007!\u0012A\u001f\u0005\b\u0003\u000fYH\u0011AA\u0005\u00039\u0011XmZ5ti\u0016\u0014\u0018I\u001c3HKR$2!HA\u0006\u0011!\ti!!\u0002A\u0002\u0005=\u0011AA:d!\r\t\u0012\u0011C\u0005\u0004\u0003'\u0011\"\u0001D*qCJ\\7i\u001c8uKb$\b")
public class QuboleNotebookListener
extends QuboleJobListener {
    private final SparkConf sparkConf;
    private int defaultExecutorCores;
    private final int maxDataSize;
    private final int waitTimeMs;
    private volatile boolean bitmap$0;

    public static QuboleNotebookListener registerAndGet(SparkContext sparkContext) {
        return QuboleNotebookListener$.MODULE$.registerAndGet(sparkContext);
    }

    private int defaultExecutorCores$lzycompute() {
        QuboleNotebookListener quboleNotebookListener = this;
        synchronized (quboleNotebookListener) {
            if (!this.bitmap$0) {
                this.defaultExecutorCores = this.sparkConf.getInt("spark.executor.cores", 2);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.sparkConf = null;
            return this.defaultExecutorCores;
        }
    }

    private int defaultExecutorCores() {
        return this.bitmap$0 ? this.defaultExecutorCores : this.defaultExecutorCores$lzycompute();
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        ((IterableLike)this.stageMap().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StageTimeSpan apply(Tuple2<Object, StageTimeSpan> x) {
                return (StageTimeSpan)x._2();
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StageTimeSpan x) {
                x.tempTaskTimes().clear();
            }
        });
        this.appInfo().endTime_$eq(applicationEnd.time());
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        Option hostTimeSpan;
        TaskInfo taskInfo = taskStart.taskInfo();
        Option executorTimeSpan = this.executorMap().get((Object)taskInfo.executorId());
        if (!executorTimeSpan.isDefined()) {
            ExecutorTimeSpan timeSpan = new ExecutorTimeSpan(taskInfo.executorId(), taskInfo.host(), this.defaultExecutorCores());
            timeSpan.setStartTime(taskInfo.launchTime());
            this.executorMap().update((Object)taskInfo.executorId(), (Object)timeSpan);
        }
        if (!(hostTimeSpan = this.hostMap().get((Object)taskInfo.host())).isDefined()) {
            HostTimeSpan timeSpan = new HostTimeSpan(taskInfo.host());
            timeSpan.setStartTime(taskInfo.launchTime());
            this.hostMap().update((Object)taskInfo.host(), (Object)timeSpan);
        }
    }

    public long estimateSize() {
        return SizeEstimator$.MODULE$.estimate((Object)this);
    }

    public void purgeJobsAndStages() {
        this.stageMap().clear();
        this.jobMap().clear();
    }

    public String getStats(long fromTime, long toTime) {
        ListBuffer list = new ListBuffer();
        list.$plus$eq((Object)new StageSkewAnalyzer());
        list.$plus$eq((Object)new ExecutorWallclockAnalyzer());
        list.$plus$eq((Object)new EfficiencyStatisticsAnalyzer());
        AppContext appContext = new AppContext(this.appInfo(), this.appMetrics(), this.hostMap(), this.executorMap(), this.jobMap(), this.stageMap(), this.stageIDToJobID());
        StringBuilder out = new StringBuilder();
        list.foreach((Function1)new Serializable(this, fromTime, toTime, appContext, out){
            public static final long serialVersionUID = 0L;
            private final long fromTime$1;
            private final long toTime$1;
            private final AppContext appContext$1;
            private final StringBuilder out$1;

            public final Object apply(AppAnalyzer x) {
                StringBuilder stringBuilder;
                try {
                    String result = x.analyze(this.appContext$1, this.fromTime$1, this.toTime$1);
                    stringBuilder = this.out$1.append(result);
                }
                catch (Throwable throwable) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed in Analyzer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass().getSimpleName()})));
                    throwable.printStackTrace();
                    stringBuilder = BoxedUnit.UNIT;
                }
                return stringBuilder;
            }
            {
                this.fromTime$1 = fromTime$1;
                this.toTime$1 = toTime$1;
                this.appContext$1 = appContext$1;
                this.out$1 = out$1;
            }
        });
        return out.toString();
    }

    public int getMaxDataSize() {
        return this.maxDataSize();
    }

    public int getWaiTimeInSeconds() {
        return this.waitTimeMs() / 1000;
    }

    public int maxDataSize() {
        return this.maxDataSize;
    }

    public int waitTimeMs() {
        return this.waitTimeMs;
    }

    public <R> R profileIt(Function0<R> block) {
        if (this.estimateSize() > (long)this.maxDataSize()) {
            this.purgeJobsAndStages();
        }
        long startTime = System.currentTimeMillis();
        Object result = block.apply();
        long endTime = System.currentTimeMillis();
        Thread.sleep(this.waitTimeMs());
        Predef$.MODULE$.println((Object)this.getStats(startTime, endTime));
        return (R)result;
    }

    public QuboleNotebookListener(SparkConf sparkConf) {
        this.sparkConf = sparkConf;
        super(sparkConf);
        this.maxDataSize = 0x2000000;
        this.waitTimeMs = 5000;
    }
}

