/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

public class ListModelMap<K, V>
extends AbstractListModel<Map.Entry<K, V>>
implements Sortable<Map.Entry<K, V>>,
Map<K, V>,
Serializable {
    private static final long serialVersionUID = 20120206122736L;
    protected Map<K, V> _map;
    private Comparator<Map.Entry<K, V>> _sorting;
    private boolean _sortDir;

    public ListModelMap(Map<K, V> map, boolean live) {
        this._map = live ? map : new LinkedHashMap(map);
    }

    public ListModelMap() {
        this._map = new LinkedHashMap();
    }

    public ListModelMap(Map<? extends K, ? extends V> map) {
        this._map = new LinkedHashMap<K, V>(map);
    }

    public ListModelMap(int initialCapacity) {
        this._map = new LinkedHashMap(initialCapacity);
    }

    public ListModelMap(int initialCapacity, float loadFactor) {
        this._map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public Map<K, V> getInnerMap() {
        return this._map;
    }

    @Override
    public int getSize() {
        return this._map.size();
    }

    @Override
    public Map.Entry<K, V> getElementAt(int j) {
        Map.Entry<K, V> o;
        if (j < 0 || j >= this._map.size()) {
            throw new IndexOutOfBoundsException("" + j);
        }
        Iterator<Map.Entry<K, V>> it = this._map.entrySet().iterator();
        do {
            o = it.next();
        } while (--j >= 0);
        return new Entry0<K, V>(o);
    }

    @Override
    public void clear() {
        int i2 = this._map.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._map.clear();
        this.fireEvent(2, 0, i2);
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Entries(this._map.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this._map.equals(o instanceof ListModelMap ? ((ListModelMap)o)._map : o);
    }

    public String toString() {
        return this._map.toString();
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new Keys(this._map.keySet());
    }

    @Override
    public V put(K key, V o) {
        V ret;
        if (this._map.containsKey(key)) {
            if (Objects.equals(o, this._map.get(key))) {
                return o;
            }
            int index = this.indexOfKey(key);
            ret = this._map.put(key, o);
            this.fireEvent(0, index, index);
        } else {
            ret = this._map.put(key, o);
            if (this._map instanceof LinkedHashMap) {
                int i1 = this._map.size() - 1;
                this.fireEvent(1, i1, i1);
            } else if (this._map instanceof SortedMap) {
                int i1 = this.indexOfKey(key);
                this.fireEvent(1, i1, i1);
            } else {
                this.fireEvent(0, -1, -1);
            }
        }
        return ret;
    }

    public int indexOfKey(Object o) {
        int j = 0;
        Iterator<K> it = this._map.keySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public int indexOf(Object o) {
        int j = 0;
        Iterator<Map.Entry<K, V>> it = this._map.entrySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> c) {
        if (c == this._map) {
            return;
        }
        if (this._map instanceof LinkedHashMap) {
            int sz = c.size();
            if (sz <= 0) {
                return;
            }
            ArrayList<Map.Entry<K, V>> added = new ArrayList<Map.Entry<K, V>>(c.size());
            for (Map.Entry<K, V> entry : c.entrySet()) {
                K key = entry.getKey();
                if (this._map.containsKey(key)) {
                    this.put(key, entry.getValue());
                    continue;
                }
                added.add(entry);
            }
            for (Map.Entry<K, V> entry : added) {
                this._map.put(entry.getKey(), entry.getValue());
            }
            int len = added.size();
            if (len > 0) {
                this.fireEvent(1, sz, sz + len - 1);
            }
        } else {
            this._map.putAll(c);
            this.fireEvent(0, -1, -1);
        }
    }

    @Override
    public V remove(Object key) {
        if (this._map.containsKey(key)) {
            V ret = null;
            this.removeSelectionByKey(key);
            if (this._map instanceof LinkedHashMap || this._map instanceof SortedMap) {
                int index = this.indexOfKey(key);
                ret = this._map.remove(key);
                this.fireEvent(2, index, index);
            } else {
                ret = this._map.remove(key);
                this.fireEvent(0, -1, -1);
            }
            return ret;
        }
        return null;
    }

    private void removeSelectionByKey(Object key) {
        for (Map.Entry entry : this.getSelection()) {
            if (!Objects.equals((Object)key, entry.getKey())) continue;
            this.removeFromSelection(entry);
            return;
        }
    }

    private void removeSelectionByValue(Object value) {
        for (Map.Entry entry : this.getSelection()) {
            if (!Objects.equals((Object)value, entry.getValue())) continue;
            this.removeFromSelection(entry);
            return;
        }
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        return new Values(this._map.values());
    }

    @Override
    public void sort(Comparator<Map.Entry<K, V>> cmpr, boolean ascending) {
        ArrayList<Map.Entry<K, V>> copy = new ArrayList<Map.Entry<K, V>>(this._map.entrySet());
        this._sorting = cmpr;
        this._sortDir = ascending;
        try {
            Collections.sort(copy, cmpr);
        }
        catch (ClassCastException e) {
            throw new UiException("Unable to sort, maybe you should use FieldComparator, sort=\"auto(key)\" or sort=\"auto(value)\"", (Throwable)e);
        }
        this._map.clear();
        for (Map.Entry entry : copy) {
            this._map.put(entry.getKey(), entry.getValue());
        }
        this.fireEvent(3, -1, -1);
    }

    @Override
    public void sort() {
        if (this._sorting == null) {
            throw new UiException("The sorting comparator is not assigned, please use sort(Comparator cmpr, final boolean ascending)");
        }
        this.sort(this._sorting, this._sortDir);
    }

    @Override
    public String getSortDirection(Comparator<Map.Entry<K, V>> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }

    private boolean removePartial(Collection<?> master, Collection<?> c, boolean isRemove, boolean byKey, boolean byValue) {
        int sz = c.size();
        int removed = 0;
        int retained = 0;
        int index = 0;
        int begin = -1;
        ArrayList selected = new ArrayList();
        Iterator<?> it = master.iterator();
        while (!(!it.hasNext() || isRemove && removed >= sz || !isRemove && retained >= sz)) {
            Object item = it.next();
            if (c.contains(item) == isRemove) {
                if (begin < 0) {
                    begin = index;
                }
                ++removed;
                it.remove();
                selected.add(item);
            } else {
                ++retained;
                if (begin >= 0) {
                    this.fireEvent(2, begin, index - 1);
                    index = begin;
                    begin = -1;
                }
            }
            ++index;
        }
        if (!selected.isEmpty()) {
            if (byKey) {
                for (Object item : selected) {
                    this.removeSelectionByKey(item);
                }
            } else if (byValue) {
                for (Object item : selected) {
                    this.removeSelectionByValue(item);
                }
            } else {
                for (Object item : selected) {
                    this.removeFromSelection(item);
                }
            }
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed > 0;
    }

    @Override
    public Object clone() {
        ListModelMap clone = (ListModelMap)super.clone();
        if (this._map != null) {
            clone._map = new LinkedHashMap<K, V>(this._map);
        }
        return clone;
    }

    @Override
    protected void fireSelectionEvent(Map.Entry<K, V> e) {
        this.fireEvent(4, this.indexOf(e), -1);
    }

    public void addSelection(Map.Entry<K, V> obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }

    @Override
    protected void writeSelection(ObjectOutputStream s) throws IOException {
        s.writeInt(this._selection.size());
        for (Map.Entry sel : this._selection) {
            s.writeObject(sel.getKey());
        }
    }

    @Override
    protected void readSelection(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this._selection = this.newEmptySelection();
        int size = s.readInt();
        while (--size >= 0) {
            this._selection.add(s.readObject());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Set selection = this._selection;
        this._selection = this.newEmptySelection();
        for (Object key : selection) {
            if (!this._map.containsKey(key)) continue;
            for (Map.Entry<K, V> entry : this._map.entrySet()) {
                if (!Objects.equals(key, entry.getKey())) continue;
                this._selection.add(entry);
            }
        }
    }

    private class Values
    extends MyCol<V> {
        private Collection<V> _col;

        public Values(Collection<V> col) {
            super(col);
        }

        @Override
        public void clear() {
            int i2 = this._col.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._col.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        private int indexOfAndRemove(Object o) {
            int j = 0;
            Iterator it = this._col.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (Objects.equals(val, (Object)o)) {
                    ListModelMap.this.removeFromSelection(o);
                    it.remove();
                    return j;
                }
                ++j;
            }
            return -1;
        }

        @Override
        public boolean remove(Object o) {
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                int index = this.indexOfAndRemove(o);
                if (index < 0) {
                    return false;
                }
                ListModelMap.this.fireEvent(2, index, index);
                return true;
            }
            ListModelMap.this.removeFromSelection(o);
            boolean ret = this._col.remove(o);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this._col == c || this == c) {
                ListModelMap.this.clearSelection();
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._col, c, true, false, true);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._col.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this._col == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._col, c, false, false, true);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._col.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }
    }

    private abstract class MyCol<E>
    implements Collection<E> {
        protected Collection<E> _col;

        public MyCol(Collection<E> col) {
            this._col = col;
        }

        @Override
        public Iterator<E> iterator() {
            return new MyIterator<E>(this._col.iterator());
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("add()");
        }

        @Override
        public boolean addAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException("addAll()");
        }

        @Override
        public boolean contains(Object o) {
            return this._col == null ? false : this._col.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this._col == null ? false : this._col.containsAll(c);
        }

        @Override
        public int hashCode() {
            return this._col == null ? 0 : this._col.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MyCol) {
                return Objects.equals(((MyCol)o)._col, this._col);
            }
            return Objects.equals(this._col, (Object)o);
        }

        @Override
        public boolean isEmpty() {
            return this._col == null ? true : this._col.isEmpty();
        }

        @Override
        public int size() {
            return this._col == null ? 0 : this._col.size();
        }

        @Override
        public Object[] toArray() {
            return this._col == null ? new Object[]{} : this._col.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this._col == null ? a : this._col.toArray(a);
        }
    }

    private class Entries
    extends MySet<Map.Entry<K, V>> {
        private Entries(Set<Map.Entry<K, V>> inner) {
            super(inner, false);
        }

        @Override
        protected int indexOf(Object o) {
            return ListModelMap.this.indexOf(o);
        }
    }

    private class Keys
    extends MySet<K> {
        public Keys(Set<K> inner) {
            super(inner, true);
        }

        @Override
        protected int indexOf(Object o) {
            return ListModelMap.this.indexOfKey(o);
        }
    }

    private abstract class MySet<E>
    implements Set<E> {
        private final Set<E> _set;
        private final boolean _keyset;

        public MySet(Set<E> inner, boolean keyset) {
            this._set = inner;
            this._keyset = keyset;
        }

        @Override
        public void clear() {
            int i2 = this._set.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._set.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        @Override
        public boolean remove(Object o) {
            boolean ret = false;
            if (this._set.contains(o)) {
                ListModelMap.this.removeFromSelection(o);
                if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                    int index = this.indexOf(o);
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(2, index, index);
                } else {
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(0, -1, -1);
                }
            }
            return ret;
        }

        protected abstract int indexOf(Object var1);

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this._set == c || this == c) {
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, true, this._keyset, false);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._set.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this._set == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, false, this._keyset, false);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._set.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public Iterator<E> iterator() {
            return new MyIterator<E>(this._set.iterator());
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("add()");
        }

        @Override
        public boolean addAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException("addAll()");
        }

        @Override
        public boolean contains(Object o) {
            return this._set == null ? false : this._set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this._set == null ? false : this._set.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MySet) {
                return Objects.equals(((MySet)o)._set, this._set);
            }
            return Objects.equals(this._set, (Object)o);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this._set);
        }

        @Override
        public boolean isEmpty() {
            return this._set == null || this._set.isEmpty();
        }

        @Override
        public int size() {
            return this._set == null ? 0 : this._set.size();
        }

        @Override
        public Object[] toArray() {
            return this._set == null ? new Object[]{} : this._set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this._set == null ? a : this._set.toArray(a);
        }
    }

    private class MyIterator<E>
    implements Iterator<E> {
        private Iterator<E> _it;
        private E _current;
        private int _nextIndex;

        public MyIterator(Iterator<E> inner) {
            this._it = inner;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext();
        }

        @Override
        public E next() {
            this._current = this._it.next();
            ++this._nextIndex;
            return this._current;
        }

        @Override
        public void remove() {
            this._it.remove();
            ListModelMap.this.removeFromSelection(this._current);
            --this._nextIndex;
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                ListModelMap.this.fireEvent(2, this._nextIndex, this._nextIndex);
            } else {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
        }
    }

    private static class Entry0<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private K _key;
        private V _value;
        private transient Map.Entry<K, V> _entry;

        Entry0(Map.Entry<K, V> entry) {
            this._entry = entry;
        }

        @Override
        public K getKey() {
            return this._entry != null ? this._entry.getKey() : this._key;
        }

        @Override
        public V getValue() {
            return this._entry != null ? this._entry.getValue() : this._value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this._value;
            if (this._entry != null) {
                oldValue = this._entry.getValue();
                this._entry.setValue(value);
            } else {
                this._value = value;
            }
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (this._entry != null) {
                return this._entry.equals(o);
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            if (this._entry != null) {
                return this._entry.hashCode();
            }
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }

        public final String toString() {
            if (this._entry != null) {
                return this._entry.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            if (this._entry != null) {
                s.writeObject(this._entry.getKey());
                s.writeObject(this._entry.getValue());
            } else {
                s.writeObject(this._key);
                s.writeObject(this._value);
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._key = s.readObject();
            this._value = s.readObject();
        }
    }
}

