/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Frozen
extends XulElement {
    private int _columns;
    private int _start;
    private int _currentLeft = 0;
    private int _rightColumns;

    public void setStart(int start) {
        if (start < 0) {
            throw new WrongValueException("Positive only");
        }
        if (this._start != start) {
            this._start = start;
            this.smartUpdate("start", this._start);
        }
    }

    public int getStart() {
        return this._start;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new WrongValueException("Positive only");
        }
        if (this._columns != columns) {
            this._columns = columns;
            this.smartUpdate("columns", this._columns);
        }
    }

    public int getColumns() {
        return this._columns;
    }

    public void setRows(int rows) {
        throw new UnsupportedOperationException("Unsupported yet!");
    }

    public int getRows() {
        return 0;
    }

    public int getRightColumns() {
        return this._rightColumns;
    }

    public void setRightColumns(int rightColumns) {
        if (rightColumns < 0) {
            throw new WrongValueException("Positive only");
        }
        if (this._rightColumns != rightColumns) {
            this._rightColumns = rightColumns;
            this.smartUpdate("rightColumns", this._rightColumns);
        }
    }

    public boolean isSmooth() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.frozen.smooth", true, true);
    }

    public String getZclass() {
        return this._zclass == null ? "z-frozen" : this._zclass;
    }

    protected void updateByClient(String name, Object value) {
        if ("start".equals(name)) {
            this.setStart(value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(Objects.toString((Object)value)));
        } else {
            super.updateByClient(name, value);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._columns > 0) {
            renderer.render("columns", this._columns);
        }
        if (this._columns > 0 && this._start > 0) {
            renderer.render("start", this._start);
        }
        if (!this.isSmooth()) {
            renderer.render("smooth", false);
        } else {
            renderer.render("currentLeft", this._currentLeft);
        }
        if (this._rightColumns > 0) {
            renderer.render("rightColumns", this._rightColumns);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (this.isSmooth() && cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Frozen.addClientEvent(Frozen.class, (String)"onScrollPos", (int)8193);
    }
}

