/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.json.JSONAware;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.CloneableEventListener;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Paging;
import org.zkoss.zul.PagingEventPublisher;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.GroupsSelectableModel;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.ListboxDataLoader;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Padding;
import org.zkoss.zul.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listbox
extends MeshElement {
    private static final long serialVersionUID = 2009111111L;
    public static final String LOADING_MODEL = "org.zkoss.zul.loadingModel";
    public static final String SYNCING_MODEL = "org.zkoss.zul.syncingModel";
    private static final Logger log = LoggerFactory.getLogger(Listbox.class);
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private static final String ATTR_ON_PAGING_INIT_RENDERER_POSTED = "org.zkoss.zul.onPagingInitPosted";
    private static final int INIT_LIMIT = 50;
    private transient DataLoader _dataLoader;
    private transient List<Listitem> _items;
    private transient List<int[]> _groupsInfo;
    private transient List<Listgroup> _groups;
    private transient Set<Listitem> _selItems;
    private transient Set<Listitem> _roSelItems;
    private int _maxlength;
    private int _rows;
    private int _jsel = -1;
    private transient Listhead _listhead;
    private transient Listfoot _listfoot;
    private transient Frozen _frozen;
    private transient ListModel<?> _model;
    private transient ListitemRenderer<?> _renderer;
    private transient ListDataListener _dataListener;
    private transient Collection<Component> _heads;
    private int _hdcnt;
    private String _innerWidth = "100%";
    private String _name;
    private transient Paginal _pgi;
    private transient boolean _isReplacingItem;
    private transient int _focusIndex = -1;
    private transient Paging _paging;
    private EventListener<Event> _pgListener;
    private EventListener<Event> _pgImpListener;
    private EventListener<Event> _modelInitListener;
    private String _scOddRow = null;
    private int _tabindex;
    private int _preloadsz = 50;
    private int _visibleItemCount;
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private int _topPad;
    private String _nonselTags;
    private int _anchorTop = 0;
    private int _anchorLeft = 0;
    private boolean _multiple;
    private boolean _disabled;
    private boolean _checkmark;
    private boolean _renderAll;
    private transient boolean _rod;
    private transient boolean _ignoreDataSelectionEvent;
    private String _emptyMessage;
    private static Boolean _ckDeselectOther;

    public Listbox() {
        this.init();
    }

    private void init() {
        this._items = new AbstractSequentialList<Listitem>(){

            @Override
            public ListIterator<Listitem> listIterator(int index) {
                return new ItemIter(index);
            }

            @Override
            public Listitem get(int j) {
                Component o = (Component)Listbox.this.getChildren().get(j + Listbox.this._hdcnt);
                if (o instanceof Listitem) {
                    return (Listitem)o;
                }
                throw new IndexOutOfBoundsException("Wrong index: " + j);
            }

            @Override
            public int size() {
                int sz = Listbox.this.getChildren().size() - Listbox.this._hdcnt;
                if (Listbox.this._listfoot != null) {
                    --sz;
                }
                if (Listbox.this._paging != null) {
                    --sz;
                }
                if (Listbox.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            @Override
            protected void removeRange(int fromIndex, int toIndex) {
                ListIterator<Listitem> it = this.listIterator(toIndex);
                int n = toIndex - fromIndex;
                while (--n >= 0 && it.hasPrevious()) {
                    it.previous();
                    it.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                boolean oldFlag = Listbox.this.setReplacingItem(true);
                try {
                    if (Listbox.this.getSelectedCount() > 0) {
                        Listbox.this.clearSelection();
                        Listbox.this._anchorLeft = (Listbox.this._anchorTop = 0);
                    }
                    super.clear();
                }
                finally {
                    Listbox.this.setReplacingItem(oldFlag);
                }
            }
        };
        this._selItems = new LinkedHashSet<Listitem>(4);
        this._roSelItems = Collections.unmodifiableSet(this._selItems);
        this._heads = new AbstractCollection<Component>(){

            @Override
            public int size() {
                return Listbox.this._hdcnt;
            }

            @Override
            public Iterator<Component> iterator() {
                return new Iter();
            }
        };
        this._groupsInfo = new LinkedList<int[]>();
        this._groups = new AbstractList<Listgroup>(){

            @Override
            public int size() {
                return Listbox.this.getGroupCount();
            }

            @Override
            public Iterator<Listgroup> iterator() {
                return new IterGroups();
            }

            @Override
            public Listgroup get(int index) {
                return (Listgroup)Listbox.this.getItemAtIndex(((int[])Listbox.this._groupsInfo.get(index))[0]);
            }
        };
    }

    private int getRealIndex(int index) {
        int offset = this._model != null ? this.getDataLoader().getOffset() : 0;
        return index - (offset < 0 ? 0 : offset);
    }

    public <T extends Component> List<T> getChildren() {
        return new Children();
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Listbox.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public Listhead getListhead() {
        return this._listhead;
    }

    public Listfoot getListfoot() {
        return this._listfoot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Collection<Component> getHeads() {
        return this._heads;
    }

    boolean inSelectMold() {
        return "select".equals(this.getMold());
    }

    public boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public boolean isVflex() {
        String vflex = this.getVflex();
        if ("true".equals(vflex) || "min".equals(vflex)) {
            return true;
        }
        if (Strings.isBlank((String)vflex) || "false".equals(vflex)) {
            return false;
        }
        return Integer.parseInt(vflex) > 0;
    }

    public void setVflex(boolean vflex) {
        if (this.isVflex() != vflex) {
            this.setVflex(String.valueOf(vflex));
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("rows", this._rows);
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Listitem item = this.getSelectedItem();
                Iterator<Listitem> it = this._selItems.iterator();
                while (it.hasNext()) {
                    Listitem li = it.next();
                    if (li == item) continue;
                    li.setSelectedDirectly(false);
                    it.remove();
                }
            }
            if (this._model != null) {
                ((Selectable)((Object)this._model)).setMultiple(multiple);
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public void setNonselectableTags(String tags) {
        if (!Objects.equals((Object)this._nonselTags, (Object)tags)) {
            this._nonselTags = tags;
            this.smartUpdate("nonselectableTags", tags);
        }
    }

    public String getNonselectableTags() {
        return this._nonselTags;
    }

    public List<Listitem> getItems() {
        return this._items;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public Listitem getItemAtIndex(int index) {
        int realindex = this.getRealIndex(index);
        return realindex < 0 || realindex >= this._items.size() ? null : this._items.get(realindex);
    }

    public int getIndexOfItem(Listitem item) {
        return item == null ? -1 : item.getIndex();
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    boolean isLoadingModel() {
        return this.getAttribute(LOADING_MODEL) != null;
    }

    public void setSelectedIndex(int jsel) {
        Listitem item;
        int tsz;
        int isz = this._items.size();
        int n = tsz = this._model != null ? this._model.getSize() : isz;
        if (jsel >= tsz) {
            throw new UiException("Out of bound: " + jsel + " while size=" + tsz);
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._multiple && this._selItems.size() > 1 || !this._selItems.contains((Object)this.getItemAtIndex(this._jsel))) {
            for (Listitem item2 : this._selItems) {
                item2.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = jsel;
            item = this.getItemAtIndex(this._jsel);
            if (item == null) {
                if (this.inPagingMold()) {
                    int offset = this._jsel - this._jsel % this.getPageSize();
                    int limit = this.getPageSize();
                    this.getDataLoader().syncModel(offset, limit);
                    if (this._jsel != jsel) {
                        this._jsel = jsel;
                    }
                } else {
                    this.smartUpdate("selInView_", this._jsel);
                }
            } else if (!item.isDisabled()) {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
            }
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", this._jsel);
            } else if (item != null) {
                this.smartUpdate("selectedItem", (Object)item);
            }
        }
        if (this._jsel >= 0 && this.inPagingMold()) {
            item = this.getItemAtIndex(this._jsel);
            int size = this.getDataLoader().getOffset();
            VisibleChildrenIterator it = new VisibleChildrenIterator(true);
            while (it.hasNext() && !item.equals(it.next())) {
                ++size;
            }
            int pg = size / this.getPageSize();
            if (pg != this.getActivePage()) {
                this.setActivePage(pg);
            }
        }
    }

    public void selectItem(Listitem item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._multiple || !item.isSelected()) {
                this.setSelectedIndex(item.getIndex());
            }
        }
    }

    public void addItemToSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                if (item.getIndex() < this._jsel || this._jsel < 0) {
                    this._jsel = item.getIndex();
                    if (this.inSelectMold()) {
                        this.smartUpdate("selectedIndex", this._jsel);
                    } else if (item != null) {
                        this.smartUpdate("selectedItem", (Object)item);
                    }
                }
                if (!item.isDisabled()) {
                    item.setSelectedDirectly(true);
                    this._selItems.add(item);
                }
                this.smartUpdateSelection();
            }
        }
    }

    public void removeItemFromSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                this.fixSelectedIndex(0);
                this.smartUpdateSelection();
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        for (Listitem item : this._selItems) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item.getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Listitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            for (Listitem item : this._selItems) {
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = -1;
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", -1);
            } else {
                this.smartUpdate("selectedItem", null);
            }
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        if (this._items.size() != this._selItems.size()) {
            for (Listitem item : this._items) {
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            this._jsel = this._items.isEmpty() ? -1 : 0;
            this.smartUpdate("selectAll", true);
        }
    }

    public Listitem getSelectedItem() {
        return this._jsel >= 0 ? (this._jsel > 0 && this._selItems.size() == 1 ? this._selItems.iterator().next() : this.getItemAtIndex(this._jsel)) : null;
    }

    public void setSelectedItem(Listitem item) {
        this.selectItem(item);
    }

    public void setSelectedItems(Set<Listitem> listItems) {
        if (!this.isMultiple()) {
            throw new WrongValueException("Listbox must allow multiple selections.");
        }
        Iterator<Listitem> it = listItems.iterator();
        while (it.hasNext()) {
            this.addItemToSelection(it.next());
        }
    }

    public Set<Listitem> getSelectedItems() {
        return this._roSelItems;
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public Listitem appendItem(String label, String value) {
        Listitem item = new Listitem(label, value);
        item.applyProperties();
        item.setParent((Component)this);
        return item;
    }

    public Listitem removeItemAt(int index) {
        Listitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getDataLoader().getTotalSize());
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("paginal", this._pgi);
                    }
                }
                if (this._model instanceof Pageable) {
                    Pageable m = (Pageable)((Object)this._model);
                    m.setPageSize(this._pgi.getPageSize());
                    m.setActivePage(this._pgi.getActivePage());
                }
            }
        }
    }

    private void newInternalPaging() {
        MeshElement.InternalPaging paging = new MeshElement.InternalPaging(this);
        paging.setDetailed(true);
        paging.applyProperties();
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getPageSize() != -1) {
            paging.setPageSize(((Pageable)((Object)this._model)).getPageSize());
        }
        paging.setTotalSize(this.getDataLoader().getTotalSize());
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getActivePage() != -1) {
            paging.setActivePage(((Pageable)((Object)this._model)).getActivePage());
        }
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new PGListener();
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._model instanceof PagingEventPublisher) {
            ((PagingEventPublisher)((Object)this._model)).addPagingEventListener((PagingListener)this._pgListener);
        }
        if (this._pgImpListener == null) {
            this._pgImpListener = new PGImpListener();
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        if (this._model instanceof PagingEventPublisher) {
            ((PagingEventPublisher)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
        }
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public Paging getPagingChild() {
        return this._paging;
    }

    @Override
    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    public void setActivePage(Listitem item) {
        int pg;
        if (item != null && item.getParent() == this && (pg = item.getIndex() / this.getPageSize()) != this.getActivePage()) {
            this.setActivePage(pg);
        }
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count != 0) {
            this._visibleItemCount += count;
            if (this.inPagingMold()) {
                Paginal pgi = this.getPaginal();
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
                this.invalidate();
            } else if (((Cropper)this.getDataLoader()).isCropper()) {
                this.getDataLoader().updateModelInfo();
            } else {
                this.smartUpdate("visibleItemCount", this._visibleItemCount);
            }
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public int getGroupCount() {
        return this._groupsInfo.size();
    }

    public List<Listgroup> getGroups() {
        return this._groups;
    }

    public boolean hasGroup() {
        return !this._groupsInfo.isEmpty();
    }

    boolean setReplacingItem(boolean b) {
        boolean old = this._isReplacingItem;
        if (this._model != null) {
            this._isReplacingItem = b;
        }
        return old;
    }

    void fixItemIndices(int j, int to, boolean infront) {
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < this._items.size()) {
            int beginning = j;
            ListIterator<Listitem> it = this._items.listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                int[] g;
                Listitem o = (Listitem)((Object)it.next());
                o.setIndexDirectly(j);
                if (this._isReplacingItem) break;
                if ((!infront || beginning != j) && o instanceof Listgroup && (g = this.getLastGroupsInfoAt(j + (infront ? -1 : 1))) != null) {
                    g[0] = j;
                    if (g[2] != -1) {
                        g[2] = g[2] + (infront ? 1 : -1);
                    }
                }
                ++j;
            }
        }
    }

    Listgroup getListgroupAt(int index) {
        if (this._groupsInfo.isEmpty()) {
            return null;
        }
        int[] g = this.getGroupsInfoAt(index);
        if (g != null) {
            return (Listgroup)this.getItemAtIndex(g[0]);
        }
        return null;
    }

    int getGroupIndex(int index) {
        int j = 0;
        int gindex = -1;
        int[] g2 = null;
        for (int[] g2 : this._groupsInfo) {
            if (index == g2[0]) {
                gindex = j;
            } else if (index < g2[0]) break;
            ++j;
        }
        return gindex != -1 ? gindex : (g2 != null && index < g2[0] + g2[1] ? j - 1 : (g2 != null && index == g2[0] + g2[1] && g2[2] == -1 ? j - 1 : gindex));
    }

    int[] getGroupsInfoAt(int index) {
        return this.getGroupsInfoAt(index, false);
    }

    int[] getLastGroupsInfoAt(int index) {
        int[] rg = null;
        for (int[] g : this._groupsInfo) {
            if (index == g[0]) {
                rg = g;
                continue;
            }
            if (index >= g[0]) continue;
            break;
        }
        return rg;
    }

    int[] getGroupsInfoAt(int index, boolean isListgroup) {
        for (int[] g : this._groupsInfo) {
            if (!(isListgroup ? index == g[0] : index > g[0] && index <= g[0] + g[1])) continue;
            return g;
        }
        return null;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof Listitem) {
            if (newChild instanceof Listgroup && this.inSelectMold()) {
                throw new UnsupportedOperationException("Unsupported Listgroup in Select mold!");
            }
            if (newChild instanceof Listgroupfoot) {
                if (!this.hasGroup()) {
                    throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                }
                if (refChild == null && this.getLastChild() instanceof Listgroupfoot) {
                    throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                }
            }
        } else if (newChild instanceof Listhead) {
            if (this._listhead != null && this._listhead != newChild) {
                throw new UiException("Only one listhead is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warn("Mold select ignores frozen");
            }
        } else if (newChild instanceof Listfoot) {
            if (this._listfoot != null && this._listfoot != newChild) {
                throw new UiException("Only one listfoot is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warn("Mold select ignores listfoot");
            }
        } else if (newChild instanceof Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for Listbox: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    private boolean hasGroupsModel() {
        return this._model instanceof GroupsListModel;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Listitem) {
            int jfrom;
            boolean isReorder;
            boolean bl = isReorder = newChild.getParent() == this;
            if (isReorder) {
                this.checkInvalidateForMoved((Listitem)newChild, true);
            }
            this.fixGroupsInfoBeforeInsert(newChild, (Component)refChild, isReorder);
            if (refChild != null && refChild.getParent() != this) {
                refChild = null;
            }
            if (refChild != null && (refChild == this._listhead || refChild instanceof Auxhead)) {
                refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
            }
            refChild = this.fixRefChildBeforeFoot((Component)refChild);
            Listitem newItem = (Listitem)newChild;
            int n = jfrom = newItem.getParent() == this ? newItem.getIndex() : -1;
            if (super.insertBefore(newChild, refChild)) {
                int fixFrom;
                int jto = refChild instanceof Listitem ? ((Listitem)((Object)refChild)).getIndex() : -1;
                int n2 = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
                if (fixFrom < 0) {
                    newItem.setIndexDirectly(this._items.size() - 1 + this.getDataLoader().getOffset());
                } else {
                    this.fixItemIndices(fixFrom, jfrom >= 0 && jto >= 0 ? (jfrom > jto ? jfrom : jto) : -1, !isReorder);
                }
                int newIndex = newItem.getIndex();
                if (newItem.isSelected()) {
                    if (this._jsel < 0) {
                        this._jsel = newIndex;
                        this._selItems.add(newItem);
                        this.smartUpdateSelection();
                    } else if (this._multiple) {
                        if (this._jsel > newIndex) {
                            this._jsel = newIndex;
                        }
                        this._selItems.add(newItem);
                        this.smartUpdateSelection();
                    } else {
                        newItem.setSelectedDirectly(false);
                    }
                } else if (jfrom < 0) {
                    if (!this.isLoadingModel() && this._jsel >= newIndex) {
                        ++this._jsel;
                    }
                } else if (this._jsel >= 0) {
                    if (jfrom > this._jsel) {
                        if (jto >= 0 && jto <= this._jsel) {
                            ++this._jsel;
                        }
                    } else if (jto < 0 || jto > this._jsel) {
                        --this._jsel;
                    }
                }
                this.fixGroupsInfoAfterInsert(newItem);
                if (!isReorder) {
                    this.afterInsert(newChild);
                }
                return true;
            }
        } else if (newChild instanceof Listhead) {
            boolean added = this._listhead == null;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                this._listhead = (Listhead)newChild;
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Auxhead) {
            boolean added = newChild.getParent() != this;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Frozen) {
            refChild = this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof Listfoot) {
            refChild = this._frozen != null ? this._frozen : this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._listfoot = (Listfoot)newChild;
                return true;
            }
        } else if (newChild instanceof Paging) {
            refChild = null;
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    private Component fixRefChildForHeader(Component refChild) {
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        if (refChild == null || refChild != this._listhead && !(refChild instanceof Auxhead)) {
            refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
        }
        refChild = this.fixRefChildBeforeFoot(refChild);
        return refChild;
    }

    private Component fixRefChildBeforeFoot(Component refChild) {
        if (refChild == null) {
            refChild = this._listfoot != null ? this._listfoot : (this._frozen != null ? this._frozen : this._paging);
        } else if (refChild == this._paging) {
            if (this._listfoot != null) {
                refChild = this._listfoot;
            } else if (this._frozen != null) {
                refChild = this._frozen;
            }
        }
        return refChild;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (child instanceof Listitem && child.getParent() == this) {
            this.beforeRemove(child);
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._listhead == child) {
            this._listhead = null;
            --this._hdcnt;
        } else if (this._listfoot == child) {
            this._listfoot = null;
        } else if (this._frozen == child) {
            this._frozen = null;
        } else if (child instanceof Listitem) {
            Listitem item = (Listitem)child;
            int index = item.getIndex();
            item.setIndexDirectly(-1);
            if (item.isSelected()) {
                this._selItems.remove((Object)item);
                if (this._jsel == index) {
                    this.fixSelectedIndex(index);
                }
                this.smartUpdateSelection();
            } else if (!this.isLoadingModel() && this._jsel >= index) {
                --this._jsel;
            }
            this.fixGroupsInfoAfterRemove(child, index);
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        } else if (child instanceof Auxhead) {
            --this._hdcnt;
        }
        if (((Cropper)this.getDataLoader()).isCropper()) {
            this.getDataLoader().updateModelInfo();
        }
        return true;
    }

    protected void afterInsert(Component comp) {
        if (this._isReplacingItem) {
            return;
        }
        this.updateVisibleCount((Listitem)comp, false);
        this.checkInvalidateForMoved((Listitem)comp, false);
    }

    protected void beforeRemove(Component comp) {
        if (this._isReplacingItem) {
            return;
        }
        this.updateVisibleCount((Listitem)comp, true);
        this.checkInvalidateForMoved((Listitem)comp, true);
    }

    private void updateVisibleCount(Listitem item, boolean isRemove) {
        if (item instanceof Listgroup || item.isVisible()) {
            Listgroup g = this.getListgroupAt(item.getIndex());
            if (item instanceof Listgroupfoot || item instanceof Listgroup || g == null || g.isOpen()) {
                this.addVisibleItemCount(isRemove ? -1 : 1);
            }
            if (item instanceof Listgroup) {
                Listgroup group = (Listgroup)item;
                if (item.getPreviousSibling() instanceof Listitem) {
                    Listitem preRow = (Listitem)item.getPreviousSibling();
                    if (preRow == null) {
                        if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    } else {
                        Listgroup preGroup;
                        Listgroup listgroup = preGroup = preRow instanceof Listgroup ? (Listgroup)preRow : this.getListgroupAt(preRow.getIndex());
                        if (preGroup != null) {
                            if (!preGroup.isOpen() && group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? -group.getVisibleItemCount() : group.getVisibleItemCount());
                            } else if (preGroup.isOpen() && !group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                            }
                        } else if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    }
                } else if (!group.isOpen()) {
                    this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                }
            }
        }
        if (this.inPagingMold()) {
            this.getPaginal().setTotalSize(this.getDataLoader().getTotalSize());
        }
    }

    private void checkInvalidateForMoved(Listitem child, boolean bRemove) {
        if (this.inPagingMold() && !this.isInvalidated()) {
            int j = child.getIndex();
            int pgsz = this.getPageSize();
            int n = (this.getActivePage() + 1) * pgsz;
            if (j >= n) {
                return;
            }
            int cnt = this.getItems().size();
            int n2 = n - pgsz;
            if (!(j < n2 || cnt > n || bRemove && cnt <= n2 + 1)) {
                return;
            }
            this.invalidate();
        }
    }

    private void fixSelectedIndex(int j) {
        if (!this._selItems.isEmpty()) {
            int realj = this.getRealIndex(j);
            if (realj < 0) {
                realj = 0;
            }
            if (realj < this._items.size()) {
                ListIterator<Listitem> it = this._items.listIterator(realj);
                while (it.hasNext()) {
                    Listitem item = (Listitem)((Object)it.next());
                    if (item.isSelected()) {
                        this._jsel = j;
                        return;
                    }
                    ++j;
                }
            }
        }
        this._jsel = -1;
    }

    private void fixGroupsInfoBeforeInsert(Component newChild, Component refChild, boolean isReorder) {
        if (this._isReplacingItem) {
            return;
        }
        if (newChild instanceof Listgroupfoot) {
            if (refChild == null) {
                int idx;
                int[] ginfo;
                if (isReorder && (ginfo = this.getGroupsInfoAt(idx = ((Listgroupfoot)newChild).getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
                int[] g = this._groupsInfo.get(this.getGroupCount() - 1);
                g[2] = this.getItems().get(this.getItems().size() - 1).getIndex();
            } else if (refChild instanceof Listitem) {
                int nindex;
                int[] ginfo;
                int idx = ((Listitem)refChild).getIndex();
                int[] g = this.getGroupsInfoAt(idx);
                if (g == null) {
                    throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                }
                if (g[2] != -1) {
                    throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                }
                if (idx != g[0] + g[1]) {
                    throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                }
                g[2] = idx - 1;
                if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
            } else {
                Component preRefChild = refChild.getPreviousSibling();
                if (preRefChild instanceof Listitem) {
                    int nindex;
                    int[] ginfo;
                    int idx = ((Listitem)preRefChild).getIndex();
                    int[] g = this.getGroupsInfoAt(idx, preRefChild instanceof Listgroup);
                    if (g == null) {
                        throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                    }
                    if (g[2] != -1) {
                        throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                    }
                    if (idx + 1 != g[0] + g[1]) {
                        throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                    }
                    g[2] = idx;
                    if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo[1] = ginfo[1] - 1;
                        ginfo[2] = -1;
                    }
                }
            }
        }
    }

    private void fixGroupsInfoAfterInsert(Listitem newItem) {
        int index;
        int[] g;
        if (this._isReplacingItem) {
            return;
        }
        if (newItem instanceof Listgroup) {
            Listgroup lg = (Listgroup)newItem;
            if (this._groupsInfo.isEmpty()) {
                this._groupsInfo.add(new int[]{lg.getIndex(), this.getItemCount() - lg.getIndex(), -1});
            } else {
                int idx = 0;
                int[] prev = null;
                int[] next = null;
                for (int[] g2 : this._groupsInfo) {
                    if (g2[0] <= lg.getIndex()) {
                        prev = g2;
                        ++idx;
                        continue;
                    }
                    next = g2;
                    break;
                }
                if (prev != null) {
                    int index2 = lg.getIndex();
                    int leng = index2 - prev[0];
                    int size = prev[1] - leng + 1;
                    prev[1] = leng;
                    this._groupsInfo.add(idx, new int[]{index2, size, size > 1 && prev[2] >= index2 ? prev[2] + 1 : -1});
                    if (size > 1 && prev[2] > index2) {
                        prev[2] = -1;
                    }
                } else if (next != null) {
                    this._groupsInfo.add(idx, new int[]{lg.getIndex(), next[0] - lg.getIndex(), -1});
                }
            }
        } else if (!this._groupsInfo.isEmpty() && (g = this.getGroupsInfoAt(index = newItem.getIndex())) != null) {
            g[1] = g[1] + 1;
            if (g[2] != -1 && (g[2] >= index || newItem instanceof Listgroupfoot)) {
                g[2] = g[0] + g[1] - 1;
            }
        }
    }

    private void fixGroupsInfoAfterRemove(Component child, int index) {
        if (!this._isReplacingItem) {
            if (child instanceof Listgroup) {
                int[] prev = null;
                int[] remove = null;
                for (int[] g : this._groupsInfo) {
                    if (g[0] == index) {
                        remove = g;
                        break;
                    }
                    prev = g;
                }
                if (prev != null && remove != null) {
                    prev[1] = prev[1] + (remove[1] - 1);
                }
                this.fixItemIndices(index, -1, false);
                if (remove != null) {
                    int realIndex;
                    this._groupsInfo.remove(remove);
                    int idx = remove[2];
                    if (idx != -1 && (realIndex = this.getRealIndex(idx) - 1) >= 0 && realIndex < this.getItemCount()) {
                        this.removeChild((Component)this.getChildren().get(realIndex));
                    }
                }
            } else if (!this._groupsInfo.isEmpty()) {
                int[] g1;
                int[] g = this.getGroupsInfoAt(index);
                if (g != null) {
                    g[1] = g[1] - 1;
                    if (g[2] != -1) {
                        g[2] = g[2] - 1;
                    }
                    this.fixItemIndices(index, -1, false);
                } else {
                    this.fixItemIndices(index, -1, false);
                }
                if (child instanceof Listgroupfoot && (g1 = this.getGroupsInfoAt(index)) != null) {
                    g1[2] = -1;
                }
            } else {
                this.fixItemIndices(index, -1);
            }
        }
        if (this.hasGroupsModel() && this.getItemCount() <= 0) {
            this._groupsInfo = new LinkedList<int[]>();
        }
    }

    private void fixItemIndices(int j, int to) {
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < this._items.size()) {
            ListIterator<Listitem> it = this._items.listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                ((Listitem)((Object)it.next())).setIndexDirectly(j);
                ++j;
            }
        }
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    public <T> ListModel<T> getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public <D, G, F> GroupsModel<D, G, F> getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            Execution exec;
            if (!(model instanceof Selectable)) {
                throw new UiException(model.getClass() + " must implement " + Selectable.class);
            }
            if (model instanceof GroupsSelectableModel) {
                ((GroupsSelectableModel)((Object)model)).setGroupSelectable(this.isListgroupSelectable());
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    this.resetDataLoader();
                }
                this.getItems().clear();
                if (!this.inSelectMold()) {
                    this.smartUpdate("model", model instanceof GroupsListModel || model instanceof GroupsModel ? "group" : Boolean.valueOf(true));
                }
                this._model = model;
                this.initDataListener();
                this.setAttribute("org.zkoss.zul.BeforeModelItemsRendered", Boolean.TRUE);
            }
            if (this.inPagingMold()) {
                Pageable m;
                Paginal pgi = this.getPaginal();
                Pageable pageable = m = this._model instanceof Pageable ? (Pageable)((Object)this._model) : null;
                if (m != null) {
                    if (m.getPageSize() != -1) {
                        pgi.setPageSize(m.getPageSize());
                    } else {
                        m.setPageSize(pgi.getPageSize());
                    }
                }
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
                if (m != null) {
                    if (m.getActivePage() != -1) {
                        pgi.setActivePage(m.getActivePage());
                    } else {
                        m.setActivePage(pgi.getActivePage());
                    }
                }
            }
            boolean defer = (exec = Executions.getCurrent()) == null ? false : exec.getAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid()) != null;
            boolean rod = this.evalRod();
            if (!defer || !rod) {
                this.getDataLoader().syncModel(-1, -1);
                this.removeAttribute("org.zkoss.zul.BeforeModelItemsRendered");
            }
            if (!Listbox.doSort(this)) {
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.getItems().clear();
            if (!this.inSelectMold()) {
                this.smartUpdate("model", false);
            }
            this.getDataLoader().updateModelInfo();
        }
    }

    private static boolean doSort(Listbox listbox) {
        Listhead hds = listbox.getListhead();
        if (!listbox.isAutosort() || hds == null) {
            return false;
        }
        for (Listheader hd : hds.getChildren()) {
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    public void setModel(GroupsModel<?, ?, ?> model) {
        if (model instanceof AbstractGroupsModel) {
            ((AbstractGroupsModel)model).setGroupSelectable(this.isListgroupSelectable());
        }
        this.setModel(model != null ? GroupsListModel.toListModel(model) : null);
    }

    public <T> ListitemRenderer<T> getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ListitemRenderer<?> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof ListitemRendererExt || this._renderer instanceof ListitemRendererExt) {
                    this.getItems().clear();
                    this.getDataLoader().syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.getDataLoader().syncModel(-1, -1);
                } else {
                    Execution exec = Executions.getCurrent();
                    boolean defer = exec == null ? false : exec.getAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid()) != null;
                    boolean rod = this.evalRod();
                    if (!defer || !rod) {
                        this.getDataLoader().syncModel(-1, -1);
                    }
                }
            }
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ListitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.doInitRenderer();
    }

    public void onPagingInitRender() {
        this.removeAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED);
        this.doInitRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitRenderer() {
        if (this._model != null) {
            this.setMultiple(((Selectable)((Object)this._model)).isMultiple());
        }
        Renderer renderer = new Renderer();
        try {
            Listitem item;
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
            } else {
                pgsz = this.inSelectMold() ? this.getItemCount() : this.getDataLoader().getLimit();
                ofs = this.inSelectMold() ? 0 : this.getDataLoader().getOffset();
            }
            int cnt = this.getItemCount() + this.getDataLoader().getOffset();
            if (ofs >= cnt && (ofs = cnt - pgsz) < 0) {
                ofs = 0;
            }
            int j = 0;
            int realOfs = ofs - this.getDataLoader().getOffset();
            if (realOfs < 0) {
                realOfs = 0;
            }
            boolean open = true;
            Listitem listitem = item = this.getItems().size() <= realOfs ? null : this.getItems().get(realOfs);
            while (j < pgsz && item != null) {
                Listitem nxt = Listbox.nextListitem(item);
                if (item.isVisible() && (open || item instanceof Listgroupfoot || item instanceof Listgroup)) {
                    renderer.render(item, j + ofs);
                }
                if (item instanceof Listgroup) {
                    open = ((Listgroup)item).isOpen();
                }
                item = nxt;
                ++j;
            }
            this.getDataLoader().updateModelInfo();
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
        this.removeAttribute("org.zkoss.zul.BeforeModelItemsRendered");
    }

    private static Listitem nextListitem(Listitem item) {
        Component c = item.getNextSibling();
        return c instanceof Listitem ? (Listitem)c : null;
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    private void postOnPagingInitRender() {
        if (this.getAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED) == null && this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onPagingInitRender", (Component)this, null);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int type = event.getType();
        if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
            Listbox.doSort(this);
        } else if (type == 4) {
            if (!this._ignoreDataSelectionEvent) {
                if (event.getIndex0() > -1) {
                    this.setSelectedIndex(event.getIndex0());
                }
                this.doSelectionChanged();
            }
        } else if (type == 6) {
            this.setMultiple(((Selectable)((Object)this._model)).isMultiple());
        } else if (type == 11) {
            this.disableClientUpdate(true);
        } else if (type == 12) {
            this.disableClientUpdate(false);
        } else {
            if (this.getAttribute("org.zkoss.zul.BeforeModelItemsRendered") != null && (type == 1 || type == 2)) {
                return;
            }
            this.getDataLoader().doListDataChange(event);
            this.postOnInitRender();
            if (event.getType() == 3 && this._model instanceof Sortable && this._listhead != null) {
                Sortable smodel = (Sortable)Generics.cast(this._model);
                List headers = Generics.cast((List)this._listhead.getChildren());
                boolean found = false;
                for (Listheader col : headers) {
                    if (found) {
                        col.setSortDirection("natural");
                        continue;
                    }
                    Comparator cmpr = (Comparator)Generics.cast((Object)col.getSortAscending());
                    String dir = smodel.getSortDirection(cmpr);
                    boolean bl = found = !"natural".equals(dir);
                    if (!found) {
                        cmpr = (Comparator)Generics.cast((Object)col.getSortDescending());
                        dir = smodel.getSortDirection(cmpr);
                        found = !"natural".equals(dir);
                    }
                    col.setSortDirection(dir);
                }
            }
            if (this._model.getSize() == 0) {
                this.resetDataLoader(true);
            }
        }
    }

    private void doSelectionChanged() {
        Selectable<Object> smodel = this.getSelectableModel();
        Set<Object> selObjs = smodel.getSelection();
        int expSelCnt = selObjs.size();
        if (expSelCnt == 0) {
            this.clearSelection();
            return;
        }
        if (!this._multiple && this._jsel >= 0) {
            if (smodel.isSelected(this._model.getElementAt(this._jsel))) {
                return;
            }
            this.getSelectedItem().setSelected(false);
        }
        int selCnt = 0;
        for (Listitem item : this._items) {
            if (item.isLoaded()) {
                boolean sel = selObjs.contains(this._model.getElementAt(item.getIndex()));
                if (sel) {
                    ++selCnt;
                }
                item.setSelected(sel);
            }
            if (selCnt != expSelCnt || selCnt < this._selItems.size()) continue;
            break;
        }
    }

    private Selectable<Object> getSelectableModel() {
        return (Selectable)((Object)this._model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listitem renderItem(Listitem li) {
        if (this._model != null && li != null && !li.isLoaded()) {
            Renderer renderer = new Renderer();
            try {
                renderer.render(li, li.getIndex());
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        this._renderAll = true;
        this.getDataLoader().setLoadAll(this._renderAll);
        Renderer renderer = new Renderer();
        if (!this.getItems().isEmpty()) {
            try {
                Listitem item = this.getItems().get(0);
                int index = item.getIndex();
                while (item != null) {
                    Listitem nxt = Listbox.nextListitem(item);
                    renderer.render(item, index++);
                    item = nxt;
                }
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set<? extends Listitem> items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            for (Listitem listitem : items) {
                renderer.render(listitem, listitem.getIndex());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                if (this.getModel() != null) {
                    this.getDataLoader().syncModel(0, this.initRodSize());
                    this.postOnInitRender();
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this._topPad = 0;
                this._currentTop = 0;
                this._currentLeft = 0;
                Events.postEvent((int)10001, (Event)new PagingEvent("onPagingImpl", (Component)this._pgi, this._pgi.getActivePage()));
                this.invalidate();
            }
        }
    }

    public String getEmptyMessage() {
        return this._emptyMessage;
    }

    public void setEmptyMessage(String emptyMessage) {
        if (!Objects.equals((Object)emptyMessage, (Object)this._emptyMessage)) {
            this._emptyMessage = emptyMessage;
            this.smartUpdate("emptyMessage", this._emptyMessage);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-listbox" : this._zclass;
    }

    private boolean evalRod() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.rod", false, true) && !(this._model instanceof GroupsListModel);
    }

    private void setFocusIndex(int index) {
        if (index != this._focusIndex) {
            this._focusIndex = index;
            this.smartUpdate("focusIndex", index);
        }
    }

    DataLoader getDataLoader() {
        if (this._dataLoader == null) {
            this._rod = this.evalRod();
            String loadercls = Library.getProperty((String)"org.zkoss.zul.listbox.DataLoader.class");
            try {
                this._dataLoader = this._rod && loadercls != null ? (DataLoader)Classes.forNameByThread((String)loadercls).newInstance() : new ListboxDataLoader();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            this._dataLoader.init((Component)this, 0, this.initRodSize());
        }
        return this._dataLoader;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (oldpage == null) {
            Execution exec = Executions.getCurrent();
            exec.setAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid(), (Object)Boolean.TRUE);
            exec.setAttribute("zkoss.Listbox.attached_" + this.getUuid(), (Object)Boolean.TRUE);
            this._modelInitListener = new ModelInitListener();
            this.addEventListener("onInitModel", (EventListener)this._modelInitListener);
            Events.postEvent((int)20000, (Event)new Event("onInitModel", (Component)this));
        }
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model.addListDataListener(this._dataListener);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
        }
    }

    private void resetDataLoader() {
        this.resetDataLoader(true);
    }

    private void resetDataLoader(boolean shallReset) {
        if (this._dataLoader != null) {
            if (shallReset) {
                this._dataLoader.reset();
                this.smartUpdate("_lastoffset", 0);
            }
            this._dataLoader = null;
        }
        if (shallReset) {
            this.smartUpdate("resetDataLoader", true);
            this._currentTop = 0;
            this._currentLeft = 0;
            this._anchorTop = 0;
            this._anchorLeft = 0;
            this._topPad = 0;
        }
    }

    @Override
    public Object clone() {
        Listbox clone = (Listbox)super.clone();
        clone.init();
        clone._pgListener = null;
        clone._pgImpListener = null;
        int offset = clone.getDataLoader().getOffset();
        clone.afterUnmarshal(offset);
        int limit = clone.getDataLoader().getLimit();
        clone.resetDataLoader(false);
        clone.getDataLoader().init((Component)clone, offset, limit);
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
            clone.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
            clone.removeAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED);
            clone.getDataLoader().setLoadAll(this._renderAll);
        }
        clone._groupsInfo.addAll(this._groupsInfo);
        return clone;
    }

    private void afterUnmarshal(int index) {
        for (Object child : this.getChildren()) {
            if (child instanceof Listitem) {
                Listitem li = (Listitem)((Object)child);
                li.setIndexDirectly(index++);
                if (!li.isSelected()) continue;
                this._selItems.add(li);
                continue;
            }
            if (child instanceof Listhead) {
                this._listhead = (Listhead)((Object)child);
                continue;
            }
            if (child instanceof Listfoot) {
                this._listfoot = (Listfoot)((Object)child);
                continue;
            }
            if (child instanceof Frozen) {
                this._frozen = (Frozen)((Object)child);
                continue;
            }
            if (!(child instanceof Paging)) continue;
            this._paging = (Paging)child;
            this._pgi = this._paging;
            this.addPagingListener(this._pgi);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
        if (this._dataLoader != null) {
            s.writeInt(this._dataLoader.getOffset());
            s.writeInt(this._dataLoader.getLimit());
        } else {
            s.writeInt(0);
            s.writeInt(100);
        }
        int size = this._groupsInfo.size();
        s.writeInt(size);
        if (size > 0) {
            s.writeObject(this._groupsInfo);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int size;
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (ListitemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        int offset = s.readInt();
        this.afterUnmarshal(offset);
        int limit = s.readInt();
        this.resetDataLoader(false);
        this.getDataLoader().init((Component)this, offset, limit);
        if (this._model != null) {
            this.initDataListener();
            this.getDataLoader().setLoadAll(this._renderAll);
            if (this._model instanceof ListModelMap) {
                for (Listitem item : this.getItems()) {
                    item.setValue(this._model.getElementAt(item.getIndex()));
                }
            }
        }
        if ((size = s.readInt()) > 0) {
            List groupsInfo = (List)s.readObject();
            for (int i = 0; i < size; ++i) {
                this._groupsInfo.add((int[])groupsInfo.get(i));
            }
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._rows > 0) {
            renderer.render("rows", this.getRows());
        }
        this.render(renderer, "name", this._name);
        this.render(renderer, "emptyMessage", this._emptyMessage);
        if (this._tabindex != 0) {
            renderer.render("tabindex", this._tabindex);
        }
        if (this.inSelectMold()) {
            this.render(renderer, "multiple", this.isMultiple());
            this.render(renderer, "disabled", this.isDisabled());
            if (this._maxlength > 0) {
                renderer.render("maxlength", this._maxlength);
            }
        } else {
            this.render(renderer, "oddRowSclass", this._scOddRow);
            this.render(renderer, "checkmark", this.isCheckmark());
            this.render(renderer, "multiple", this.isMultiple());
            if (this._model != null) {
                SelectionControl selectionControl;
                this.render(renderer, "model", this._model instanceof GroupsListModel || this._model instanceof GroupsModel ? "group" : Boolean.valueOf(true));
                if (this.isMultiple() && (selectionControl = this.getSelectableModel().getSelectionControl()) != null) {
                    renderer.render("$$selectAll", selectionControl.isSelectAll());
                }
            }
            if (!"100%".equals(this._innerWidth)) {
                this.render(renderer, "innerWidth", this._innerWidth);
            }
            if (this._currentTop != 0) {
                renderer.render("_currentTop", this._currentTop);
            }
            if (this._currentLeft != 0) {
                renderer.render("_currentLeft", this._currentLeft);
            }
            if (this._anchorTop != 0) {
                renderer.render("_anchorTop", this._anchorTop);
            }
            if (this._anchorLeft != 0) {
                renderer.render("_anchorLeft", this._anchorLeft);
            }
            renderer.render("_topPad", this._topPad);
            renderer.render("_totalSize", this.getDataLoader().getTotalSize());
            renderer.render("_offset", this.getDataLoader().getOffset());
            if (this._rod) {
                int sz;
                if (((Cropper)this.getDataLoader()).isCropper()) {
                    renderer.render("_listbox$rod", true);
                }
                if ((sz = this.initRodSize()) != 50) {
                    renderer.render("initRodSize", this.initRodSize());
                }
                if (!this.inPagingMold() && this._jsel >= 0) {
                    renderer.render("_selInView", this._jsel);
                }
            }
            if (this._nonselTags != null) {
                renderer.render("nonselectableTags", this._nonselTags);
            }
            if (Listbox.isCheckmarkDeselectOther()) {
                renderer.render("_cdo", true);
            }
            if (!this.isRightSelect()) {
                renderer.render("rightSelect", false);
            }
            if (this.isListgroupSelectable()) {
                renderer.render("groupSelect", true);
            }
            if (this.isSelectOnHighlightDisabled()) {
                renderer.render("selectOnHighlightDisabled", true);
            }
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("paginal", (Object)this._pgi);
            if (this._model == null) {
                renderer.render("_listbox$noSelectAll", true);
            }
        }
        if (this._focusIndex > -1) {
            renderer.render("focusIndex", this._focusIndex);
        }
    }

    private boolean isRightSelect() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.rightSelect", true, true);
    }

    @Override
    protected boolean isAutohidePaging() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.autohidePaging", true, true);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.listbox.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    protected boolean isSelectOnHighlightDisabled() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.selectOnHighlight.disabled", false, true);
    }

    private int preloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        int sz = size != null ? Integer.parseInt(size) : this._preloadsz;
        if ((sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.listbox.preloadSize", sz, true)) < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private int initRodSize() {
        int sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.listbox.initRodSize", 50, true);
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.listbox.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    private static boolean isCheckmarkDeselectOther() {
        if (_ckDeselectOther == null) {
            _ckDeselectOther = "true".equals(Library.getProperty((String)"org.zkoss.zul.listbox.checkmarkDeselectOthers"));
        }
        return _ckDeselectOther;
    }

    private boolean isListgroupSelectable() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.groupSelect", false, true);
    }

    private <T> Set<T> collectUnselectedObjects(Set<T> previousSelection, Set<T> currentSelection) {
        LinkedHashSet<T> prevSeldItems;
        LinkedHashSet<Object> linkedHashSet = prevSeldItems = previousSelection != null ? new LinkedHashSet<T>(previousSelection) : new LinkedHashSet();
        if (currentSelection != null && prevSeldItems.size() > 0) {
            prevSeldItems.removeAll(currentSelection);
        }
        return prevSeldItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onDataLoading")) {
            if (this._rod) {
                Executions.getCurrent().setAttribute("zkoss.zul.listbox.onDataLoading." + this.getUuid(), (Object)Boolean.TRUE);
            }
            Events.postEvent((Event)DataLoadingEvent.getDataLoadingEvent(request, this.preloadSize()));
        } else if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size != oldsize) {
                int begin = this.getActivePage() * oldsize;
                int end = begin + oldsize;
                end = Math.min(this.getPaginal().getTotalSize(), end);
                int sel = this.getSelectedIndex();
                if (sel < 0 || sel < begin || sel >= end) {
                    sel = size > oldsize ? end - 1 : begin;
                }
                int newpg = sel / size;
                this.setPageSize(size);
                this.setActivePage(newpg);
                Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            }
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else if (cmd.equals("onAnchorPos")) {
            Map data = request.getData();
            this._anchorTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._anchorLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else if (cmd.equals("onTopPad")) {
            this._topPad = AuRequests.getInt((Map)request.getData(), (String)"topPad", (int)0);
        } else if (cmd.equals("onSelect")) {
            Set<Object> unselectedObjects;
            Set<Listitem> unselectedItems;
            Map m;
            int to;
            int from;
            Paginal pgi;
            Selectable<Object> smodel;
            if (this._rod && Executions.getCurrent().getAttribute("zkoss.zul.listbox.onDataLoading." + this.getUuid()) != null) {
                return;
            }
            Desktop desktop = request.getDesktop();
            Map data = request.getData();
            List sitems = Generics.cast((List)((List)data.get("items")));
            boolean selectAll = Boolean.parseBoolean(data.get("selectAll") + "");
            boolean paging = this.inPagingMold();
            LinkedHashSet<Listitem> prevSeldItems = new LinkedHashSet<Listitem>(this._selItems);
            HashSet<Listitem> curSeldItems = AuRequests.convertToItems((Desktop)desktop, (List)sitems);
            LinkedHashSet<Listitem> realPrevSeldItems = new LinkedHashSet<Listitem>(prevSeldItems);
            LinkedHashSet<Object> prevSeldObjects = this._model != null ? new LinkedHashSet<Object>(this.getSelectableModel().getSelection()) : new LinkedHashSet();
            Selectable<Object> selectable = smodel = this._model != null ? this.getSelectableModel() : null;
            if (!this.isListgroupSelectable() && prevSeldItems.size() > 0) {
                for (Object item : prevSeldItems.toArray()) {
                    if (!(item instanceof Listgroup)) continue;
                    prevSeldItems.remove(item);
                    realPrevSeldItems.remove(item);
                }
            }
            if ((pgi = this.getPaginal()) != null) {
                int pgsz = pgi.getPageSize();
                from = pgi.getActivePage() * pgsz;
                to = from + pgsz;
            } else {
                from = 0;
                to = 0;
            }
            if (paging && (!Listbox.isCheckmarkDeselectOther() || selectAll)) {
                for (Object item : realPrevSeldItems.toArray()) {
                    int index = ((Listitem)((Object)item)).getIndex();
                    if (index < to && index >= from) continue;
                    realPrevSeldItems.remove(item);
                }
            }
            if (curSeldItems == null) {
                curSeldItems = new HashSet<Listitem>();
            }
            SelectionControl ctrl = smodel != null ? smodel.getSelectionControl() : null;
            int start = -1;
            int end = -1;
            if (this._rod && (m = Generics.cast((Map)((Map)data.get("range")))) != null) {
                curSeldItems.addAll(this._selItems);
                start = AuRequests.getInt((Map)m, (String)"start", (int)-1);
                end = AuRequests.getInt((Map)m, (String)"end", (int)-1);
                for (Listitem item : this._items) {
                    int index = item.getIndex();
                    if (index < start || index > end || item.isDisabled() || !item.isSelectable()) continue;
                    curSeldItems.add(item);
                }
            }
            this.disableClientUpdate(true);
            boolean oldIDSE = this._ignoreDataSelectionEvent;
            this._ignoreDataSelectionEvent = true;
            try {
                if (AuRequests.getBoolean((Map)request.getData(), (String)"clearFirst")) {
                    this.clearSelection();
                    if (this._model != null) {
                        ((Selectable)((Object)this._model)).clearSelection();
                    }
                }
                if (!this._multiple || this._model == null && !this._rod && !paging && curSeldItems.size() <= 1) {
                    Listitem item = curSeldItems.size() > 0 ? (Listitem)((Object)curSeldItems.iterator().next()) : null;
                    this.selectItem(item);
                    if (this._model != null) {
                        ArrayList selObjs = new ArrayList();
                        if (item != null) {
                            Object ele = this._model.getElementAt(item.getIndex());
                            if (ctrl == null || ctrl.isSelectable(ele)) {
                                selObjs.add(ele);
                            }
                        }
                        this.getSelectableModel().setSelection(selObjs);
                    }
                } else {
                    for (Listitem item : curSeldItems) {
                        if (this._selItems.contains((Object)item)) continue;
                        this.addItemToSelection(item);
                        if (smodel == null) continue;
                        Object ele = this._model.getElementAt(item.getIndex());
                        if (ctrl != null && !ctrl.isSelectable(ele)) continue;
                        smodel.addToSelection(ele);
                    }
                    while (start >= 0 && end >= 0 && start <= end) {
                        if (smodel == null) continue;
                        Object ele = this._model.getElementAt(start++);
                        if (ctrl != null && !ctrl.isSelectable(ele)) continue;
                        smodel.addToSelection(ele);
                    }
                    for (Listitem item : prevSeldItems) {
                        if (curSeldItems.contains((Object)item)) continue;
                        int index = item.getIndex();
                        if (paging && (index < from || index >= to)) continue;
                        this.removeItemFromSelection(item);
                        if (smodel == null) continue;
                        smodel.removeFromSelection(this._model.getElementAt(index));
                    }
                }
            }
            finally {
                this._ignoreDataSelectionEvent = oldIDSE;
                this.disableClientUpdate(false);
            }
            if (this._model != null && paging) {
                prevSeldItems = null;
                unselectedItems = null;
            } else {
                unselectedItems = this.collectUnselectedObjects(realPrevSeldItems, curSeldItems);
            }
            LinkedHashSet selectedObjects = new LinkedHashSet();
            if (this._model == null) {
                prevSeldObjects = null;
                unselectedObjects = null;
            } else {
                for (Listitem i : curSeldItems) {
                    selectedObjects.add(this._model.getElementAt(i.getIndex()));
                }
                unselectedObjects = this.collectUnselectedObjects(prevSeldObjects, smodel.getSelection());
            }
            if (ctrl != null && selectAll) {
                ctrl.setSelectAll(true);
            }
            if (sitems == null || sitems.isEmpty() || this._model == null) {
                selectedObjects = null;
            }
            SelectEvent evt = new SelectEvent("onSelect", (Component)this, curSeldItems, prevSeldItems, unselectedItems, selectedObjects, prevSeldObjects, unselectedObjects, desktop.getComponentByUuidIfAny((String)data.get("reference")), null, AuRequests.parseKeys((Map)data));
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onRender")) {
            Set items = AuRequests.convertToItems((Desktop)request.getDesktop(), this.getRequestData(request));
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && this._preloadsz > 0) {
                Listitem li;
                if (cnt > this._preloadsz) {
                    cnt = this._preloadsz;
                }
                LinkedList<Listitem> toload = new LinkedList<Listitem>();
                Iterator<Listitem> it = this._items.iterator();
                while (it.hasNext() && !items.contains((Object)(li = it.next()))) {
                    if (li.isLoaded()) continue;
                    toload.add(0, li);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    li = it.next();
                    if (li.isLoaded() || !items.add(li)) continue;
                    --cnt;
                }
            }
            this.renderItems(items);
        } else if (cmd.equals("onAcrossPage")) {
            Map data = request.getData();
            int page = AuRequests.getInt((Map)data, (String)"page", (int)0);
            int offset = AuRequests.getInt((Map)data, (String)"offset", (int)0);
            int shift = AuRequests.getInt((Map)data, (String)"shift", (int)0);
            int pageSize = this.getPageSize();
            int index = page * pageSize + offset;
            int from = shift < 0 ? index + shift : index;
            int to = shift > 0 ? index + shift : index;
            int tsz = this.getItemCount();
            int toUI = Math.min(to, tsz - 1);
            if (!this.isMultiple() || shift == 0) {
                if (this._model == null && index >= tsz || this._model != null && index >= this._model.getSize()) {
                    index = tsz - 1;
                }
                this.setSelectedIndex(index);
                this.setFocusIndex(offset < 0 ? pageSize - 1 : offset);
            } else {
                HashSet<Listitem> items = new HashSet<Listitem>();
                for (int i = from; i <= toUI; ++i) {
                    items.add(this._items.get(i));
                }
                this.setSelectedItems(items);
                this.setActivePage(index / pageSize);
                this.setFocusIndex(offset);
            }
            if (this._model != null) {
                boolean oldIDSE = this._ignoreDataSelectionEvent;
                this._ignoreDataSelectionEvent = true;
                try {
                    to = Math.min(to, this._model.getSize() - 1);
                    Selectable<Object> smodel = this.getSelectableModel();
                    if (!smodel.isMultiple() || shift == 0) {
                        if (!smodel.isMultiple()) {
                            from = to;
                        }
                        smodel.clearSelection();
                    }
                    while (from <= to) {
                        smodel.addToSelection(this._model.getElementAt(from++));
                    }
                }
                finally {
                    this._ignoreDataSelectionEvent = oldIDSE;
                }
            }
            SelectEvent evt = new SelectEvent("onSelect", (Component)this, this.getSelectedItems(), (Component)this.getItemAtIndex(index), shift != 0 ? 4 : 0);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onCheckSelectAll")) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            if (this._model != null) {
                Selectable<Object> selectableModel = this.getSelectableModel();
                SelectionControl selectionControl = selectableModel.getSelectionControl();
                if (selectionControl == null) {
                    throw new IllegalStateException("SelectionControl cannot be null, please implement SelectionControl interface for SelectablModel");
                }
                selectionControl.setSelectAll(evt.isChecked());
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onUpdateSelectAll")) {
            SelectionControl selectionControl;
            if (this._model != null && (selectionControl = this.getSelectableModel().getSelectionControl()) != null) {
                Clients.response((AuResponse)new AuInvoke((Component)this, "$doService", new Object[]{cmd, new JSONAware(){

                    public String toJSONString() {
                        return String.valueOf(selectionControl.isSelectAll());
                    }
                }}));
            }
        } else {
            super.service(request, everError);
        }
    }

    private List<String> getRequestData(AuRequest request) {
        return (List)request.getData().get("items");
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setActivePage(pg);
        }
        super.setActivePage(pg);
    }

    @Override
    public void setPageSize(int pgsz) throws WrongValueException {
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setPageSize(pgsz);
        }
        super.setPageSize(pgsz);
    }

    static {
        Listbox.addClientEvent(Listbox.class, (String)"onRender", (int)8195);
        Listbox.addClientEvent(Listbox.class, (String)"onInnerWidth", (int)8193);
        Listbox.addClientEvent(Listbox.class, (String)"onSelect", (int)1);
        Listbox.addClientEvent(Listbox.class, (String)"onFocus", (int)8192);
        Listbox.addClientEvent(Listbox.class, (String)"onBlur", (int)8192);
        Listbox.addClientEvent(Listbox.class, (String)"onScrollPos", (int)8193);
        Listbox.addClientEvent(Listbox.class, (String)"onTopPad", (int)8192);
        Listbox.addClientEvent(Listbox.class, (String)"onDataLoading", (int)8195);
        Listbox.addClientEvent(Listbox.class, (String)"onPageSize", (int)8195);
        Listbox.addClientEvent(Listbox.class, (String)"onAcrossPage", (int)8195);
        Listbox.addClientEvent(Listbox.class, (String)"onAnchorPos", (int)8193);
        Listbox.addClientEvent(Listbox.class, (String)"onCheckSelectAll", (int)8193);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterGroups
    implements Iterator<Listgroup> {
        private final Iterator<int[]> _it;
        private int _j;

        private IterGroups() {
            this._it = Listbox.this._groupsInfo.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._j < Listbox.this.getGroupCount();
        }

        @Override
        public Listgroup next() {
            Listgroup o = (Listgroup)Listbox.this.getItemAtIndex(this._it.next()[0]);
            ++this._j;
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter
    implements Iterator<Component> {
        private final Iterator<Component> _it;
        private int _j;

        private Iter() {
            this._it = Listbox.this.getChildren().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._j < Listbox.this._hdcnt;
        }

        @Override
        public Component next() {
            Component o = this._it.next();
            ++this._j;
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper,
    Padding {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listbox.this);
        }

        @Override
        public int getHeight() {
            return Listbox.this._topPad;
        }

        @Override
        public void setHeight(int height) {
            Listbox.this._topPad = height;
        }

        public boolean isCropper() {
            return ((Cropper)Listbox.this.getDataLoader()).isCropper();
        }

        public Component getCropOwner() {
            return Listbox.this;
        }

        public Set<? extends Component> getAvailableAtClient() {
            return ((Cropper)Listbox.this.getDataLoader()).getAvailableAtClient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelInitListener
    implements SerializableEventListener<Event>,
    CloneableEventListener<Event> {
        private ModelInitListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (Listbox.this._modelInitListener != null) {
                Listbox.this.removeEventListener("onInitModel", Listbox.this._modelInitListener);
                Listbox.this._modelInitListener = null;
            }
            if (Listbox.this._dataLoader != null) {
                boolean rod = Listbox.this.evalRod();
                if (Listbox.this._rod != rod || Listbox.this.getItems().isEmpty()) {
                    if (Listbox.this._model != null) {
                        Listbox.this.getItems().clear();
                        Listbox.this.resetDataLoader();
                        this.initModel();
                    } else {
                        Listbox.this.resetDataLoader();
                        Executions.getCurrent().removeAttribute("zkoss.Listbox.deferInitModel_" + Listbox.this.getUuid());
                    }
                }
            } else if (Listbox.this._model != null) {
                this.initModel();
            } else {
                Executions.getCurrent().removeAttribute("zkoss.Listbox.deferInitModel_" + Listbox.this.getUuid());
            }
            DataLoader loader = Listbox.this.getDataLoader();
            Paginal pgi = Listbox.this.getPaginal();
            if (pgi != null) {
                pgi.setTotalSize(loader.getTotalSize());
            }
        }

        private void initModel() {
            Executions.getCurrent().removeAttribute("zkoss.Listbox.deferInitModel_" + Listbox.this.getUuid());
            Listbox.this.setModel(Listbox.this._model);
        }

        public Object willClone(Component comp) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemIter
    implements ListIterator<Listitem>,
    Serializable {
        private ListIterator<Listitem> _it;
        private int _j;
        private boolean _bNxt;

        private ItemIter(int index) {
            this._j = index;
        }

        @Override
        public void add(Listitem o) {
            this.prepare();
            this._it.add(o);
            ++this._j;
        }

        @Override
        public boolean hasNext() {
            return this._j < Listbox.this._items.size();
        }

        @Override
        public boolean hasPrevious() {
            return this._j > 0;
        }

        @Override
        public Listitem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Listitem o = this._it.next();
            ++this._j;
            this._bNxt = true;
            return o;
        }

        @Override
        public Listitem previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Listitem o = this._it.previous();
            --this._j;
            this._bNxt = false;
            return o;
        }

        @Override
        public int nextIndex() {
            return this._j;
        }

        @Override
        public int previousIndex() {
            return this._j - 1;
        }

        @Override
        public void remove() {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.remove();
            if (this._bNxt) {
                --this._j;
            }
        }

        @Override
        public void set(Listitem o) {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.set(o);
        }

        private void prepare() {
            if (this._it == null) {
                this._it = Generics.cast(Listbox.this.getChildren().listIterator(this._j + Listbox.this._hdcnt));
            }
        }
    }

    class Renderer {
        private final ListitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = (ListitemRenderer)Listbox.this.getDataLoader().getRealRenderer();
        }

        void render(Listitem item, int index) throws Throwable {
            if (item.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Listcell cell = (Listcell)item.getFirstChild();
            if (!(this._renderer instanceof ListitemRendererExt) || (((ListitemRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            Object value = Listbox.this._model.getElementAt(index);
            SelectionControl ctrl = Listbox.this.getSelectableModel().getSelectionControl();
            boolean selectable = ctrl == null ? true : ctrl.isSelectable(value);
            boolean selected = ((Selectable)((Object)Listbox.this._model)).isSelected(value);
            boolean oldFlag = Listbox.this.setReplacingItem(true);
            try {
                try {
                    this._renderer.render(item, value, index);
                }
                catch (AbstractMethodError ex) {
                    Method m = this._renderer.getClass().getMethod("render", Listitem.class, Object.class);
                    m.setAccessible(true);
                    m.invoke((Object)this._renderer, new Object[]{item, value});
                }
                Object v = item.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    item = (Listitem)((Object)v);
                }
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                item.setLoaded(true);
                throw ex;
            }
            finally {
                Listbox.this.setReplacingItem(oldFlag);
                if (item.getChildren().isEmpty()) {
                    cell.setParent((Component)item);
                }
            }
            if (selected) {
                Listbox.this.addItemToSelection(item);
            }
            if (ctrl != null) {
                item.setSelectable(selectable);
            }
            item.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final ListIterator<Listitem> _it;
        private int _count;
        private boolean _isBeginning;

        private VisibleChildrenIterator() {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
        }

        private VisibleChildrenIterator(boolean isBeginning) {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
            this._isBeginning = isBeginning;
        }

        public boolean hasNext() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.hasNext();
            }
            if (!this._isBeginning && this._count >= Listbox.this.getPaginal().getPageSize()) {
                return false;
            }
            if (this._count == 0 && !this._isBeginning) {
                Paginal pgi = Listbox.this.getPaginal();
                int begin = pgi.getActivePage() * pgi.getPageSize();
                for (int i = 0; i < begin && this._it.hasNext(); ++i) {
                    this.getVisibleRow(this._it.next());
                }
            }
            return this._it.hasNext();
        }

        private Listitem getVisibleRow(Listitem item) {
            Listgroup g;
            if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                int len = g.getItemCount();
                for (int j = 0; j < len && this._it.hasNext(); ++j) {
                    this._it.next();
                }
            }
            while (!item.isVisible() && this._it.hasNext()) {
                item = this._it.next();
            }
            return item;
        }

        public Object next() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.next();
            }
            ++this._count;
            Listitem item = this._it.next();
            return this._it.hasNext() ? this.getVisibleRow(item) : item;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PGImpListener
    implements PagingListener {
        private PGImpListener() {
        }

        public void onEvent(Event event) {
            if (Listbox.this._model != null && Listbox.this.inPagingMold()) {
                Paginal pgi = Listbox.this.getPaginal();
                int pgsz = pgi.getPageSize();
                int ofs = pgi.getActivePage() * pgsz;
                if (event instanceof PagingEvent) {
                    pgsz = ((PagingEvent)event).getPageable().getPageSize();
                    ofs = ((PagingEvent)event).getActivePage() * pgsz;
                }
                if (Listbox.this._rod) {
                    Listbox.this.getDataLoader().syncModel(ofs, pgsz);
                }
                Listbox.this.postOnPagingInitRender();
            }
            Listbox.this.invalidate();
        }

        public Object willClone(Component comp) {
            return null;
        }
    }

    private class PGListener
    implements PagingListener {
        private PGListener() {
        }

        public void onEvent(Event event) {
            Listbox.this._anchorTop = 0;
            Listbox.this._anchorLeft = 0;
            if (event instanceof PagingEvent) {
                PagingEvent pe = (PagingEvent)event;
                int pgsz = pe.getPageable().getPageSize();
                int actpg = pe.getActivePage();
                if ("internalModelEvent".equals(event.getName())) {
                    if (pgsz != -1) {
                        Listbox.this._pgi.setPageSize(pgsz);
                    }
                    if (actpg != -1) {
                        Listbox.this._pgi.setActivePage(actpg);
                    }
                } else if (Listbox.this._model instanceof Pageable) {
                    ((Pageable)((Object)Listbox.this._model)).setActivePage(actpg);
                }
                Events.postEvent((Event)new PagingEvent(event.getName(), (Component)Listbox.this, pe.getPageable(), actpg));
            }
        }

        public Object willClone(Component comp) {
            return null;
        }
    }

    protected class Children
    extends AbstractComponent.Children {
        protected Children() {
            super((AbstractComponent)Listbox.this);
        }

        protected void removeRange(int fromIndex, int toIndex) {
            ListIterator it = this.listIterator(toIndex);
            int n = toIndex - fromIndex;
            while (--n >= 0 && it.hasPrevious()) {
                it.previous();
                it.remove();
            }
        }
    }
}

