/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zkplus.util.ThreadLocals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionContextListener
implements ExecutionInit,
ExecutionCleanup,
EventThreadInit,
EventThreadResume {
    private static final Logger log = LoggerFactory.getLogger(HibernateSessionContextListener.class);
    private static final String HIBERNATE_SESSION_MAP = "org.zkoss.zkplus.hibernate.SessionMap";
    private static final Object SOMETHING = new Object();
    private final boolean _enabled;

    public HibernateSessionContextListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._enabled = app.getConfiguration().isEventThreadEnabled();
    }

    public void init(Execution exec, Execution parent) {
        if (this._enabled && parent == null) {
            Map<Object, Object> map = this.getSessionMap();
            if (map == null) {
                map = new HashMap<Object, Object>();
                this.setSessionMap(map);
            }
            exec.setAttribute(HIBERNATE_SESSION_MAP, map);
            map.put(SOMETHING, null);
        }
    }

    public void cleanup(Execution exec, Execution parent, List errs) {
        if (this._enabled && parent == null) {
            Map<Object, Object> map = this.getSessionMap();
            if (map != null) {
                map.remove(SOMETHING);
            }
            exec.removeAttribute(HIBERNATE_SESSION_MAP);
        }
    }

    public void prepare(Component comp, Event evt) {
    }

    public boolean init(Component comp, Event evt) {
        if (this._enabled) {
            Map map = Generics.cast((Map)((Map)Executions.getCurrent().getAttribute(HIBERNATE_SESSION_MAP)));
            this.setSessionMap(map);
        }
        return true;
    }

    public void beforeResume(Component comp, Event evt) {
    }

    public void afterResume(Component comp, Event evt) {
        if (this._enabled) {
            Map map = Generics.cast((Map)((Map)Executions.getCurrent().getAttribute(HIBERNATE_SESSION_MAP)));
            this.setSessionMap(map);
        }
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void setSessionMap(Map<Object, Object> map) {
        this.getContextThreadLocal().set(map);
    }

    private Map<Object, Object> getSessionMap() {
        return this.getContextThreadLocal().get();
    }

    private ThreadLocal<Map<Object, Object>> getContextThreadLocal() {
        return ThreadLocals.getThreadLocal("org.hibernate.context.ThreadLocalSessionContext", "context");
    }
}

